/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPManualSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.framework.Bundle;

public class PHPManual {
    private static final String BROWSER_ID = "PHPManual.browser";
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("http://[^\\p{javaWhitespace}]*");
    private static int browserCount = 0;
    private PHPManualSite site;
    private static Map<String, String> phpEntityPathMap;

    public PHPManual(PHPManualSite site) {
        this.site = site;
    }

    public PHPManualSite getSite() {
        return this.site;
    }

    public void setSite(PHPManualSite site) {
        this.site = site;
    }

    private synchronized Map<String, String> getPHPEntityPathMap() {
        if (phpEntityPathMap == null) {
            phpEntityPathMap = new HashMap<String, String>();
            URL url = FileLocator.find((Bundle)Platform.getBundle((String)PHPUiPlugin.getPluginId()), (IPath)new Path("phpdoc.mapping"), null);
            if (url != null) {
                try {
                    String line;
                    BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
                    while ((line = r.readLine()) != null) {
                        int sepIdx = line.indexOf(61);
                        if (sepIdx == -1) continue;
                        phpEntityPathMap.put(line.substring(0, sepIdx).toLowerCase(), line.substring(sepIdx + 1));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return phpEntityPathMap;
    }

    public String getURLForManual(IModelElement modelElement) {
        String path;
        block11: {
            if (modelElement == null) {
                throw new IllegalArgumentException();
            }
            path = null;
            if (modelElement instanceof IMethod) {
                try {
                    IModelElement ancestor = ((IMethod)modelElement).getAncestor(7);
                    if (ancestor != null) {
                        path = this.buildPathForClass((IType)ancestor);
                        break block11;
                    }
                    path = this.buildPathForMethod((IMethod)modelElement);
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
            } else if (modelElement instanceof IType) {
                try {
                    path = this.buildPathForClass((IType)modelElement);
                }
                catch (ModelException e) {
                    Logger.logException(e);
                }
            }
        }
        if (path != null) {
            StringBuilder url = new StringBuilder();
            url.append(this.site.getUrl());
            if (!this.site.getUrl().endsWith("/")) {
                url.append("/");
            }
            url.append(path);
            url.append(".");
            url.append(this.site.getExtension());
            return url.toString();
        }
        return null;
    }

    private String getPHPDocLink(Declaration declaration) {
        IPHPDocAwareDeclaration phpDocDeclaration;
        PHPDocBlock docBlock;
        String path = null;
        if (declaration instanceof IPHPDocAwareDeclaration && (docBlock = (phpDocDeclaration = (IPHPDocAwareDeclaration)declaration).getPHPDoc()) != null) {
            PHPDocTag[] pHPDocTagArray = docBlock.getTags(PHPDocTag.TagKind.LINK);
            int n = pHPDocTagArray.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag docTag = pHPDocTagArray[n2];
                Matcher m = HTTP_URL_PATTERN.matcher(docTag.getValue().trim());
                if (m.find()) {
                    try {
                        URL url = new URL(m.group());
                        path = new File(url.getFile()).getName();
                        int extIdx = path.lastIndexOf(46);
                        if (extIdx <= 0) break;
                        path = path.substring(0, extIdx);
                        break;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return path;
    }

    protected String buildPathForClass(IType type) throws ModelException {
        ISourceModule sourceModule;
        ModuleDeclaration moduleDeclaration;
        TypeDeclaration typeDeclaration;
        String path = null;
        if (type != null && (path = this.getPHPDocLink((Declaration)(typeDeclaration = PHPModelUtils.getNodeByClass((ModuleDeclaration)(moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)(sourceModule = type.getSourceModule()))), (IType)type)))) == null) {
            String className = type.getElementName();
            path = this.getPHPEntityPathMap().get(className.toLowerCase());
            if (path == null) {
                path = this.buildPathForClass(type.getElementName());
            }
        }
        return path;
    }

    private String buildPathForClass(String className) {
        StringBuilder buf = new StringBuilder();
        buf.append("class.");
        if (className != null) {
            buf.append(className);
        }
        return buf.toString().toLowerCase();
    }

    protected String buildPathForMethod(IMethod method) {
        MethodDeclaration methodDeclaration;
        ISourceModule sourceModule = method.getSourceModule();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        try {
            methodDeclaration = PHPModelUtils.getNodeByMethod((ModuleDeclaration)moduleDeclaration, (IMethod)method);
        }
        catch (ModelException e) {
            return null;
        }
        String path = this.getPHPDocLink((Declaration)methodDeclaration);
        if (path == null) {
            IType declaringType = method.getDeclaringType();
            if (declaringType != null) {
                String functionName = String.valueOf(declaringType.getElementName()) + "::" + method.getElementName();
                path = this.getPHPEntityPathMap().get(functionName.toLowerCase());
                if (path == null) {
                    path = this.buildPathForMethod(declaringType.getElementName(), method.getElementName());
                }
            } else {
                path = this.getPHPEntityPathMap().get(method.getElementName().toLowerCase());
                if (path == null) {
                    path = this.buildPathForMethod(null, method.getElementName());
                }
            }
        }
        return path;
    }

    protected String buildPathForMethod(String className, String methodName) {
        StringBuilder buf = new StringBuilder();
        buf.append("function.");
        if (className != null) {
            buf.append(className);
            buf.append("-");
        }
        buf.append(Pattern.compile("([A-Z])").matcher(methodName).replaceAll("-$1").replaceAll("_", "-"));
        return buf.toString().toLowerCase().replaceAll("-+", "-");
    }

    public void showFunctionHelp(String url) {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
            IWebBrowser browser = store.getBoolean("phpManualOpenInNewBrowser") ? browserSupport.createBrowser(BROWSER_ID + ++browserCount) : browserSupport.createBrowser(BROWSER_ID);
            if (url.startsWith("mk:")) {
                browser.openURL(new URL(null, url, new MkHandler()));
            } else if (url.startsWith("help://")) {
                String helpURL = url.substring("help://".length());
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpURL);
            } else {
                URL url2 = this.validateUrlExists(url);
                if (url2 == null) {
                    MessageDialog d = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), PHPUIMessages.PHPManual_title, null, PHPUIMessages.PHPManual_noManual_msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    d.open();
                    return;
                }
                browser.openURL(url2);
            }
        }
        catch (PartInitException e) {
            Logger.logException(e);
        }
        catch (MalformedURLException e) {
            Logger.logException(e);
        }
    }

    protected URL validateUrlExists(String url) throws MalformedURLException {
        URL url2 = new URL(url);
        if ("file".equals(url2.getProtocol())) {
            return this.validateFileUrlExists(url, url2);
        }
        return url2;
    }

    private URL validateFileUrlExists(String url, URL url2) {
        File file = new File(url.substring("file://".length()));
        if (file != null && file.exists()) {
            return url2;
        }
        return null;
    }

    private class MkHandler
    extends URLStreamHandler {
        private MkHandler() {
        }

        @Override
        protected URLConnection openConnection(URL arg0) throws IOException {
            return null;
        }
    }
}

