/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.php.internal.debug.ui.launching.ProjectLabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ProjectSelectionDialog
extends ElementListSelectionDialog {
    protected String[] requiredNatures;

    public ProjectSelectionDialog(Shell parent, String[] requiredNatures, String title, String message) {
        super(parent, (ILabelProvider)new ProjectLabelProvider());
        this.requiredNatures = requiredNatures;
        Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (requiredNatures != null && requiredNatures.length > 0) {
            Vector<Object> filteredProjects = new Vector<Object>();
            if (projects != null) {
                int numProjects = projects.length;
                int i = 0;
                while (i < numProjects) {
                    try {
                        if (this.projectHasRequiredNatures((IProject)projects[i])) {
                            filteredProjects.add(projects[i]);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++i;
                }
                this.setElements(filteredProjects.toArray());
            }
        } else {
            this.setElements(projects);
        }
        this.setTitle(title);
        this.setMessage(message);
    }

    private boolean projectHasRequiredNatures(IProject project) throws CoreException {
        if (this.requiredNatures != null) {
            int i = 0;
            while (i < this.requiredNatures.length) {
                if (!project.hasNature(this.requiredNatures[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return true;
    }
}

