/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.php.core.codeassist.CompletionCompanion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.ICompletionStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.ConstantsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.FunctionsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalKeywordsStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.TypesStrategy;
import org.eclipse.php.internal.core.codeassist.strategies.VariablesStrategy;

public class ElementsCompositeStrategy
extends AbstractCompletionStrategy {
    private final Collection<ICompletionStrategy> strategies = new ArrayList<ICompletionStrategy>();

    public ElementsCompositeStrategy(ICompletionContext context, boolean includeKeywords) {
        super(context);
        this.strategies.add(new TypesStrategy(context));
        this.strategies.add(new FunctionsStrategy(context));
        this.strategies.add(new VariablesStrategy(context));
        this.strategies.add(new ConstantsStrategy(context));
        if (includeKeywords) {
            this.strategies.add(new GlobalKeywordsStrategy(context));
        }
    }

    @Override
    public void apply(ICompletionReporter reporter) throws Exception {
        for (ICompletionStrategy strategy : this.strategies) {
            strategy.apply(reporter);
        }
    }

    @Override
    public void init(CompletionCompanion companion) {
        super.init(companion);
        for (ICompletionStrategy strategy : this.strategies) {
            strategy.init(companion);
        }
    }
}

