/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.EmfStandaloneMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.osgi.util.NLS;

public class DeployedQvtModule
extends QvtModule {
    private Module myModule;
    private CompiledUnit myUnit;
    private ResourceSet myCompilationRs;
    private final URI moduleUri;
    private final EPackage.Registry packageRegistry;

    public DeployedQvtModule(URI qvtModuleUri, EPackage.Registry packageRegistry) throws MdaException {
        if (qvtModuleUri == null || qvtModuleUri.segmentCount() == 0) {
            throw new MdaException(NLS.bind((String)Messages.TransformationUtil_InvalidUri, (Object)(qvtModuleUri == null ? String.valueOf(null) : qvtModuleUri.toString())));
        }
        this.moduleUri = qvtModuleUri;
        this.packageRegistry = packageRegistry;
    }

    protected IMetamodelRegistryProvider creatMetamodelRegistryProvider() {
        if (this.packageRegistry != null) {
            return new EmfStandaloneMetamodelRegistryProvider(this.packageRegistry);
        }
        return new EmfStandaloneMetamodelRegistryProvider();
    }

    @Override
    public Module getModule() throws MdaException {
        if (this.myModule == null) {
            UnitProxy srcUnit = UnitResolverFactory.Registry.INSTANCE.getUnit(this.moduleUri);
            if (srcUnit == null) {
                throw new MdaException(NLS.bind((String)CompilerMessages.moduleNotFound, (Object)this.moduleUri));
            }
            QVTOCompiler qvtCompiler = new QVTOCompiler(this.creatMetamodelRegistryProvider());
            QvtCompilerOptions options = this.getQvtCompilerOptions();
            if (options == null) {
                options = new QvtCompilerOptions();
                options.setGenerateCompletionData(false);
            }
            this.myUnit = qvtCompiler.compile(srcUnit, options, null);
            if (!options.isModuleWithErrorAllowed()) {
                this.checkModuleErrors(this.myUnit);
            }
            this.myModule = (Module)this.myUnit.getModules().get(0);
            this.myCompilationRs = this.myUnit.getResourceSet();
        }
        return this.myModule;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.myCompilationRs;
    }

    @Override
    public void cleanup() {
        if (this.myCompilationRs != null) {
            EmfUtil.cleanupResourceSet((ResourceSet)this.myCompilationRs);
        }
    }

    @Override
    public CompiledUnit getUnit() throws MdaException {
        this.getModule();
        return this.myUnit;
    }

    @Override
    public String toString() {
        return "deployed:/" + this.moduleUri;
    }
}

