/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.HashSet;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.anchors.ProjectionStrategy;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.parts.DefaultSelectionFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.SelectionLinkFeedbackPart;
import org.eclipse.gef.zest.fx.parts.EdgeLabelPart;
import org.eclipse.gef.zest.fx.parts.EdgePart;

public class ZestFxSelectionFeedbackPartFactory
extends DefaultSelectionFeedbackPartFactory {
    @Inject
    private Injector injector;

    protected IFeedbackPart<? extends Node> createLinkFeedbackPart(final IVisualPart<? extends Node> anchorage, final Provider<? extends IGeometry> anchorageLinkFeedbackGeometryProvider, final IVisualPart<? extends Node> anchored, final Provider<? extends IGeometry> anchoredLinkFeedbackGeometryProvider, final String role) {
        if (!(anchored.getVisual() instanceof Connection)) {
            Provider<IGeometry> linkFeedbackGeometryProvider = new Provider<IGeometry>(){
                private final ProjectionStrategy computationStrategy = new ProjectionStrategy();

                private Point computePosition(EdgePart anchorage2, String role2) {
                    Point position = null;
                    if ("element-label".equals(role2)) {
                        position = ((Connection)anchorage2.getVisual()).getCenter();
                    } else if ("element-external-label".equals(role2)) {
                        position = ((Connection)anchorage2.getVisual()).getCenter();
                    } else if ("edge-source-label".equals(role2)) {
                        position = ((Connection)anchorage2.getVisual()).getStartPoint();
                    } else if ("edge-target-label".equals(role2)) {
                        position = ((Connection)anchorage2.getVisual()).getEndPoint();
                    } else {
                        throw new IllegalArgumentException("Unsupported role " + role2);
                    }
                    return FX2Geometry.toPoint((Point2D)((Connection)anchorage2.getVisual()).localToScene(Geometry2FX.toFXPoint((Point)position)));
                }

                private Point computePosition(Node n1, IGeometry n1Geometry, Node n2, Point n2RefPoint) {
                    HashSet<Object> parameters = new HashSet<Object>();
                    parameters.add(new DynamicAnchor.AnchorageReferenceGeometry(n1Geometry));
                    parameters.add(new DynamicAnchor.AnchoredReferencePoint(n2RefPoint));
                    return this.computationStrategy.computePositionInScene(n1, n2, parameters);
                }

                public IGeometry get() {
                    Node anchoredVisual = anchored.getVisual();
                    IGeometry anchoredGeometryInLocal = (IGeometry)anchoredLinkFeedbackGeometryProvider.get();
                    Node anchorageVisual = anchorage.getVisual();
                    IGeometry anchorageGeometryInLocal = (IGeometry)anchorageLinkFeedbackGeometryProvider.get();
                    Point targetPointInScene = anchored instanceof EdgeLabelPart ? this.computePosition((EdgePart)anchorage, role) : this.computePosition(anchorageVisual, anchorageGeometryInLocal, anchoredVisual, anchoredGeometryInLocal.getBounds().getCenter());
                    Point sourcePointInScene = this.computePosition(anchoredVisual, anchoredGeometryInLocal, anchorageVisual, FX2Geometry.toPoint((Point2D)anchorageVisual.sceneToLocal(Geometry2FX.toFXPoint((Point)targetPointInScene))));
                    return new Line(sourcePointInScene, targetPointInScene);
                }
            };
            SelectionLinkFeedbackPart part = (SelectionLinkFeedbackPart)this.injector.getInstance(SelectionLinkFeedbackPart.class);
            part.setGeometryProvider((Provider)linkFeedbackGeometryProvider);
            return part;
        }
        return null;
    }
}

