/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.explorer.CDOExplorerElement;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.internal.explorer.AbstractElement;
import org.eclipse.emf.cdo.internal.explorer.bundle.OM;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.container.SetContainer;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public abstract class AbstractManager<T extends CDOExplorerElement>
extends SetContainer<T>
implements CDOExplorerManager<T> {
    private static final Pattern LABEL_PATTERN = Pattern.compile("(.+?) *\\([0-9]+\\)");
    private static final boolean DEBUG = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.internal.explorer.AbstractManager.DEBUG");
    private final File folder;
    private final Map<String, T> elementMap = new HashMap<String, T>();

    public AbstractManager(Class<T> componentType, File folder) {
        super(componentType);
        this.folder = folder;
        folder.mkdirs();
        File[] children = folder.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    try {
                        this.readElement(child);
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
                ++n2;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public abstract String getPropertiesFileName();

    public final File getFolder() {
        return this.folder;
    }

    @Override
    public String getUniqueLabel(String label) {
        HashSet<String> names = new HashSet<String>();
        CDOExplorerElement[] cDOExplorerElementArray = (CDOExplorerElement[])this.getElements();
        int n = cDOExplorerElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOExplorerElement element = cDOExplorerElementArray[n2];
            names.add(element.getLabel());
            ++n2;
        }
        Matcher matcher = LABEL_PATTERN.matcher(label);
        if (matcher.matches()) {
            label = matcher.group(1);
        }
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            String name;
            String string = name = i == 1 ? label : String.valueOf(label) + " (" + i + ")";
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        throw new IllegalStateException("Too many elements");
    }

    public T getElement(String id) {
        return (T)((CDOExplorerElement)this.elementMap.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getElementByLabel(String label) {
        AbstractManager abstractManager = this;
        synchronized (abstractManager) {
            for (CDOExplorerElement element : this.getSet()) {
                if (!ObjectUtil.equals((Object)element.getLabel(), (Object)label)) continue;
                return (T)element;
            }
        }
        return null;
    }

    public T newElement(Properties properties) {
        File child;
        String id;
        int i = 0;
        while (this.elementMap.containsKey(id = Integer.toString(++i)) || (child = new File(this.folder, id)).exists()) {
        }
        T element = this.addElement(child, properties, true);
        return element;
    }

    private void readElement(File folder) {
        Properties properties = AbstractManager.loadProperties(folder, this.getPropertiesFileName());
        if (properties != null) {
            this.addElement(folder, properties, false);
        }
    }

    private T addElement(File folder, Properties properties, boolean newElement) {
        String type = properties.getProperty("type");
        T element = this.createElement(type);
        ((AbstractElement)element).init(folder, type, properties);
        if (newElement) {
            ((AbstractElement)element).save();
        }
        LifecycleUtil.activate(element);
        this.addElement(element);
        this.elementMap.put(element.getID(), element);
        return element;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (DEBUG) {
            IPluginContainer.INSTANCE.putElement("___" + this.getClass().getSimpleName(), "debug", null, (Object)this);
        }
    }

    protected abstract T createElement(String var1);

    public void fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact structuralImpact, Object changedElement) {
        if (changedElement instanceof CDOObject) {
            CDOObject cdoObject = (CDOObject)changedElement;
            changedElement = CDOUtil.getEObject((EObject)cdoObject);
        }
        Object[] objects = new Object[]{changedElement};
        this.fireEvent(new ElementsChangedImpl(this, structuralImpact, objects));
    }

    public void fireElementsChangedEvent(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            CDOObject cdoObject;
            EObject instance;
            Object object = objects[i];
            if (object instanceof CDOObject && (instance = CDOUtil.getEObject((EObject)(cdoObject = (CDOObject)object))) != cdoObject) {
                objects[i] = instance;
            }
            ++i;
        }
        this.fireEvent(new ElementsChangedImpl(this, CDOExplorerManager.ElementsChangedEvent.StructuralImpact.NONE, objects));
    }

    public static void saveProperties(File folder, String fileName, Properties properties, String comment) {
        block5: {
            FileOutputStream out = null;
            try {
                try {
                    folder.mkdirs();
                    File file = new File(folder, fileName);
                    out = new FileOutputStream(file);
                    properties.store(out, comment);
                }
                catch (IOException ex) {
                    OM.LOG.error((Throwable)ex);
                    IOUtil.close(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
            IOUtil.close((Closeable)out);
        }
    }

    public static Properties loadProperties(File folder, String fileName) {
        File file = new File(folder, fileName);
        if (file.isFile()) {
            Properties properties;
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                Properties properties2 = new Properties();
                properties2.load(in);
                properties = properties2;
            }
            catch (Exception ex) {
                try {
                    OM.LOG.error((Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close((Closeable)in);
            }
            IOUtil.close((Closeable)in);
            return properties;
        }
        return null;
    }

    private static final class ElementsChangedImpl
    extends Event
    implements CDOExplorerManager.ElementsChangedEvent {
        private static final long serialVersionUID = 1L;
        private final CDOExplorerManager.ElementsChangedEvent.StructuralImpact structuralImpact;
        private final Object[] changedElements;

        public ElementsChangedImpl(CDOExplorerManager<?> manager, CDOExplorerManager.ElementsChangedEvent.StructuralImpact structuralImpact, Object[] objects) {
            super(manager);
            this.changedElements = objects;
            this.structuralImpact = structuralImpact;
        }

        @Override
        public CDOExplorerManager<?> getSource() {
            return (CDOExplorerManager)super.getSource();
        }

        @Override
        public CDOExplorerManager.ElementsChangedEvent.StructuralImpact getStructuralImpact() {
            return this.structuralImpact;
        }

        @Override
        public final Object[] getChangedElements() {
            return this.changedElements;
        }
    }
}

