/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.pyocd.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.ImmediateDataRequestMonitor;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.core.Configuration;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.core.PyOCD;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.core.preferences.DefaultPreferences;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.ui.TabStartup;
import org.eclipse.embedcdt.internal.debug.gdbjtag.pyocd.ui.Activator;
import org.eclipse.embedcdt.internal.debug.gdbjtag.pyocd.ui.Messages;
import org.eclipse.embedcdt.ui.SystemUIJob;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TabDebugger
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "org.eclipse.embedcdt.debug.gdbjtag.pyocd.ui.ui.debuggertab";
    private ILaunchConfiguration fConfiguration;
    private List<PyOCD.Probe> fProbes;
    private String fSelectedProbeId;
    private boolean fProbeIdListHasUnavailableItem;
    private String fProbeIdListUnavailableId;
    private Map<String, PyOCD.Target> fTargetsByPartNumber;
    private Map<String, PyOCD.Target> fTargetsByName;
    private Text fGdbClientExecutable;
    private Text fGdbClientPathLabel;
    private Text fGdbClientOtherOptions;
    private Text fGdbClientOtherCommands;
    private Button fDoStartGdbServer;
    private Text fGdbServerPathLabel;
    private Link fLink;
    private Text fTargetIpAddress;
    private Text fTargetPortNumber;
    private ControlDecoration fTargetPortNumberDecoration;
    private ControlDecoration fTargetIpAddressDecoration;
    private Combo fGdbServerProbeId;
    private Button fGdbServerRefreshProbes;
    private Text fGdbServerGdbPort;
    private Text fGdbServerTelnetPort;
    private Button fGdbServerOverrideTarget;
    private Combo fGdbServerTargetName;
    private Label fGdbServerDefaultTargetName;
    private Combo fGdbServerBusSpeed;
    private Combo fGdbServerConnectMode;
    private Combo fGdbServerResetType;
    private Button fGdbServerHaltAtHardFault;
    private Button fGdbServerStepIntoInterrupts;
    private Combo fGdbServerFlashMode;
    private Button fGdbServerSmartFlash;
    private Button fGdbServerEnableSemihosting;
    private Button fGdbServerUseGdbSyscallsForSemihosting;
    private Text fGdbServerExecutable;
    private Button fGdbServerBrowseButton;
    private Button fGdbServerVariablesButton;
    private Text fGdbServerOtherOptions;
    private Button fDoGdbServerAllocateConsole;
    private Button fDoGdbServerAllocateSemihostingConsole;
    protected Button fUpdateThreadlistOnSuspend;
    private Set<String> fErrors = new LinkedHashSet<String>();
    private DefaultPreferences fDefaultPreferences;
    private PersistentPreferences fPersistentPreferences;
    private AtomicBoolean fOutstandingProbesLoad = new AtomicBoolean(false);
    private AtomicBoolean fOutstandingTargetsLoad = new AtomicBoolean(false);
    private String fPyocdPathForOutstandingProbesLoad;
    private String fPyocdPathForOutstandingTargetsLoad;
    private RequestMonitor fOutstandingProbesLoadMonitor;
    private RequestMonitor fOutstandingTargetsLoadMonitor;
    private boolean fNeedsDefaultTargetNameRefresh = false;
    private static final int COLUMN_PAD = 30;

    protected TabDebugger(TabStartup tabStartup) {
        this.fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
        this.fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    private Composite createHorizontalLayout(Composite comp, int columns, int spanSub) {
        Composite local = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        if (spanSub > 0) {
            gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - spanSub;
        }
        local.setLayoutData((Object)gd);
        return local;
    }

    public void createControl(Composite parent) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.createControl() ");
        }
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createGdbServerGroup(comp);
        this.createGdbClientControls(comp);
        this.createRemoteControl(comp);
        this.fUpdateThreadlistOnSuspend = new Button(comp, 32);
        this.fUpdateThreadlistOnSuspend.setText(Messages.DebuggerTab_update_thread_list_on_suspend_Text);
        this.fUpdateThreadlistOnSuspend.setToolTipText(Messages.DebuggerTab_update_thread_list_on_suspend_ToolTipText);
        Link restoreDefaults = new Link(comp, 0);
        restoreDefaults.setText(Messages.DebuggerTab_restoreDefaults_Link);
        restoreDefaults.setToolTipText(Messages.DebuggerTab_restoreDefaults_ToolTipText);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        restoreDefaults.setLayoutData((Object)gd);
        this.fUpdateThreadlistOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
        restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabDebugger.this.initializeFromDefaults();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    private void createGdbServerGroup(final Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.DebuggerTab_gdbServerGroup_Text);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        this.fDoStartGdbServer = new Button(comp, 32);
        this.fDoStartGdbServer.setText(Messages.DebuggerTab_doStartGdbServer_Text);
        this.fDoStartGdbServer.setToolTipText(Messages.DebuggerTab_doStartGdbServer_ToolTipText);
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        this.fDoStartGdbServer.setLayoutData((Object)gd);
        Composite subcomp = new Composite(comp, 0);
        gd2 = new GridData(4, 128, true, false);
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        subcomp.setLayoutData((Object)gd2);
        GridLayout layout3 = new GridLayout(2, false);
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        subcomp.setLayout((Layout)layout3);
        Label label = new Label(subcomp, 0);
        label.setText(Messages.DebuggerTab_gdbServerExecutable_Label);
        label.setToolTipText(Messages.DebuggerTab_gdbServerExecutable_ToolTipText);
        Composite local = this.createHorizontalLayout(subcomp, 3, 1);
        this.fGdbServerExecutable = new Text(local, 2052);
        GridData gd3 = new GridData(768);
        this.fGdbServerExecutable.setLayoutData((Object)gd3);
        this.fGdbServerBrowseButton = new Button(local, 0);
        this.fGdbServerBrowseButton.setText(Messages.DebuggerTab_gdbServerExecutableBrowse);
        this.fGdbServerVariablesButton = new Button(local, 0);
        this.fGdbServerVariablesButton.setText(Messages.DebuggerTab_gdbServerExecutableVariable);
        label = new Label(subcomp, 0);
        label.setText(Messages.DebuggerTab_gdbServerActualPath_Label);
        this.fGdbServerPathLabel = new Text(subcomp, 2052);
        GridData gd4 = new GridData(4, 0, true, false);
        gd4.horizontalSpan = 1;
        this.fGdbServerPathLabel.setLayoutData((Object)gd4);
        this.fGdbServerPathLabel.setEnabled(true);
        this.fGdbServerPathLabel.setEditable(false);
        label = new Label(subcomp, 0);
        label.setText("");
        this.fLink = new Link(subcomp, 0);
        this.fLink.setText(Messages.DebuggerTab_gdbServerActualPath_link);
        gd4 = new GridData();
        gd4.horizontalSpan = 1;
        this.fLink.setLayoutData((Object)gd4);
        label = new Label(subcomp, 0);
        label.setText(Messages.DebuggerTab_gdbServerGdbPort_Label);
        label.setToolTipText(Messages.DebuggerTab_gdbServerGdbPort_ToolTipText);
        Composite subcomp2 = new Composite(subcomp, 0);
        gd3 = new GridData(4, 128, true, false);
        subcomp2.setLayoutData((Object)gd3);
        GridLayout layout4 = new GridLayout(2, false);
        layout4.horizontalSpacing = 30;
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        subcomp2.setLayout((Layout)layout4);
        this.fGdbServerGdbPort = new Text(subcomp2, 2052);
        gd3 = new GridData();
        gd3.widthHint = 60;
        this.fGdbServerGdbPort.setLayoutData((Object)gd3);
        this.fDoGdbServerAllocateConsole = new Button(subcomp2, 32);
        this.fDoGdbServerAllocateConsole.setLayoutData((Object)new GridData());
        this.fDoGdbServerAllocateConsole.setText(Messages.DebuggerTab_gdbServerAllocateConsole_Label);
        this.fDoGdbServerAllocateConsole.setToolTipText(Messages.DebuggerTab_gdbServerAllocateConsole_ToolTipText);
        label = new Label(subcomp, 0);
        label.setText(Messages.DebuggerTab_gdbServerTelnetPort_Label);
        label.setToolTipText(Messages.DebuggerTab_gdbServerTelnetPort_ToolTipText);
        subcomp2 = new Composite(subcomp, 0);
        gd3 = new GridData(4, 128, true, false);
        subcomp2.setLayoutData((Object)gd3);
        layout4 = new GridLayout(2, false);
        layout4.horizontalSpacing = 30;
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        subcomp2.setLayout((Layout)layout4);
        this.fGdbServerTelnetPort = new Text(subcomp2, 2052);
        gd3 = new GridData();
        gd3.widthHint = 60;
        this.fGdbServerTelnetPort.setLayoutData((Object)gd3);
        this.fDoGdbServerAllocateSemihostingConsole = new Button(subcomp2, 32);
        this.fDoGdbServerAllocateSemihostingConsole.setLayoutData((Object)new GridData());
        this.fDoGdbServerAllocateSemihostingConsole.setText(Messages.DebuggerTab_gdbServerAllocateTelnetConsole_Label);
        this.fDoGdbServerAllocateSemihostingConsole.setToolTipText(Messages.DebuggerTab_gdbServerAllocateTelnetConsole_ToolTipText);
        this.fDoGdbServerAllocateSemihostingConsole.setLayoutData((Object)new GridData());
        this.createSeparator(comp, ((GridLayout)comp.getLayout()).numColumns);
        Label label2 = new Label(comp, 0);
        label2.setText(Messages.DebuggerTab_gdbServerProbeId_Label);
        label2.setToolTipText(Messages.DebuggerTab_gdbServerProbeId_ToolTipText);
        Composite local2 = this.createHorizontalLayout(comp, 2, 1);
        this.fGdbServerProbeId = new Combo(local2, 12);
        this.fGdbServerProbeId.setToolTipText(Messages.DebuggerTab_gdbServerProbeId_ToolTipText);
        gd4 = new GridData(768);
        this.fGdbServerProbeId.setLayoutData((Object)gd4);
        this.fGdbServerProbeId.setItems(new String[0]);
        this.fGdbServerProbeId.select(0);
        this.fGdbServerRefreshProbes = new Button(local2, 0);
        this.fGdbServerRefreshProbes.setText(Messages.DebuggerTab_gdbServerRefreshProbes_Label);
        label2 = new Label(comp, 0);
        label2.setText(Messages.DebuggerTab_gdbServerDefaultTargetType_Label);
        this.fGdbServerDefaultTargetName = new Label(comp, 0);
        gd2 = new GridData(768);
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerDefaultTargetName.setLayoutData((Object)gd2);
        this.fGdbServerDefaultTargetName.setToolTipText(Messages.DebuggerTab_gdbServerDefaultTargetType_ToolTipText);
        this.fGdbServerOverrideTarget = new Button(comp, 32);
        this.fGdbServerOverrideTarget.setText(Messages.DebuggerTab_gdbServerOverrideTarget_Label);
        this.fGdbServerOverrideTarget.setToolTipText(Messages.DebuggerTab_gdbServerOverrideTarget_ToolTipText);
        gd = new GridData();
        this.fGdbServerOverrideTarget.setLayoutData((Object)gd);
        this.fGdbServerTargetName = new Combo(comp, 4);
        gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerTargetName.setLayoutData((Object)gd);
        this.fGdbServerTargetName.setToolTipText(Messages.DebuggerTab_gdbServerTargetName_ToolTipText);
        label2 = new Label(comp, 0);
        label2.setText(Messages.DebuggerTab_gdbServerBusSpeed_Label);
        label2.setToolTipText(Messages.DebuggerTab_gdbServerBusSpeed_ToolTipText);
        this.fGdbServerBusSpeed = new Combo(comp, 4);
        this.fGdbServerBusSpeed.setToolTipText(Messages.DebuggerTab_gdbServerBusSpeed_ToolTipText);
        gd2 = new GridData();
        gd2.widthHint = 200;
        this.fGdbServerBusSpeed.setLayoutData((Object)gd2);
        this.fGdbServerBusSpeed.setItems(new String[]{"1000000", "2000000", "8000000", "12000000"});
        this.fGdbServerBusSpeed.select(0);
        label2 = new Label(comp, 0);
        label2.setText(Messages.DebuggerTab_gdbServerBusSpeedUnits_Label);
        gd2 = new GridData();
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 2;
        label2.setLayoutData((Object)gd2);
        label2 = new Label(comp, 0);
        label2.setText(Messages.DebuggerTab_gdbServerConnectMode_Label);
        label2.setToolTipText(Messages.DebuggerTab_gdbServerConnectMode_ToolTipText);
        gd2 = new GridData();
        label2.setLayoutData((Object)gd2);
        this.fGdbServerConnectMode = new Combo(comp, 12);
        this.fGdbServerConnectMode.setToolTipText(Messages.DebuggerTab_gdbServerConnectMode_ToolTipText);
        gd2 = new GridData();
        gd2.widthHint = 200;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerConnectMode.setLayoutData((Object)gd2);
        this.fGdbServerConnectMode.setItems(new String[]{Messages.DebuggerTab_gdbServerConnectMode_Halt, Messages.DebuggerTab_gdbServerConnectMode_PreReset, Messages.DebuggerTab_gdbServerConnectMode_UnderReset, Messages.DebuggerTab_gdbServerConnectMode_Attach});
        this.fGdbServerConnectMode.select(0);
        label2 = new Label(comp, 0);
        label2.setText(Messages.DebuggerTab_gdbServerResetType_Label);
        label2.setToolTipText(Messages.DebuggerTab_gdbServerResetType_ToolTipText);
        gd2 = new GridData();
        label2.setLayoutData((Object)gd2);
        this.fGdbServerResetType = new Combo(comp, 12);
        this.fGdbServerResetType.setToolTipText(Messages.DebuggerTab_gdbServerResetType_ToolTipText);
        gd2 = new GridData();
        gd2.widthHint = 200;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerResetType.setLayoutData((Object)gd2);
        this.fGdbServerResetType.setItems(new String[]{Messages.DebuggerTab_gdbServerResetType_Default, Messages.DebuggerTab_gdbServerResetType_Hardware, Messages.DebuggerTab_gdbServerResetType_SoftwareDefault, Messages.DebuggerTab_gdbServerResetType_SoftwareSysResetReq, Messages.DebuggerTab_gdbServerResetType_SoftwareVectReset, Messages.DebuggerTab_gdbServerResetType_SoftwareEmulated});
        this.fGdbServerResetType.select(0);
        label2 = new Label(comp, 0);
        label2.setText(Messages.DebuggerTab_gdbServerFlashMode_Label);
        label2.setToolTipText(Messages.DebuggerTab_gdbServerFlashMode_ToolTipText);
        gd2 = new GridData();
        label2.setLayoutData((Object)gd2);
        this.fGdbServerFlashMode = new Combo(comp, 12);
        this.fGdbServerFlashMode.setToolTipText(Messages.DebuggerTab_gdbServerFlashMode_ToolTipText);
        gd2 = new GridData();
        gd2.widthHint = 200;
        this.fGdbServerFlashMode.setLayoutData((Object)gd2);
        this.fGdbServerFlashMode.setItems(new String[]{Messages.DebuggerTab_gdbServerFlashMode_AutoErase, Messages.DebuggerTab_gdbServerFlashMode_ChipErase, Messages.DebuggerTab_gdbServerFlashMode_SectorErase});
        this.fGdbServerFlashMode.select(0);
        this.fGdbServerSmartFlash = new Button(comp, 32);
        this.fGdbServerSmartFlash.setText(Messages.DebuggerTab_gdbServerSmartFlash_Label);
        this.fGdbServerSmartFlash.setToolTipText(Messages.DebuggerTab_gdbServerSmartFlash_ToolTipText);
        gd2 = new GridData();
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 2;
        gd2.horizontalIndent = 30;
        this.fGdbServerSmartFlash.setLayoutData((Object)gd2);
        subcomp = new Composite(comp, 0);
        gd2 = new GridData();
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        subcomp.setLayoutData((Object)gd2);
        layout3 = new GridLayout(2, false);
        layout3.horizontalSpacing = 30;
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        subcomp.setLayout((Layout)layout3);
        this.fGdbServerHaltAtHardFault = new Button(subcomp, 32);
        this.fGdbServerHaltAtHardFault.setLayoutData((Object)new GridData());
        this.fGdbServerHaltAtHardFault.setText(Messages.DebuggerTab_gdbServerHaltAtHardFault_Label);
        this.fGdbServerHaltAtHardFault.setToolTipText(Messages.DebuggerTab_gdbServerHaltAtHardFault_ToolTipText);
        this.fGdbServerStepIntoInterrupts = new Button(subcomp, 32);
        this.fGdbServerStepIntoInterrupts.setLayoutData((Object)new GridData());
        this.fGdbServerStepIntoInterrupts.setText(Messages.DebuggerTab_gdbServerStepIntoInterrupts_Label);
        this.fGdbServerStepIntoInterrupts.setToolTipText(Messages.DebuggerTab_gdbServerStepIntoInterrupts_ToolTipText);
        this.fGdbServerEnableSemihosting = new Button(subcomp, 32);
        this.fGdbServerEnableSemihosting.setLayoutData((Object)new GridData());
        this.fGdbServerEnableSemihosting.setText(Messages.DebuggerTab_gdbServerEnableSemihosting_Label);
        this.fGdbServerEnableSemihosting.setToolTipText(Messages.DebuggerTab_gdbServerEnableSemihosting_ToolTipText);
        this.fGdbServerUseGdbSyscallsForSemihosting = new Button(subcomp, 32);
        this.fGdbServerUseGdbSyscallsForSemihosting.setLayoutData((Object)new GridData());
        this.fGdbServerUseGdbSyscallsForSemihosting.setText(Messages.DebuggerTab_gdbServerUseGdbSyscallsForSemihosting_Label);
        this.fGdbServerUseGdbSyscallsForSemihosting.setToolTipText(Messages.DebuggerTab_gdbServerUseGdbSyscallsForSemihosting_ToolTipText);
        label2 = new Label(comp, 0);
        label2.setText(Messages.DebuggerTab_gdbServerOther_Label);
        label2.setToolTipText(Messages.DebuggerTab_gdbServerOther_ToolTipText);
        gd2 = new GridData();
        gd2.verticalAlignment = 128;
        label2.setLayoutData((Object)gd2);
        this.fGdbServerOtherOptions = new Text(comp, 2626);
        this.fGdbServerOtherOptions.setToolTipText(Messages.DebuggerTab_gdbServerOther_ToolTipText);
        gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerOtherOptions.setLayoutData((Object)gd2);
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        SelectionAdapter scheduleUpdateJobSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        this.fDoStartGdbServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.doStartGdbServerChanged();
                if (TabDebugger.this.fDoStartGdbServer.getSelection()) {
                    TabDebugger.this.fTargetIpAddress.setText("localhost");
                    TabDebugger.this.fTargetPortNumber.setText(TabDebugger.this.fGdbServerGdbPort.getText());
                }
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TabDebugger.this.fConfiguration != null) {
                    TabDebugger.this.updateProbes();
                    TabDebugger.this.updateTargets();
                }
                TabDebugger.this.updateGdbServerActualPath();
            }
        });
        this.fGdbServerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.DebuggerTab_gdbServerExecutableBrowse_Title, TabDebugger.this.fGdbServerExecutable);
            }
        });
        this.fGdbServerVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbServerExecutable);
            }
        });
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = e.text;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(text);
                }
                int ret = -1;
                if ("global".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.internal.debug.gdbjtag.pyocd.ui.globalPreferencePage", null, null).open();
                } else if ("workspace".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.internal.debug.gdbjtag.pyocd.ui.workspacePreferencePage", null, null).open();
                } else if ("project".equals(text)) {
                    if (!$assertionsDisabled && TabDebugger.this.fConfiguration == null) {
                        throw new AssertionError();
                    }
                    IProject project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)TabDebugger.this.fConfiguration);
                    ret = PreferencesUtil.createPropertyDialogOn((Shell)parent.getShell(), (IAdaptable)project, (String)"org.eclipse.embedcdt.internal.debug.gdbjtag.pyocd.ui.projectPropertiesPage", null, null, (int)0).open();
                }
                if (ret == 0) {
                    TabDebugger.this.updateGdbServerActualPath();
                }
            }
        });
        this.fGdbServerGdbPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.fTargetPortNumber.setText(TabDebugger.this.fGdbServerGdbPort.getText());
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerProbeId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.probeWasSelected(((Combo)e.widget).getSelectionIndex());
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerRefreshProbes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateProbes();
            }
        });
        this.fGdbServerOverrideTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.overrideTargetChanged();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerTelnetPort.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerBusSpeed.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerTargetName.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerConnectMode.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerResetType.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerHaltAtHardFault.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerStepIntoInterrupts.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerFlashMode.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerSmartFlash.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerEnableSemihosting.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerUseGdbSyscallsForSemihosting.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerOtherOptions.addModifyListener(scheduleUpdateJobModifyListener);
        this.fDoGdbServerAllocateConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fDoGdbServerAllocateSemihostingConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
    }

    private void createGdbClientControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.DebuggerTab_gdbSetupGroup_Text);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        Label label = new Label(comp, 0);
        label.setText(Messages.DebuggerTab_gdbCommand_Label);
        label.setToolTipText(Messages.DebuggerTab_gdbCommand_ToolTipText);
        Composite local = this.createHorizontalLayout(comp, 3, 1);
        this.fGdbClientExecutable = new Text(local, 2052);
        GridData gd3 = new GridData(768);
        this.fGdbClientExecutable.setLayoutData((Object)gd3);
        Button browseButton = new Button(local, 0);
        browseButton.setText(Messages.DebuggerTab_gdbCommandBrowse);
        Button variableButton = new Button(local, 0);
        variableButton.setText(Messages.DebuggerTab_gdbCommandVariable);
        label = new Label(comp, 0);
        label.setText(Messages.DebuggerTab_gdbCommandActualPath_Label);
        this.fGdbClientPathLabel = new Text(comp, 2052);
        GridData gd4 = new GridData(4, 0, true, false);
        gd4.horizontalSpan = 4;
        this.fGdbClientPathLabel.setLayoutData((Object)gd4);
        this.fGdbClientPathLabel.setEnabled(true);
        this.fGdbClientPathLabel.setEditable(false);
        label = new Label(comp, 0);
        label.setText(Messages.DebuggerTab_gdbOtherOptions_Label);
        label.setToolTipText(Messages.DebuggerTab_gdbOtherOptions_ToolTipText);
        gd4 = new GridData();
        label.setLayoutData((Object)gd4);
        this.fGdbClientOtherOptions = new Text(comp, 2052);
        gd4 = new GridData(768);
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientOtherOptions.setLayoutData((Object)gd4);
        label = new Label(comp, 0);
        label.setText(Messages.DebuggerTab_gdbOtherCommands_Label);
        label.setToolTipText(Messages.DebuggerTab_gdbOtherCommands_ToolTipText);
        gd4 = new GridData();
        gd4.verticalAlignment = 128;
        label.setLayoutData((Object)gd4);
        this.fGdbClientOtherCommands = new Text(comp, 2626);
        gd4 = new GridData(4, 4, true, true);
        gd4.heightHint = 60;
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientOtherCommands.setLayoutData((Object)gd4);
        this.fGdbClientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
                TabDebugger.this.updateGdbClientActualPath();
            }
        });
        this.fGdbClientOtherOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbClientOtherCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.DebuggerTab_gdbCommandBrowse_Title, TabDebugger.this.fGdbClientExecutable);
            }
        });
        variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbClientExecutable);
            }
        });
    }

    private void createRemoteControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.DebuggerTab_remoteGroup_Text);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = this.createHorizontalLayout((Composite)group, 2, -1);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.DebuggerTab_ipAddressLabel);
        this.fTargetIpAddress = new Text(comp, 2048);
        GridData gd2 = new GridData();
        gd2.widthHint = 125;
        this.fTargetIpAddress.setLayoutData((Object)gd2);
        this.fTargetIpAddressDecoration = new ControlDecoration((Control)this.fTargetIpAddress, 16512);
        this.fTargetIpAddressDecoration.setDescriptionText(Messages.DebuggerTab_ipAddressWarningDecoration);
        this.fTargetIpAddressDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
        label = new Label(comp, 0);
        label.setText(Messages.DebuggerTab_portNumberLabel);
        this.fTargetPortNumber = new Text(comp, 2048);
        gd2 = new GridData();
        gd2.widthHint = 125;
        this.fTargetPortNumber.setLayoutData((Object)gd2);
        this.fTargetPortNumberDecoration = new ControlDecoration((Control)this.fTargetPortNumber, 16512);
        this.fTargetPortNumberDecoration.setDescriptionText(Messages.DebuggerTab_portNumberWarningDecoration);
        this.fTargetPortNumberDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
        this.fTargetIpAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.updateDecorations();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fTargetPortNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        this.fTargetPortNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.updateDecorations();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fTargetIpAddressDecoration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.fTargetIpAddress.setText("localhost");
            }
        });
        this.fTargetPortNumberDecoration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.fTargetPortNumber.setText(TabDebugger.this.fGdbServerGdbPort.getText());
            }
        });
    }

    private void updateGdbServerActualPath() {
        if (this.fConfiguration == null) {
            return;
        }
        String fullCommand = Configuration.getGdbServerCommand((ILaunchConfiguration)this.fConfiguration, (String)this.fGdbServerExecutable.getText());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.updateActualpath() \"" + fullCommand + "\"");
        }
        if (fullCommand == null) {
            this.fGdbServerPathLabel.setText("");
        } else {
            this.fGdbServerPathLabel.setText(fullCommand);
        }
    }

    private void updateGdbClientActualPath() {
        if (this.fConfiguration == null) {
            return;
        }
        String fullCommand = Configuration.getGdbClientCommand((ILaunchConfiguration)this.fConfiguration, (String)this.fGdbClientExecutable.getText());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.updateGdbClientActualPath() \"" + fullCommand + "\"");
        }
        if (fullCommand == null) {
            this.fGdbClientPathLabel.setText("");
        } else {
            this.fGdbClientPathLabel.setText(fullCommand);
        }
    }

    private void doStartGdbServerChanged() {
        boolean enabled = this.fDoStartGdbServer.getSelection();
        this.fGdbServerExecutable.setEnabled(enabled);
        this.fGdbServerBrowseButton.setEnabled(enabled);
        this.fGdbServerVariablesButton.setEnabled(enabled);
        this.fGdbServerOtherOptions.setEnabled(enabled);
        this.fGdbServerGdbPort.setEnabled(enabled);
        this.fGdbServerTelnetPort.setEnabled(enabled);
        this.fGdbServerProbeId.setEnabled(enabled);
        this.fGdbServerBusSpeed.setEnabled(enabled);
        this.fGdbServerOverrideTarget.setEnabled(enabled);
        this.fGdbServerTargetName.setEnabled(enabled && this.fGdbServerOverrideTarget.getSelection());
        this.fGdbServerConnectMode.setEnabled(enabled);
        this.fGdbServerResetType.setEnabled(enabled);
        this.fGdbServerHaltAtHardFault.setEnabled(enabled);
        this.fGdbServerStepIntoInterrupts.setEnabled(enabled);
        this.fGdbServerEnableSemihosting.setEnabled(enabled);
        this.fGdbServerUseGdbSyscallsForSemihosting.setEnabled(enabled);
        this.fGdbServerFlashMode.setEnabled(enabled);
        this.fGdbServerSmartFlash.setEnabled(enabled);
        this.fDoGdbServerAllocateConsole.setEnabled(enabled);
        this.fDoGdbServerAllocateSemihostingConsole.setEnabled(enabled);
        this.fGdbServerPathLabel.setEnabled(enabled);
        this.fLink.setEnabled(enabled);
        this.updateDecorations();
    }

    private void overrideTargetChanged() {
        boolean enabled = this.fGdbServerOverrideTarget.getSelection();
        this.fGdbServerTargetName.setEnabled(enabled);
    }

    private String getPyOCDExecutablePath() {
        File file;
        this.deregisterError(Msgs.INVALID_PYOCD_EXECUTABLE);
        this.deregisterError(Msgs.OLD_PYOCD_EXECUTABLE);
        String path = Configuration.getGdbServerCommand((ILaunchConfiguration)this.fConfiguration, (String)this.fGdbServerExecutable.getText());
        if (path == null || path.isEmpty()) {
            this.registerError(Msgs.INVALID_PYOCD_EXECUTABLE);
            return null;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.printf("pyOCD resolved path = %s\n", path);
        }
        if (!(file = new File(path)).exists()) {
            this.registerError(Msgs.INVALID_PYOCD_EXECUTABLE);
            return null;
        }
        if (file.isDirectory()) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("pyOCD path is invalid\n", new Object[0]);
            }
            this.registerError(Msgs.INVALID_PYOCD_EXECUTABLE);
            return null;
        }
        return path;
    }

    private int indexForProbeIdInList(List<PyOCD.Probe> probeList, String probeId) {
        if (probeList != null) {
            int index = 0;
            for (PyOCD.Probe b : probeList) {
                if (b.fUniqueId.equals(probeId)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    private int indexForProbeId(String probeId) {
        return this.indexForProbeIdInList(this.fProbes, probeId);
    }

    private void updateDefaultTargetName(int index) {
        PyOCD.Target target;
        String targetName = this.fProbes.get((int)index).fTargetName;
        if (this.fTargetsByName != null && (target = this.fTargetsByName.get(targetName)) != null) {
            this.fGdbServerDefaultTargetName.setText(this.getFormattedTargetName(target));
            return;
        }
        this.fNeedsDefaultTargetNameRefresh = true;
    }

    private void probeWasSelected(int index) {
        if (this.fProbeIdListHasUnavailableItem) {
            if (index == 0) {
                this.fSelectedProbeId = this.fProbeIdListUnavailableId;
                return;
            }
            --index;
        }
        PyOCD.Probe selectedProbe = this.fProbes.get(index);
        this.fSelectedProbeId = selectedProbe.fUniqueId;
        this.updateDefaultTargetName(index);
    }

    private void selectActiveProbe() {
        int index = this.indexForProbeId(this.fSelectedProbeId);
        if (index != -1) {
            if (this.fProbeIdListHasUnavailableItem) {
                ++index;
            }
            this.fGdbServerProbeId.select(index);
            this.updateDefaultTargetName(index);
        } else {
            assert (this.fProbeIdListHasUnavailableItem);
            this.fGdbServerProbeId.select(0);
        }
    }

    private String getFormattedTargetName(PyOCD.Target target) {
        StringBuilder builder = new StringBuilder(target.fVendor);
        String[] stringArray = target.fFamilies;
        int n = target.fFamilies.length;
        int n2 = 0;
        while (n2 < n) {
            String family = stringArray[n2];
            builder.append(" > ");
            builder.append(family);
            ++n2;
        }
        builder.append(" > ");
        builder.append(target.fPartNumber);
        builder.append(" (");
        builder.append(target.fName);
        builder.append(")");
        return builder.toString();
    }

    private void selectActiveTarget() {
        if (this.fConfiguration != null) {
            try {
                String configTargetName = this.fConfiguration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTargetName", "");
                PyOCD.Target target = this.fTargetsByName.get(configTargetName);
                if (target != null) {
                    this.fGdbServerTargetName.setText(this.getFormattedTargetName(target));
                } else {
                    this.fGdbServerTargetName.setText(configTargetName);
                }
            }
            catch (CoreException e) {
                Activator.log((IStatus)e.getStatus());
            }
        }
    }

    private void clearPyocdErrors(boolean isProbe) {
        if (isProbe) {
            this.deregisterError(Msgs.PROBES_FAILURE_PARSING_PYOCD_OUTPUT);
            this.deregisterError(Msgs.PROBES_FAILURE_INVOKING_PYOCD);
            this.deregisterError(Msgs.PROBES_PYOCD_TIMEOUT);
        } else {
            this.deregisterError(Msgs.TARGETS_FAILURE_PARSING_PYOCD_OUTPUT);
            this.deregisterError(Msgs.TARGETS_FAILURE_INVOKING_PYOCD);
            this.deregisterError(Msgs.TARGETS_PYOCD_TIMEOUT);
        }
    }

    private void setPyocdError(IStatus status, boolean isProbe) {
        if (isProbe) {
            switch (status.getCode()) {
                case 1: 
                case 4: {
                    this.registerError(Msgs.PROBES_FAILURE_PARSING_PYOCD_OUTPUT);
                    break;
                }
                case 3: {
                    this.registerError(Msgs.PROBES_PYOCD_TIMEOUT);
                    break;
                }
                default: {
                    this.registerError(Msgs.PROBES_FAILURE_INVOKING_PYOCD);
                    break;
                }
            }
        } else {
            switch (status.getCode()) {
                case 1: 
                case 4: {
                    this.registerError(Msgs.TARGETS_FAILURE_PARSING_PYOCD_OUTPUT);
                    break;
                }
                case 3: {
                    this.registerError(Msgs.TARGETS_PYOCD_TIMEOUT);
                    break;
                }
                default: {
                    this.registerError(Msgs.TARGETS_FAILURE_INVOKING_PYOCD);
                }
            }
        }
    }

    private void updatePyocdLoadingMessage() {
        if (this.fOutstandingProbesLoad.getAcquire() || this.fOutstandingTargetsLoad.getAcquire()) {
            this.setMessage(Msgs.LOADING_DATA);
        } else {
            this.setMessage(null);
        }
        this.scheduleUpdateJob();
    }

    private void updateProbes() {
        String path = this.getPyOCDExecutablePath();
        if (path != null) {
            if (this.fOutstandingProbesLoad.getAcquire()) {
                if (path.equals(this.fPyocdPathForOutstandingProbesLoad)) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.printf("skipping probes load due to outstanding load\n", new Object[0]);
                    }
                    return;
                }
                this.fOutstandingProbesLoadMonitor.cancel();
            }
            this.fOutstandingProbesLoad.setRelease(true);
            this.fPyocdPathForOutstandingProbesLoad = path;
            this.updatePyocdLoadingMessage();
            ImmediateDataRequestMonitor<List<PyOCD.Probe>> monitor = new ImmediateDataRequestMonitor<List<PyOCD.Probe>>(){

                protected void handleCompleted() {
                    TabDebugger.this.fOutstandingProbesLoad.setRelease(false);
                    TabDebugger.this.fOutstandingProbesLoadMonitor = null;
                    if (TabDebugger.this.getControl().isDisposed()) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.printf("(probes) bailing on updating debugger tab because it has been disposed\n", new Object[0]);
                        }
                        return;
                    }
                    ArrayList<String> itemList = new ArrayList<String>();
                    final List probes = (List)this.getData();
                    IStatus status = this.getStatus();
                    boolean isOK = status.isOK();
                    if (!isOK) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.printf("error getting probes from pyocd: %s\n", status.toString());
                        }
                        TabDebugger.this.setPyocdError(this.getStatus(), false);
                        TabDebugger.this.fProbes = new ArrayList<PyOCD.Probe>();
                    } else {
                        TabDebugger.this.clearPyocdErrors(true);
                        if (!$assertionsDisabled && probes == null) {
                            throw new AssertionError();
                        }
                        if (Activator.getInstance().isDebugging()) {
                            System.out.printf("probes = %s\n", probes);
                        }
                        Collections.sort(probes, PyOCD.Probe.DESCRIPTION_COMPARATOR);
                        int currentProbeIndex = TabDebugger.this.indexForProbeIdInList(probes, TabDebugger.this.fSelectedProbeId);
                        if (currentProbeIndex == -1) {
                            TabDebugger.this.fProbeIdListHasUnavailableItem = true;
                            TabDebugger.this.fProbeIdListUnavailableId = TabDebugger.this.fSelectedProbeId;
                            if (TabDebugger.this.fSelectedProbeId.isEmpty()) {
                                itemList.add(Messages.DebuggerTab_gdbServerSelectProbe);
                            } else {
                                itemList.add(String.format(Messages.DebuggerTab_gdbServerUnconnectedProbe, TabDebugger.this.fSelectedProbeId));
                            }
                        } else {
                            TabDebugger.this.fProbeIdListHasUnavailableItem = false;
                        }
                        for (PyOCD.Probe probe : probes) {
                            itemList.add(probe.getDescription());
                        }
                    }
                    final String[] items = itemList.toArray(new String[itemList.size()]);
                    SystemUIJob updateJob = new SystemUIJob("update probes"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (TabDebugger.this.getControl().isDisposed()) {
                                if (Activator.getInstance().isDebugging()) {
                                    System.out.printf("(probes, from UI job) bailing on updating debugger tab 'because it has been disposed\n", new Object[0]);
                                }
                                return Status.OK_STATUS;
                            }
                            (this).TabDebugger.this.fGdbServerProbeId.setItems(items);
                            (this).TabDebugger.this.fProbes = probes;
                            TabDebugger.this.selectActiveProbe();
                            TabDebugger.this.updatePyocdLoadingMessage();
                            TabDebugger.this.scheduleUpdateJob();
                            return Status.OK_STATUS;
                        }
                    };
                    updateJob.schedule();
                }
            };
            this.fOutstandingProbesLoadMonitor = monitor;
            PyOCD.getInstance().getProbes(path, (DataRequestMonitor)monitor);
        } else {
            this.fGdbServerProbeId.setItems(new String[0]);
            this.fProbes = new ArrayList<PyOCD.Probe>();
        }
    }

    private void updateTargets() {
        String path = this.getPyOCDExecutablePath();
        if (path != null) {
            if (this.fOutstandingTargetsLoad.getAcquire()) {
                if (path.equals(this.fPyocdPathForOutstandingTargetsLoad)) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.printf("skipping targets load due to outstanding load\n", new Object[0]);
                    }
                    return;
                }
                this.fOutstandingTargetsLoadMonitor.cancel();
            }
            this.fOutstandingTargetsLoad.setRelease(true);
            this.fPyocdPathForOutstandingTargetsLoad = path;
            this.updatePyocdLoadingMessage();
            ImmediateDataRequestMonitor<List<PyOCD.Target>> monitor = new ImmediateDataRequestMonitor<List<PyOCD.Target>>(){

                protected void handleCompleted() {
                    TabDebugger.this.fOutstandingTargetsLoad.setRelease(false);
                    TabDebugger.this.fOutstandingTargetsLoadMonitor = null;
                    if (TabDebugger.this.getControl().isDisposed()) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.printf("(targets) bailing on updating debugger tab because it has been disposed\n", new Object[0]);
                        }
                        return;
                    }
                    ArrayList<String> itemList = new ArrayList<String>();
                    final HashMap<String, PyOCD.Target> newTargetsByPartNumber = new HashMap<String, PyOCD.Target>();
                    final HashMap<String, PyOCD.Target> newTargetsByName = new HashMap<String, PyOCD.Target>();
                    IStatus status = this.getStatus();
                    boolean isOK = status.isOK();
                    if (!isOK) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.printf("error getting targets from pyocd: %s\n", status.toString());
                        }
                        TabDebugger.this.setPyocdError(this.getStatus(), false);
                    } else {
                        TabDebugger.this.clearPyocdErrors(false);
                        List targets = (List)this.getData();
                        if (!$assertionsDisabled && targets == null) {
                            throw new AssertionError();
                        }
                        if (Activator.getInstance().isDebugging()) {
                            System.out.printf("target = %s\n", targets);
                        }
                        Collections.sort(targets, PyOCD.Target.PART_NUMBER_COMPARATOR);
                        for (PyOCD.Target target : targets) {
                            String formattedPartNumber = TabDebugger.this.getFormattedTargetName(target);
                            itemList.add(formattedPartNumber);
                            newTargetsByPartNumber.put(formattedPartNumber, target);
                            newTargetsByName.put(target.fName, target);
                        }
                    }
                    final String[] itemsToUpdate = itemList.toArray(new String[itemList.size()]);
                    SystemUIJob updateJob = new SystemUIJob("update targets"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (TabDebugger.this.getControl().isDisposed()) {
                                if (Activator.getInstance().isDebugging()) {
                                    System.out.printf("(targets, from UI job) bailing on updating debugger tab because it has been disposed\n", new Object[0]);
                                }
                                return Status.OK_STATUS;
                            }
                            (this).TabDebugger.this.fGdbServerTargetName.setItems(itemsToUpdate);
                            (this).TabDebugger.this.fTargetsByPartNumber = newTargetsByPartNumber;
                            (this).TabDebugger.this.fTargetsByName = newTargetsByName;
                            TabDebugger.this.selectActiveTarget();
                            if ((this).TabDebugger.this.fNeedsDefaultTargetNameRefresh) {
                                TabDebugger.this.selectActiveProbe();
                            }
                            TabDebugger.this.updatePyocdLoadingMessage();
                            TabDebugger.this.scheduleUpdateJob();
                            return Status.OK_STATUS;
                        }
                    };
                    updateJob.schedule();
                }
            };
            this.fOutstandingTargetsLoadMonitor = monitor;
            PyOCD.getInstance().getTargets(path, (DataRequestMonitor)monitor);
        } else {
            this.fGdbServerTargetName.setItems(new String[0]);
            this.fTargetsByPartNumber = new HashMap<String, PyOCD.Target>();
            this.fTargetsByName = new HashMap<String, PyOCD.Target>();
        }
    }

    protected void updateDecorations() {
        if (this.fDoStartGdbServer.getSelection()) {
            if ("localhost".equals(this.fTargetIpAddress.getText())) {
                this.fTargetIpAddressDecoration.hide();
            } else {
                this.fTargetIpAddressDecoration.show();
            }
            if (this.fGdbServerGdbPort.getText().equals(this.fTargetPortNumber.getText())) {
                this.fTargetPortNumberDecoration.hide();
            } else {
                this.fTargetPortNumberDecoration.show();
            }
        } else {
            this.fTargetIpAddressDecoration.hide();
            this.fTargetPortNumberDecoration.hide();
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.initializeFrom() " + configuration.getName());
        }
        this.fConfiguration = configuration;
        try {
            Boolean booleanDefault = this.fPersistentPreferences.getGdbServerDoStart();
            this.fDoStartGdbServer.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", booleanDefault.booleanValue()));
            String stringDefault = this.fPersistentPreferences.getGdbServerExecutable();
            this.fGdbServerExecutable.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerExecutable", stringDefault));
            this.fGdbServerGdbPort.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerGdbPortNumber", 3333)));
            this.fGdbServerTelnetPort.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTelnetPortNumber", 4444)));
            this.fSelectedProbeId = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBoardId", "");
            this.fGdbServerOverrideTarget.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOverrideTarget", false));
            this.fGdbServerTargetName.setText("");
            this.fGdbServerConnectMode.select(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerConnectMode", 0));
            this.fGdbServerResetType.select(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerResetType", 0));
            this.fGdbServerHaltAtHardFault.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerHaltAtHardFault", true));
            this.fGdbServerStepIntoInterrupts.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerStepIntoInterrutps", false));
            this.fGdbServerFlashMode.select(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashMode", 2));
            this.fGdbServerSmartFlash.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerSmartFlash", true));
            booleanDefault = this.fPersistentPreferences.getPyOCDEnableSemihosting();
            this.fGdbServerEnableSemihosting.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerEnableSemihosting", booleanDefault.booleanValue()));
            this.fGdbServerUseGdbSyscallsForSemihosting.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerUseGdbSyscalls", false));
            this.fGdbServerBusSpeed.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBusSpeed", 1000000)));
            stringDefault = this.fPersistentPreferences.getGdbServerOtherOptions();
            this.fGdbServerOtherOptions.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOther", stringDefault));
            if (EclipseUtils.isWindows()) {
                this.fDoGdbServerAllocateConsole.setSelection(true);
            } else {
                this.fDoGdbServerAllocateConsole.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateConsole", true));
            }
            this.fDoGdbServerAllocateSemihostingConsole.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateSemihostingConsole", true));
            stringDefault = this.fPersistentPreferences.getGdbClientExecutable();
            String gdbCommandAttr = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringDefault);
            this.fGdbClientExecutable.setText(gdbCommandAttr);
            stringDefault = this.fPersistentPreferences.getGdbClientOtherOptions();
            this.fGdbClientOtherOptions.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherOptions", stringDefault));
            stringDefault = this.fPersistentPreferences.getGdbClientCommands();
            this.fGdbClientOtherCommands.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherCommands", stringDefault));
            this.fTargetIpAddress.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost"));
            int storedPort = 0;
            storedPort = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
            if (storedPort <= 0 || 65535 < storedPort) {
                storedPort = 3333;
            }
            String portString = Integer.toString(storedPort);
            this.fTargetPortNumber.setText(portString);
            boolean updateThreadsOnSuspend = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
            this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
            this.doStartGdbServerChanged();
            this.overrideTargetChanged();
            this.updateProbes();
            this.updateTargets();
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.initializeFrom() completed " + configuration.getName());
        }
    }

    public void initializeFromDefaults() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.initializeFromDefaults()");
        }
        this.fDoStartGdbServer.setSelection(true);
        String stringDefault = this.fDefaultPreferences.getGdbServerExecutable();
        this.fGdbServerExecutable.setText(stringDefault);
        this.fGdbServerGdbPort.setText(Integer.toString(3333));
        this.fGdbServerTelnetPort.setText(Integer.toString(4444));
        this.fGdbServerOverrideTarget.setSelection(false);
        this.fGdbServerTargetName.setText("");
        this.fGdbServerConnectMode.select(0);
        this.fGdbServerResetType.select(0);
        this.fGdbServerHaltAtHardFault.setSelection(true);
        this.fGdbServerStepIntoInterrupts.setSelection(false);
        this.fGdbServerFlashMode.select(2);
        this.fGdbServerSmartFlash.setSelection(true);
        this.fGdbServerEnableSemihosting.setSelection(true);
        this.fGdbServerUseGdbSyscallsForSemihosting.setSelection(false);
        this.fGdbServerBusSpeed.setText(Integer.toString(1000000));
        stringDefault = this.fDefaultPreferences.getPyocdConfig();
        this.fGdbServerOtherOptions.setText(stringDefault);
        if (EclipseUtils.isWindows()) {
            this.fDoGdbServerAllocateConsole.setSelection(true);
        } else {
            this.fDoGdbServerAllocateConsole.setSelection(true);
        }
        this.fDoGdbServerAllocateSemihostingConsole.setSelection(true);
        stringDefault = this.fDefaultPreferences.getGdbClientExecutable();
        this.fGdbClientExecutable.setText(stringDefault);
        this.fGdbClientOtherOptions.setText("");
        this.fGdbClientOtherCommands.setText("set mem inaccessible-by-default off\n");
        this.fTargetIpAddress.setText("localhost");
        if (this.fDoStartGdbServer.getSelection()) {
            this.fTargetPortNumber.setText(this.fGdbServerGdbPort.getText());
        } else {
            String portString = Integer.toString(3333);
            this.fTargetPortNumber.setText(portString);
        }
        this.doStartGdbServerChanged();
        this.overrideTargetChanged();
        this.updateProbes();
        this.updateTargets();
        this.fUpdateThreadlistOnSuspend.setSelection(false);
    }

    public String getId() {
        return TAB_ID;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.activated() " + workingCopy.getName());
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.deactivated() " + workingCopy.getName());
        }
    }

    public void dispose() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.dispose()");
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.isValid() " + launchConfig.getName());
        }
        if (!this.fOutstandingProbesLoad.getAcquire() && !this.fOutstandingTargetsLoad.getAcquire()) {
            this.setMessage(null);
        }
        boolean result = true;
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            if (this.fGdbServerExecutable != null && this.fGdbServerExecutable.getText().trim().isEmpty()) {
                result = false;
            }
            if (this.fGdbServerGdbPort != null && this.fGdbServerGdbPort.getText().trim().isEmpty()) {
                this.registerError(Msgs.INVALID_GDBSERVER_PORT);
                result = false;
            } else {
                this.deregisterError(Msgs.INVALID_GDBSERVER_PORT);
            }
            if (this.fGdbServerTelnetPort != null && this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
                this.registerError(Msgs.INVALID_TELNET_PORT);
                result = false;
            } else {
                this.deregisterError(Msgs.INVALID_TELNET_PORT);
            }
        }
        if (this.fGdbClientExecutable != null && this.fGdbClientExecutable.getText().trim().isEmpty()) {
            this.registerError(Msgs.INVALID_GDBCLIENT_EXECUTABLE);
            result = false;
        } else {
            this.deregisterError(Msgs.INVALID_GDBCLIENT_EXECUTABLE);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.isValid() " + launchConfig.getName() + " = " + result);
        }
        return result;
    }

    public boolean canSave() {
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            if (this.fGdbServerExecutable != null && this.fGdbServerExecutable.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerGdbPort != null && this.fGdbServerGdbPort.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerTelnetPort != null && this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int port;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.performApply() " + configuration.getName() + ", dirty=" + this.isDirty());
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU PyOCD");
        boolean booleanValue = this.fDoStartGdbServer.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", booleanValue);
        this.fPersistentPreferences.putGdbServerDoStart(booleanValue);
        String stringValue = this.fGdbServerExecutable.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerExecutable", stringValue);
        this.fPersistentPreferences.putGdbServerExecutable(stringValue);
        if (!this.fGdbServerGdbPort.getText().trim().isEmpty()) {
            port = Integer.parseInt(this.fGdbServerGdbPort.getText().trim());
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerGdbPortNumber", port);
        } else {
            Activator.log((String)"empty fGdbServerGdbPort");
        }
        if (!this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
            port = Integer.parseInt(this.fGdbServerTelnetPort.getText().trim());
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTelnetPortNumber", port);
        } else {
            Activator.log((String)"empty fGdbServerTelnetPort");
        }
        if (this.fSelectedProbeId != null) {
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBoardId", this.fSelectedProbeId);
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOverrideTarget", this.fGdbServerOverrideTarget.getSelection());
        if (this.fTargetsByPartNumber != null) {
            String targetPartNumber = this.fGdbServerTargetName.getText().trim();
            String targetName = "";
            if (!targetPartNumber.isEmpty()) {
                PyOCD.Target target = this.fTargetsByPartNumber.get(targetPartNumber);
                targetName = target != null ? target.fName : targetPartNumber;
            }
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTargetName", targetName);
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerConnectMode", this.fGdbServerConnectMode.getSelectionIndex());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerResetType", this.fGdbServerResetType.getSelectionIndex());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerHaltAtHardFault", this.fGdbServerHaltAtHardFault.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerStepIntoInterrutps", this.fGdbServerStepIntoInterrupts.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashMode", this.fGdbServerFlashMode.getSelectionIndex());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerSmartFlash", this.fGdbServerSmartFlash.getSelection());
        booleanValue = this.fGdbServerEnableSemihosting.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerEnableSemihosting", booleanValue);
        this.fPersistentPreferences.putPyOCDEnableSemihosting(booleanValue);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerUseGdbSyscalls", this.fGdbServerUseGdbSyscallsForSemihosting.getSelection());
        int freq = Integer.parseInt(this.fGdbServerBusSpeed.getText().trim());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBusSpeed", freq);
        stringValue = this.fGdbServerOtherOptions.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOther", stringValue);
        this.fPersistentPreferences.putGdbServerOtherOptions(stringValue);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateConsole", this.fDoGdbServerAllocateConsole.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateSemihostingConsole", this.fDoGdbServerAllocateSemihostingConsole.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        stringValue = this.fGdbClientExecutable.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringValue);
        this.fPersistentPreferences.putGdbClientExecutable(stringValue);
        stringValue = this.fGdbClientOtherOptions.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherOptions", stringValue);
        this.fPersistentPreferences.putGdbClientOtherOptions(stringValue);
        stringValue = this.fGdbClientOtherCommands.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherCommands", stringValue);
        this.fPersistentPreferences.putGdbClientCommands(stringValue);
        String ip = this.fTargetIpAddress.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", ip);
        String str = this.fTargetPortNumber.getText().trim();
        if (!str.isEmpty()) {
            try {
                int port2 = Integer.valueOf(str);
                configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port2);
            }
            catch (NumberFormatException e) {
                Activator.log((Throwable)e);
            }
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        this.fPersistentPreferences.flush();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.performApply() completed " + configuration.getName() + ", dirty=" + this.isDirty());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU PyOCD");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("pyocd.TabDebugger.setDefaults() " + configuration.getName());
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        boolean defaultBoolean = this.fPersistentPreferences.getGdbServerDoStart();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doStartGdbServer", defaultBoolean);
        String defaultString = this.fPersistentPreferences.getGdbServerExecutable();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerExecutable", defaultString);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerConnectionAddress", "");
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerGdbPortNumber", 3333);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTelnetPortNumber", 4444);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBoardId", "");
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBoardName", "");
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerBusSpeed", 1000000);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOverrideTarget", false);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerTargetName", "");
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerConnectMode", 0);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerResetType", 0);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerHaltAtHardFault", true);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerStepIntoInterrutps", false);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerFlashMode", 2);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerSmartFlash", true);
        defaultBoolean = this.fPersistentPreferences.getPyOCDEnableSemihosting();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerEnableSemihosting", defaultBoolean);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerUseGdbSyscalls", false);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerLog", "");
        defaultString = this.fPersistentPreferences.getGdbServerOtherOptions();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbServerOther", defaultString);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateConsole", true);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.doGdbServerAllocateSemihostingConsole", true);
        defaultString = this.fPersistentPreferences.getGdbClientExecutable();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultString);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        defaultString = this.fPersistentPreferences.getGdbClientOtherOptions();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherOptions", defaultString);
        defaultString = this.fPersistentPreferences.getGdbClientCommands();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.pyocd.gdbClientOtherCommands", defaultString);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }

    private void registerError(String msg) {
        if (this.fErrors.isEmpty()) {
            this.setErrorMessage(msg);
        }
        this.fErrors.add(msg);
    }

    private void deregisterError(String msg) {
        if (this.fErrors.remove(msg)) {
            if (this.fErrors.isEmpty()) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.fErrors.iterator().next());
            }
        }
    }

    private static class Msgs {
        public static final String LOADING_DATA = Messages.DebuggerTab_loading_data_from_pyocd;
        public static final String INVALID_PYOCD_EXECUTABLE = Messages.DebuggerTab_invalid_pyocd_executable;
        public static final String OLD_PYOCD_EXECUTABLE = Messages.DebuggerTab_old_pyocd_executable;
        public static final String PROBES_FAILURE_PARSING_PYOCD_OUTPUT = Messages.DebuggerTab_probes_failure_parsing_output;
        public static final String PROBES_FAILURE_INVOKING_PYOCD = Messages.DebuggerTab_probes_failure_invoking_pyocd;
        public static final String PROBES_PYOCD_TIMEOUT = Messages.DebuggerTab_probes_pyocd_timeout;
        public static final String TARGETS_FAILURE_PARSING_PYOCD_OUTPUT = Messages.DebuggerTab_targets_failure_parsing_output;
        public static final String TARGETS_FAILURE_INVOKING_PYOCD = Messages.DebuggerTab_targets_failure_invoking_pyocd;
        public static final String TARGETS_PYOCD_TIMEOUT = Messages.DebuggerTab_targets_pyocd_timeout;
        public static final String INVALID_GDBSERVER_PORT = Messages.DebuggerTab_invalid_gdbserver_port;
        public static final String INVALID_TELNET_PORT = Messages.DebuggerTab_invalid_telnet_port;
        public static final String INVALID_GDBCLIENT_EXECUTABLE = Messages.DebuggerTab_invalid_gdbclient_executable;

        private Msgs() {
        }
    }
}

