/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.launching;

import java.sql.SQLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.routineeditor.ui.RoutineEditorUIActivator;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.Messages;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.SPLaunchShortcut;
import org.eclipse.osgi.util.NLS;

public class LaunchingJob
extends Job {
    private ProcIdentifier _procIdentifier;
    private String _mode;

    public LaunchingJob(ProcIdentifier identifier, String mode) {
        super(Messages.LaunchingJob_name);
        this.setUser(true);
        this._procIdentifier = identifier;
        this._mode = mode;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.LaunchingJob_name, -1);
        String procName = this._procIdentifier.getProcName();
        if (this._mode.equals("run")) {
            monitor.subTask(NLS.bind((String)Messages.LaunchingJob_subTaskRun, (Object)procName));
        } else if (this._mode.equals("debug")) {
            monitor.subTask(NLS.bind((String)Messages.LaunchingJob_subTaskDebug, (Object)procName));
        }
        try {
            SPLaunchShortcut.launch(this._procIdentifier, this._mode);
        }
        catch (NoSuchProfileException e) {
            RoutineEditorUIActivator.getDefault().log(Messages.LaunchingJob_runError, e);
        }
        catch (CoreException e) {
            RoutineEditorUIActivator.getDefault().log(Messages.LaunchingJob_runError, e);
        }
        catch (SQLException e) {
            RoutineEditorUIActivator.getDefault().log(Messages.LaunchingJob_runError, e);
        }
        monitor.worked(-1);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

