/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.IVisualizerModelObject;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerLoadInfo;

public class VisualizerCPU
implements Comparable<VisualizerCPU>,
IVisualizerModelObject {
    public int m_id;
    protected VisualizerLoadInfo m_loadinfo;
    protected ArrayList<VisualizerCore> m_cores;
    protected Hashtable<Integer, VisualizerCore> m_coreMap;

    public VisualizerCPU(int id) {
        this.m_id = id;
        this.m_cores = new ArrayList();
        this.m_coreMap = new Hashtable();
    }

    public void dispose() {
        if (this.m_cores != null) {
            for (VisualizerCore core : this.m_cores) {
                core.dispose();
            }
            this.m_coreMap.clear();
            this.m_coreMap = null;
            this.m_cores.clear();
            this.m_cores = null;
            this.m_loadinfo = null;
        }
    }

    public String toString() {
        return "CPU:" + this.m_id;
    }

    @Override
    public int getID() {
        return this.m_id;
    }

    @Override
    public IVisualizerModelObject getParent() {
        return null;
    }

    public synchronized void setLoadInfo(VisualizerLoadInfo info) {
        this.m_loadinfo = info;
    }

    public synchronized Integer getLoad() {
        return this.m_loadinfo == null ? null : this.m_loadinfo.getLoad();
    }

    public synchronized Integer getHighLoadWatermark() {
        return this.m_loadinfo == null ? null : this.m_loadinfo.getHighLoadWaterMark();
    }

    public int getCoreCount() {
        return this.m_cores.size();
    }

    public List<VisualizerCore> getCores() {
        return this.m_cores;
    }

    public VisualizerCore getCore(int id) {
        return this.m_coreMap.get(id);
    }

    public VisualizerCore addCore(VisualizerCore core) {
        this.m_cores.add(core);
        this.m_coreMap.put(core.getID(), core);
        return core;
    }

    public void removeCore(VisualizerCore core) {
        this.m_cores.remove(core);
        this.m_coreMap.remove(core.getID());
    }

    public void sort() {
        Collections.sort(this.m_cores);
    }

    @Override
    public int compareTo(VisualizerCPU o) {
        int result = 0;
        if (o != null) {
            if (this.m_id < o.m_id) {
                result = -1;
            } else if (this.m_id > o.m_id) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public int compareTo(IVisualizerModelObject o) {
        if (o != null && o.getClass() == this.getClass()) {
            return this.compareTo((VisualizerCPU)o);
        }
        return 1;
    }
}

