/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.integration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.edit.WrappingCommandStack;
import org.eclipse.wst.common.internal.emfworkbench.integration.ComposedAccessorKey;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class ComposedEditModel
extends EditModel
implements EditModelListener {
    private List children = null;
    private Map childrenMap = null;
    private List cachedKeys = new ArrayList();

    public ComposedEditModel(String editModelID, EMFWorkbenchContext context) {
        super(editModelID, context, false);
    }

    public void createChildrenIfNecessary(ComposedAccessorKey composedAccessorKey) {
    }

    public void cacheAccessorKey(ComposedAccessorKey newKey) {
        if (!this.cachedKeys.contains(newKey)) {
            this.cachedKeys.add(newKey);
        }
    }

    public EditModel.Reference addChild(String editModelID, Map params, Object accessorKey) {
        return this.addChild(editModelID, params, ComposedAccessorKey.getComposedAccessorKey(accessorKey, this));
    }

    public EditModel.Reference addChild(String editModelID, Map params, ComposedAccessorKey composedAccessorKey) {
        EditModel editModel = this.getEmfContext().getEditModelForWrite(editModelID, composedAccessorKey, params);
        editModel.addListener(this);
        this.getChildrenMap().put(editModel.getReference(), editModel);
        this.getChildren().add(editModel);
        return editModel.getReference();
    }

    public void removeChild(EditModel.Reference reference, Object accessorKey) {
        ComposedAccessorKey composedAccessorKey = ComposedAccessorKey.getComposedAccessorKey(accessorKey, this);
        EditModel editModel = (EditModel)this.getChildrenMap().remove(reference);
        if (editModel != null) {
            editModel.releaseAccess(composedAccessorKey);
            editModel.removeListener(this);
            this.getChildren().remove(editModel);
        }
    }

    public Iterator getContainedReferences() {
        return this.getChildrenMap().keySet().iterator();
    }

    public EditModel getContainedEditModel(EditModel.Reference reference) {
        return (EditModel)this.getChildrenMap().get(reference);
    }

    @Override
    protected BasicCommandStack createCommandStack() {
        return new WrappingCommandStack(this);
    }

    @Override
    public void editModelChanged(EditModelEvent anEvent) {
        if (this.hasListeners()) {
            this.notifyListeners(anEvent);
        }
    }

    @Override
    public Set getAffectedFiles() {
        HashSet aSet = new HashSet();
        List models = this.getChildren();
        int i = 0;
        while (i < models.size()) {
            EditModel child = (EditModel)models.get(i);
            aSet.addAll(child.getAffectedFiles());
            ++i;
        }
        return aSet;
    }

    public List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    protected Map getChildrenMap() {
        if (this.childrenMap == null) {
            this.childrenMap = new HashMap();
        }
        return this.childrenMap;
    }

    @Override
    protected void handleSaveIfNecessaryDidNotSave(IProgressMonitor monitor) {
        List list = this.getChildren();
        int i = 0;
        while (i < list.size()) {
            EditModel editModel = (EditModel)list.get(i);
            editModel.handleSaveIfNecessaryDidNotSave(monitor);
            ++i;
        }
    }

    @Override
    public boolean isDirty() {
        for (EditModel editModel : this.getChildren()) {
            if (!editModel.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isInterrestedInResource(Resource aResource) {
        for (EditModel editModel : this.getChildren()) {
            if (!editModel.isInterrestedInResource(aResource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void primSave(IProgressMonitor monitor) {
        List list = this.getChildren();
        int i = 0;
        while (i < list.size()) {
            ((EditModel)list.get(i)).primSave(monitor);
            ++i;
        }
    }

    @Override
    public void access(Object accessorKey) {
        ComposedAccessorKey composedAccessorKey = ComposedAccessorKey.getComposedAccessorKey(accessorKey, this);
        if (this.getChildren().size() == 0) {
            this.createChildrenIfNecessary(composedAccessorKey);
        } else {
            List tempchildren = this.getChildren();
            int i = 0;
            while (i < tempchildren.size()) {
                EditModel model = (EditModel)tempchildren.get(i);
                model.access(composedAccessorKey);
                ++i;
            }
        }
        super.access(accessorKey);
    }

    @Override
    public void releaseAccess(Object accessorKey) {
        List tempchildren = this.getChildren();
        ComposedAccessorKey composedAccessorKey = ComposedAccessorKey.getComposedAccessorKey(accessorKey, this);
        int i = 0;
        while (i < tempchildren.size()) {
            EditModel model = (EditModel)tempchildren.get(i);
            model.releaseAccess(composedAccessorKey);
            ++i;
        }
        this.removeKeyFromCache(composedAccessorKey);
        super.releaseAccess(accessorKey);
    }

    public void removeKeyFromCache(ComposedAccessorKey key) {
        this.cachedKeys.remove(key);
    }

    @Override
    protected boolean shouldSave() {
        List list = this.getChildren();
        int i = 0;
        while (i < list.size()) {
            EditModel editModel = (EditModel)list.get(i);
            if (editModel.shouldSave()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected boolean shouldSave(IOperationHandler operationHandler) {
        List list = this.getChildren();
        int i = 0;
        while (i < list.size()) {
            EditModel editModel = (EditModel)list.get(i);
            if (editModel.shouldSave(operationHandler)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public List getNonResourceFiles() {
        List list = this.getChildren();
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < list.size()) {
            EditModel editModel = (EditModel)list.get(i);
            List files = editModel.getNonResourceFiles();
            if (files != null && !files.isEmpty()) {
                result.addAll(files);
            }
            ++i;
        }
        return result;
    }
}

