/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.patternlanguage.emf.specification.SpecificationBuilder;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.registry.IConnectorListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IRegistrySourceConnector;
import org.eclipse.viatra.query.runtime.registry.connector.AbstractRegistrySourceConnector;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.IPatternBasedSpecificationProvider;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.notification.IStateChangeEventBroker;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class XtextIndexBasedRegistryUpdater {
    public static final String DYNAMIC_CONNECTOR_ID_PREFIX = "dynamic:";
    private final IStateChangeEventBroker source;
    private final IResourceDescriptions descriptions;
    private final IResourceSetProvider resourceSetProvider;
    private final QueryRegistryUpdaterListener listener;
    private final Map<String, PatternDescriptionBasedSourceConnector> connectorMap;
    private final WorkspaceBuildCompletedListener workspaceListener;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IQuerySpecificationRegistry connectedRegistry;

    @Inject
    public XtextIndexBasedRegistryUpdater(IStateChangeEventBroker source, IResourceDescriptions descriptions, IResourceSetProvider resSetProvider) {
        QueryRegistryUpdaterListener _queryRegistryUpdaterListener;
        WorkspaceBuildCompletedListener _workspaceBuildCompletedListener;
        this.source = source;
        this.descriptions = descriptions;
        this.resourceSetProvider = resSetProvider;
        this.workspaceListener = _workspaceBuildCompletedListener = new WorkspaceBuildCompletedListener(this);
        this.listener = _queryRegistryUpdaterListener = new QueryRegistryUpdaterListener(this);
        this.connectorMap = Maps.newTreeMap();
    }

    public void connectIndexToRegistry(IQuerySpecificationRegistry registry) {
        if (this.connectedRegistry == null) {
            this.connectedRegistry = registry;
            Consumer<IResourceDescription> _function = resourceDesc -> {
                boolean _not;
                boolean _isPlatformResource = resourceDesc.getURI().isPlatformResource();
                boolean bl = _not = !_isPlatformResource;
                if (_not) {
                    return;
                }
                Iterable patternObjects = resourceDesc.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)patternObjects);
                if (_isEmpty) {
                    return;
                }
                String uri = resourceDesc.getURI().toString();
                String projectName = resourceDesc.getURI().segment(1);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                boolean projectExists = project.exists();
                if (!projectExists || !project.isOpen()) {
                    return;
                }
                String connectorId = DYNAMIC_CONNECTOR_ID_PREFIX + projectName;
                PatternDescriptionBasedSourceConnector connector = this.connectorMap.get(connectorId);
                if (connector == null) {
                    PatternDescriptionBasedSourceConnector _patternDescriptionBasedSourceConnector;
                    connector = _patternDescriptionBasedSourceConnector = new PatternDescriptionBasedSourceConnector(connectorId);
                    this.connectorMap.put(connectorId, connector);
                }
                PatternDescriptionBasedSourceConnector conn = connector;
                ResourceSet resourceSet = this.createResourceSet(projectName);
                Consumer<IEObjectDescription> _function_1 = it -> {
                    PatternDescriptionBasedSpecificationProvider provider = new PatternDescriptionBasedSpecificationProvider((IResourceDescription)resourceDesc, (IEObjectDescription)it, resourceSet);
                    conn.addProvider(uri, provider);
                };
                patternObjects.forEach(_function_1);
            };
            this.descriptions.getAllResourceDescriptions().forEach(_function);
            Consumer<PatternDescriptionBasedSourceConnector> _function_1 = connector -> registry.addSource((IRegistrySourceConnector)connector);
            this.connectorMap.values().forEach(_function_1);
            this.source.addListener((IResourceDescription.Event.Listener)this.listener);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.workspaceListener);
        }
    }

    public IQuerySpecificationRegistry disconnectIndexFromRegistry() {
        Object _xifexpression = null;
        if (this.connectedRegistry != null) {
            Object _xblockexpression = null;
            Consumer<PatternDescriptionBasedSourceConnector> _function = it -> this.connectedRegistry.removeSource((IRegistrySourceConnector)it);
            this.connectorMap.values().forEach(_function);
            this.source.removeListener((IResourceDescription.Event.Listener)this.listener);
            this.connectorMap.clear();
            this.connectedRegistry = null;
            _xifexpression = _xblockexpression = null;
        }
        return _xifexpression;
    }

    public ResourceSet createResourceSet(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        ResourceSet resourceSet = this.resourceSetProvider.get(project);
        return resourceSet;
    }

    @Pure
    protected IQuerySpecificationRegistry getConnectedRegistry() {
        return this.connectedRegistry;
    }

    private static final class PatternDescriptionBasedSourceConnector
    extends AbstractRegistrySourceConnector {
        private final Multimap<String, IQuerySpecificationProvider> descriptionToProvider = HashMultimap.create();

        public PatternDescriptionBasedSourceConnector(String identifier) {
            super(identifier, false);
        }

        public void addProvider(String resourceUri, PatternDescriptionBasedSpecificationProvider provider) {
            this.descriptionToProvider.put((Object)resourceUri, (Object)provider);
            Consumer<IConnectorListener> _function = it -> it.querySpecificationAdded((IRegistrySourceConnector)this, (IQuerySpecificationProvider)provider);
            this.listeners.forEach(_function);
        }

        public Collection<IQuerySpecificationProvider> clearProviders(String resourceUri) {
            Collection _xblockexpression = null;
            Consumer<IQuerySpecificationProvider> _function = provider -> {
                Consumer<IConnectorListener> _function_1 = it -> it.querySpecificationRemoved((IRegistrySourceConnector)this, provider);
                this.listeners.forEach(_function_1);
            };
            this.descriptionToProvider.get((Object)resourceUri).forEach(_function);
            _xblockexpression = this.descriptionToProvider.removeAll((Object)resourceUri);
            return _xblockexpression;
        }

        protected void sendQuerySpecificationsToListener(IConnectorListener listener) {
            Consumer<IQuerySpecificationProvider> _function = it -> listener.querySpecificationAdded((IRegistrySourceConnector)this, it);
            this.descriptionToProvider.values().forEach(_function);
        }
    }

    @FinalFieldsConstructor
    private static final class PatternDescriptionBasedSpecificationProvider
    implements IPatternBasedSpecificationProvider {
        private final IResourceDescription resourceDesc;
        private final IEObjectDescription description;
        private final ResourceSet resourceSet;
        private IQuerySpecification<?> specification;

        public String getFullyQualifiedName() {
            return this.description.getQualifiedName().toString();
        }

        public IQuerySpecification<?> get() {
            if (this.specification == null) {
                Pattern pattern = this.findPatternForDescription();
                SpecificationBuilder builder = new SpecificationBuilder();
                this.specification = builder.getOrCreateSpecification(pattern);
            }
            return this.specification;
        }

        @Override
        public IQuerySpecification<?> getSpecification(SpecificationBuilder builder) {
            Pattern pattern = this.findPatternForDescription();
            IQuerySpecification spec = builder.getOrCreateSpecification(pattern);
            return spec;
        }

        public Pattern findPatternForDescription() {
            boolean _eIsProxy_1;
            EObject pattern = this.description.getEObjectOrProxy();
            boolean _eIsProxy = pattern.eIsProxy();
            if (_eIsProxy) {
                pattern = EcoreUtil.resolve((EObject)pattern, (ResourceSet)this.resourceSet);
            }
            if (_eIsProxy_1 = pattern.eIsProxy()) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Cannot load specification ");
                String _fullyQualifiedName = this.getFullyQualifiedName();
                _builder.append(_fullyQualifiedName);
                _builder.append(" from Xtext index");
                throw new IllegalStateException(_builder.toString());
            }
            return (Pattern)pattern;
        }

        public String getSourceProjectName() {
            return this.resourceDesc.getURI().segment(1);
        }

        @Override
        public URI getSpecificationSourceURI() {
            return this.description.getEObjectURI();
        }

        public PatternDescriptionBasedSpecificationProvider(IResourceDescription resourceDesc, IEObjectDescription description, ResourceSet resourceSet) {
            this.resourceDesc = resourceDesc;
            this.description = description;
            this.resourceSet = resourceSet;
        }
    }

    @FinalFieldsConstructor
    private static final class QueryRegistryUpdaterListener
    implements IResourceDescription.Event.Listener {
        private final XtextIndexBasedRegistryUpdater updater;

        public void descriptionsChanged(IResourceDescription.Event event) {
            Consumer<IResourceDescription.Delta> _function = delta -> {
                boolean _not;
                IResourceDescription oldDesc = delta.getOld();
                IResourceDescription newDesc = delta.getNew();
                String uri = delta.getUri().toString();
                boolean _isPlatformResource = delta.getUri().isPlatformResource();
                boolean bl = _not = !_isPlatformResource;
                if (_not) {
                    return;
                }
                String projectName = delta.getUri().segment(1);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                boolean projectExists = project.exists();
                if (!projectExists) {
                    return;
                }
                String connectorId = XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX + projectName;
                try {
                    if (oldDesc != null) {
                        if (newDesc == null || !project.isOpen()) {
                            PatternDescriptionBasedSourceConnector connector = this.updater.connectorMap.get(connectorId);
                            if (connector != null) {
                                connector.clearProviders(uri);
                                boolean _isEmpty = connector.descriptionToProvider.isEmpty();
                                if (_isEmpty) {
                                    this.updater.connectedRegistry.removeSource((IRegistrySourceConnector)connector);
                                    this.updater.connectorMap.remove(connectorId);
                                }
                            }
                        } else {
                            this.processResourceDescription((IResourceDescription.Delta)delta, newDesc, connectorId, projectName);
                        }
                    } else if (newDesc != null && !IterableExtensions.isEmpty((Iterable)newDesc.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN))) {
                        this.processResourceDescription((IResourceDescription.Delta)delta, newDesc, connectorId, projectName);
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception ex = (Exception)_t;
                        Logger logger = ViatraQueryLoggingUtil.getLogger(XtextIndexBasedRegistryUpdater.class);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Could not update registry based on Xtext index for ");
                        _builder.append(uri);
                        logger.error((Object)_builder, (Throwable)ex);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            };
            event.getDeltas().forEach(_function);
        }

        public Object processResourceDescription(IResourceDescription.Delta delta, IResourceDescription desc, String connectorId, String projectName) {
            Object _xifexpression = null;
            boolean _containsKey = this.updater.connectorMap.containsKey(connectorId);
            if (_containsKey) {
                _xifexpression = this.updater.workspaceListener.connectorsToUpdate.put(desc.getURI(), desc);
            } else {
                boolean _not;
                boolean _xifexpression_1 = false;
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)desc.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN));
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    boolean _xblockexpression = false;
                    PatternDescriptionBasedSourceConnector connector = new PatternDescriptionBasedSourceConnector(connectorId);
                    this.updater.connectorMap.put(connectorId, connector);
                    boolean _haveEObjectDescriptionsChanged = delta.haveEObjectDescriptionsChanged();
                    if (_haveEObjectDescriptionsChanged) {
                        ResourceSet resourceSet = this.updater.createResourceSet(projectName);
                        Consumer<IEObjectDescription> _function = it -> {
                            PatternDescriptionBasedSpecificationProvider provider = new PatternDescriptionBasedSpecificationProvider(desc, (IEObjectDescription)it, resourceSet);
                            connector.addProvider(desc.getURI().toString(), provider);
                        };
                        desc.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN).forEach(_function);
                    }
                    _xifexpression_1 = _xblockexpression = this.updater.connectedRegistry.addSource((IRegistrySourceConnector)connector);
                }
                _xifexpression = _xifexpression_1;
            }
            return _xifexpression;
        }

        public QueryRegistryUpdaterListener(XtextIndexBasedRegistryUpdater updater) {
            this.updater = updater;
        }
    }

    @FinalFieldsConstructor
    private static final class WorkspaceBuildCompletedListener
    implements IResourceChangeListener {
        private final Map<URI, IResourceDescription> connectorsToUpdate = CollectionLiterals.newHashMap();
        private final XtextIndexBasedRegistryUpdater updater;

        public void resourceChanged(IResourceChangeEvent event) {
            int type = event.getType();
            if (type == 1) {
                boolean _isEmpty = this.connectorsToUpdate.isEmpty();
                if (_isEmpty) {
                    return;
                }
                ImmutableMap update = ImmutableMap.copyOf(this.connectorsToUpdate);
                BiConsumer<URI, IResourceDescription> _function = (uri, descr) -> {
                    try {
                        this.connectorsToUpdate.remove(uri);
                        String projectName = uri.segment(1);
                        String connectorId = XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX + projectName;
                        PatternDescriptionBasedSourceConnector connector = this.updater.connectorMap.get(connectorId);
                        connector.clearProviders(uri.toString());
                        ResourceSet resourceSet = this.updater.createResourceSet(projectName);
                        Iterable patternObjects = descr.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN);
                        Consumer<IEObjectDescription> _function_1 = it -> {
                            PatternDescriptionBasedSpecificationProvider provider = new PatternDescriptionBasedSpecificationProvider((IResourceDescription)descr, (IEObjectDescription)it, resourceSet);
                            connector.addProvider(uri.toString(), provider);
                        };
                        patternObjects.forEach(_function_1);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception ex = (Exception)_t;
                            Logger logger = ViatraQueryLoggingUtil.getLogger(XtextIndexBasedRegistryUpdater.class);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("Could not update registry based on Xtext index for ");
                            _builder.append(uri);
                            logger.error((Object)_builder, (Throwable)ex);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                };
                update.forEach(_function);
            }
        }

        public WorkspaceBuildCompletedListener(XtextIndexBasedRegistryUpdater updater) {
            this.updater = updater;
        }
    }
}

