/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.unittest.internal.ui.ITraceDisplay;

public class TextualTrace {
    public static final int LINE_TYPE_EXCEPTION = 1;
    public static final int LINE_TYPE_NORMAL = 0;
    public static final int LINE_TYPE_STACKFRAME = 2;
    private final String fTrace;

    public TextualTrace(String trace, Collection<StringMatcher> filterPatterns) {
        this.fTrace = this.filterStack(trace, filterPatterns);
    }

    public void display(ITraceDisplay display, int maxLabelLength) {
        StringReader stringReader = new StringReader(this.fTrace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line = this.readLine(bufferedReader);
            if (line == null) {
                return;
            }
            this.displayWrappedLine(display, maxLabelLength, line, 1);
            while ((line = this.readLine(bufferedReader)) != null) {
                int type = this.isAStackFrame(line) ? 2 : 0;
                this.displayWrappedLine(display, maxLabelLength, line, type);
            }
        }
        catch (IOException e) {
            display.addTraceLine(0, this.fTrace);
        }
    }

    private void displayWrappedLine(ITraceDisplay display, int maxLabelLength, String line, int type) {
        int labelLength = line.length();
        if (labelLength < maxLabelLength) {
            display.addTraceLine(type, line);
        } else {
            display.addTraceLine(type, line.substring(0, maxLabelLength));
            int offset = maxLabelLength;
            while (offset < labelLength) {
                int nextOffset = Math.min(labelLength, offset + maxLabelLength);
                display.addTraceLine(0, line.substring(offset, nextOffset));
                offset = nextOffset;
            }
        }
    }

    private boolean filterLine(Collection<StringMatcher> patterns, String line) {
        for (StringMatcher pattern : patterns) {
            if (!pattern.match(line)) continue;
            return true;
        }
        return false;
    }

    private String filterStack(String stackTrace, Collection<StringMatcher> filterPatterns) {
        if (filterPatterns == null || filterPatterns.isEmpty() || stackTrace == null) {
            return stackTrace;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(stackTrace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        boolean firstLine = true;
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (firstLine || !this.filterLine(filterPatterns, line)) {
                    printWriter.println(line);
                }
                firstLine = false;
            }
        }
        catch (IOException e) {
            return stackTrace;
        }
        return stringWriter.toString();
    }

    private boolean isAStackFrame(String itemLabel) {
        return itemLabel.startsWith(" at ");
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        String readLine = bufferedReader.readLine();
        return readLine == null ? null : readLine.replace('\t', ' ');
    }
}

