/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.command.builders;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.UIState;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public final class ElementsToSelectTask
extends AbstractCommandTask {
    private AbstractToolDescription toolDescription;
    private IInterpreter interpreter;
    private EObject context;
    private DRepresentation dRepresentation;

    public ElementsToSelectTask(AbstractToolDescription toolDescription, IInterpreter interpreter, EObject context, DRepresentation dRepresentation) {
        this.toolDescription = toolDescription;
        this.interpreter = interpreter;
        this.context = context;
        this.dRepresentation = dRepresentation;
    }

    @Override
    public String getLabel() {
        return Messages.ElementsToSelectTask_label;
    }

    @Override
    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
        String elementsToSelectExpression = this.toolDescription.getElementsToSelect();
        try {
            UIState uiState = this.dRepresentation.getUiState();
            uiState.unsetElementsToSelect();
            uiState.setInverseSelectionOrder(this.toolDescription.isInverseSelectionOrder());
            if (!elementsToSelectExpression.isEmpty()) {
                Collection evaluateCollection = this.interpreter.evaluateCollection(this.context, elementsToSelectExpression);
                uiState.getElementsToSelect().clear();
                uiState.getElementsToSelect().addAll(evaluateCollection);
            }
        }
        catch (EvaluationException e) {
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.ElementsToSelectTask_errorMsg, elementsToSelectExpression), (Exception)((Object)e));
        }
    }
}

