/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions;

import org.eclipse.gmf.runtime.diagram.ui.actions.internal.PropertyChangeContributionItem;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorPalettePopupService;
import org.eclipse.sirius.diagram.ui.tools.api.color.IColorPalettePopup;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ColorPalettePopup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ColorPropertyContributionItem
extends PropertyChangeContributionItem
implements Listener {
    private static final Point ICON_SIZE = new Point(16, 16);
    private ImageData basicImageData;
    private ImageData disabledBasicImageData;
    private Image disabledBasicImage;
    private Image overlyedImage;
    private Integer lastColor;
    private Menu menu;

    public ColorPropertyContributionItem(IWorkbenchPage workbenchPage, String id, String propertyId, String propertyName, String toolTipText, ImageData basicImageData, ImageData disabledBasicImageData) {
        super(workbenchPage, id, propertyId, propertyName);
        assert (toolTipText != null);
        assert (basicImageData != null);
        this.basicImageData = basicImageData;
        this.disabledBasicImageData = disabledBasicImageData;
        this.setLabel(toolTipText);
    }

    protected void init() {
        super.init();
        super.setWorkbenchPart(this.getWorkbenchPart());
        this.overlyedImage = new ColorMenuImageDescriptor(this.getBasicImageData(), null).createImage();
        this.disabledBasicImage = new ColorMenuImageDescriptor(this.disabledBasicImageData, null).createImage();
    }

    public void dispose() {
        if (this.overlyedImage != null && !this.overlyedImage.isDisposed()) {
            this.overlyedImage.dispose();
            this.overlyedImage = null;
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
            this.menu = null;
        }
        if (this.disabledBasicImage != null && !this.disabledBasicImage.isDisposed()) {
            this.disabledBasicImage.dispose();
            this.disabledBasicImage = null;
        }
        super.dispose();
    }

    protected ToolItem createToolItem(ToolBar parent, int index) {
        ToolItem ti = new ToolItem(parent, 4, index);
        ti.addListener(13, this.getItemListener());
        ti.setImage(this.overlyedImage);
        ti.setDisabledImage(this.disabledBasicImage);
        return ti;
    }

    protected MenuItem createMenuItem(Menu parent, int index) {
        MenuItem mi = new MenuItem(parent, 8);
        mi.addListener(13, (Listener)this);
        mi.setImage(this.overlyedImage);
        return mi;
    }

    protected void handleWidgetEvent(Event e) {
        switch (e.type) {
            case 13: {
                this.handleWidgetSelection(e);
                break;
            }
            default: {
                super.handleWidgetEvent(e);
            }
        }
    }

    private void handleWidgetSelection(Event e) {
        Widget widget = e.widget;
        if (widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)widget;
            ToolItem cfr_ignored_0 = (ToolItem)widget;
            if (e.detail == 4) {
                this.invokeColorPalettePopup((Item)toolItem);
            } else if (this.lastColor != null) {
                this.runWithEvent(e);
            } else {
                this.invokeColorPalettePopup((Item)toolItem);
            }
        }
    }

    protected Object getNewPropertyValue() {
        return this.lastColor;
    }

    public void handleEvent(Event event) {
        this.invokeColorPalettePopup(this.getItem());
    }

    private void invokeColorPalettePopup(Item item) {
        IColorPalettePopup popup = ColorPalettePopupService.getColorPalettePopup(Display.getCurrent().getActiveShell(), ((DDiagramEditor)this.getWorkbenchPart()).getSession(), this.getOperationSet(), this.getPropertyId());
        popup.init();
        popup.open(this.computePopupLocation(item));
        RGB rgb = popup.getSelectedColor();
        if (rgb != null) {
            if (this.overlyedImage != null) {
                this.overlyedImage.dispose();
            }
            this.overlyedImage = new ColorMenuImageDescriptor(this.getBasicImageData(), rgb).createImage();
            if (this.getItem() != null) {
                this.getItem().setImage(this.overlyedImage);
            }
            this.lastColor = FigureUtilities.RGBToInteger((RGB)rgb);
            this.runWithEvent(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Point computePopupLocation(Item item) {
        Point location = new Point(0, 0);
        Item item2 = item;
        if (item2 instanceof ToolItem) {
            void toolItem;
            ToolItem toolItem2 = (ToolItem)item2;
            ToolItem cfr_ignored_0 = (ToolItem)item2;
            location = ColorPalettePopup.getValidPopupLocation((ToolItem)toolItem);
        } else {
            Item item3 = item;
            if (item3 instanceof MenuItem) {
                void menuItem;
                MenuItem menuItem2 = (MenuItem)item3;
                MenuItem cfr_ignored_1 = (MenuItem)item3;
                location = ColorPalettePopup.getValidPopupLocation((MenuItem)menuItem);
            }
        }
        return location;
    }

    protected IWorkbenchPart getWorkbenchPart() {
        IWorkbenchPart resultWorkbenchPart = super.getWorkbenchPart();
        if (resultWorkbenchPart == null && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            resultWorkbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        }
        return resultWorkbenchPart;
    }

    protected ImageData getBasicImageData() {
        return this.basicImageData;
    }

    public static ColorPropertyContributionItem createFontColorContributionItem(IWorkbenchPage workbenchPage) {
        String propertyName = DiagramUIActionsMessages.PropertyDescriptorFactory_FontColor;
        String toolTipText = DiagramUIActionsMessages.ColorChangeActionMenu_fontColor;
        ImageData basicImageData = DiagramUIActionsPluginImages.DESC_FONT_COLOR.getImageData(100);
        ImageData disabledBasicImageData = DiagramUIActionsPluginImages.DESC_FONT_COLOR_DISABLED.getImageData(100);
        return new ColorPropertyContributionItem(workbenchPage, "fontColorContributionItem", Properties.ID_FONTCOLOR, propertyName, toolTipText, basicImageData, disabledBasicImageData);
    }

    public static ColorPropertyContributionItem createLineColorContributionItem(IWorkbenchPage workbenchPage) {
        String propertyName = DiagramUIActionsMessages.PropertyDescriptorFactory_LineColor;
        String toolTipText = DiagramUIActionsMessages.ColorChangeActionMenu_lineColor;
        ImageData basicImageData = DiagramUIActionsPluginImages.DESC_LINE_COLOR.getImageData(100);
        ImageData disabledBasicImageData = DiagramUIActionsPluginImages.DESC_LINE_COLOR_DISABLED.getImageData(100);
        return new ColorPropertyContributionItem(workbenchPage, "lineColorContributionItem", Properties.ID_LINECOLOR, propertyName, toolTipText, basicImageData, disabledBasicImageData);
    }

    public static ColorPropertyContributionItem createFillColorContributionItem(IWorkbenchPage workbenchPage) {
        String propertyName = DiagramUIActionsMessages.PropertyDescriptorFactory_FillColor;
        String toolTipText = DiagramUIActionsMessages.ColorChangeActionMenu_fillColor;
        ImageData basicImageData = DiagramUIActionsPluginImages.DESC_FILL_COLOR.getImageData(100);
        ImageData disabledBasicImageData = DiagramUIActionsPluginImages.DESC_FILL_COLOR_DISABLED.getImageData(100);
        return new ColorPropertyContributionItem(workbenchPage, "fillColorContributionItem", Properties.ID_FILLCOLOR, propertyName, toolTipText, basicImageData, disabledBasicImageData);
    }

    private static class ColorMenuImageDescriptor
    extends CompositeImageDescriptor {
        private ImageData basicImgData;
        private RGB rgb;

        ColorMenuImageDescriptor(ImageData basicImgData, RGB rgb) {
            this.basicImgData = basicImgData;
            this.rgb = rgb;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.basicImgData, 0, 0);
            if (this.rgb != null) {
                ImageData colorBar = new ImageData(14, 4, 1, new PaletteData(new RGB[]{this.rgb}));
                this.drawImage(colorBar, 1, height - 4);
            }
        }

        protected Point getSize() {
            return ICON_SIZE;
        }
    }
}

