/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatformHelper;

public class BundleValidationOperation
implements IWorkspaceRunnable {
    private static StateObjectFactory FACTORY;
    private final Set<IPluginModelBase> fModels;
    private final Dictionary<String, String>[] fProperties;
    private State fState;

    public BundleValidationOperation(Set<IPluginModelBase> models) {
        this(models, new Dictionary[]{TargetPlatformHelper.getTargetEnvironment()});
    }

    public BundleValidationOperation(Set<IPluginModelBase> models, Dictionary<String, String>[] properties) {
        this.fModels = models;
        this.fProperties = properties;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (FACTORY == null) {
            FACTORY = BundleHelper.getPlatformAdmin().getFactory();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.fModels.size() + 1));
        this.fState = FACTORY.createState(true);
        for (IPluginModelBase fModel : this.fModels) {
            BundleDescription bundle = fModel.getBundleDescription();
            if (bundle != null) {
                this.fState.addBundle(FACTORY.createBundleDescription(bundle));
            }
            subMonitor.split(1);
        }
        this.fState.setPlatformProperties((Dictionary[])this.fProperties);
        this.fState.resolve(false);
        subMonitor.split(1);
    }

    public Map<Object, Object[]> getResolverErrors() {
        BundleDescription[] bundles;
        HashSet<String> alreadyDuplicated = new HashSet<String>();
        LinkedHashMap<Object, Object[]> map = new LinkedHashMap<Object, Object[]>();
        BundleDescription[] bundleDescriptionArray = bundles = this.fState.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription[] dups;
            BundleDescription bundle = bundleDescriptionArray[n2];
            if (!bundle.isResolved()) {
                map.put(bundle, this.fState.getResolverErrors(bundle));
            } else if (bundle.isSingleton() && !alreadyDuplicated.contains(bundle.getSymbolicName()) && (dups = this.fState.getBundles(bundle.getSymbolicName())).length > 1) {
                alreadyDuplicated.add(bundle.getSymbolicName());
                MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, NLS.bind((String)PDECoreMessages.BundleValidationOperation_multiple_singletons, (Object[])new String[]{Integer.toString(dups.length), bundle.getSymbolicName()}), null);
                BundleDescription[] bundleDescriptionArray2 = dups;
                int n3 = dups.length;
                int n4 = 0;
                while (n4 < n3) {
                    BundleDescription dup = bundleDescriptionArray2[n4];
                    status.add(Status.error((String)dup.getLocation()));
                    ++n4;
                }
                map.put(bundle, new Object[]{status});
            }
            ++n2;
        }
        return map;
    }

    public State getState() {
        return this.fState;
    }

    public boolean hasErrors() {
        if (this.fState.getHighestBundleId() > -1L) {
            BundleDescription[] bundles;
            BundleDescription[] bundleDescriptionArray = bundles = this.fState.getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription[] dups;
                BundleDescription bundle = bundleDescriptionArray[n2];
                if (!bundle.isResolved()) {
                    return true;
                }
                if (bundle.isSingleton() && (dups = this.fState.getBundles(bundle.getSymbolicName())).length > 1) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

