/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.launching;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.IVMDebuggerShell;
import org.eclipse.ocl.examples.debug.vm.core.EvaluationContext;
import org.eclipse.ocl.examples.debug.vm.evaluator.IDebuggableRunnerFactory;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMContext;
import org.eclipse.ocl.examples.debug.vm.launching.InternalDebuggableExecutor;
import org.eclipse.ocl.examples.debug.vm.launching.VMDebuggableExecutorAdapter;
import org.eclipse.ocl.examples.debug.vm.request.VMStartRequest;
import org.eclipse.ocl.examples.debug.vm.utils.CompiledUnit;
import org.eclipse.ocl.examples.debug.vm.utils.ExecutionDiagnostic;
import org.eclipse.ocl.examples.debug.vm.utils.IVMStackTraceElement;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;

public class DebuggableRunner {
    protected final @NonNull IDebuggableRunnerFactory debuggableRunnerFactory;
    protected final @NonNull URI debuggableURI;
    protected final @NonNull InternalDebuggableExecutor executor;
    private URI fTraceFileURI;
    private BasicDiagnostic fDiagnostic;
    private @Nullable IVMDebuggerShell fDebugShell;
    private PrintWriter fErrorLog;

    protected static boolean isSuccess(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        return severity != 4 && severity != 8;
    }

    public DebuggableRunner(@NonNull IDebuggableRunnerFactory debuggableRunnerFactory, @NonNull URI debuggableURI, @NonNull InternalDebuggableExecutor executor) {
        this.debuggableRunnerFactory = debuggableRunnerFactory;
        this.debuggableURI = debuggableURI;
        this.executor = executor;
        this.fErrorLog = new PrintWriter(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        }, true);
    }

    public @NonNull VMDebuggableExecutorAdapter createDebuggableAdapter(final @NonNull EvaluationContext evaluationContext) {
        return new VMDebuggableExecutorAdapter(){

            @Override
            public Diagnostic execute(@NonNull VMStartRequest startRequest) throws IllegalStateException {
                if (DebuggableRunner.this.fDebugShell == null) {
                    throw new IllegalStateException("Executor not connected to debugger");
                }
                CompiledUnit mainUnit = this.getUnit();
                evaluationContext.attachEnvironmentFactory();
                try {
                    Diagnostic execDiagnostic = DebuggableRunner.this.execute(startRequest, evaluationContext);
                    if (execDiagnostic.getSeverity() != 0) {
                        DebuggableRunner.this.fErrorLog.println(execDiagnostic);
                    }
                    Diagnostic diagnostic = execDiagnostic;
                    return diagnostic;
                }
                finally {
                    evaluationContext.detachEnvironmentFactory();
                }
            }

            @Override
            public @Nullable CompiledUnit getUnit() {
                return DebuggableRunner.this.executor.getUnit();
            }

            @Override
            public void connect(@NonNull IVMDebuggerShell debugShell) {
                DebuggableRunner.this.fDebugShell = debugShell;
            }
        };
    }

    public Diagnostic execute(@NonNull VMStartRequest startRequest, @NonNull EvaluationContext evaluationContext) {
        Diagnostic diagnostic = this.initialize();
        if (!DebuggableRunner.isSuccess(diagnostic)) {
            return diagnostic;
        }
        try {
            ExecutionDiagnostic execDiagnostic = this.executor.execute(startRequest, evaluationContext);
            this.handleExecution(execDiagnostic);
            if (!DebuggableRunner.isSuccess(execDiagnostic)) {
                ExecutionDiagnostic executionDiagnostic = execDiagnostic;
                return executionDiagnostic;
            }
            this.executor.getVMExecutor().saveModels();
            ExecutionDiagnostic executionDiagnostic = execDiagnostic;
            return executionDiagnostic;
        }
        finally {
            this.executor.cleanup();
        }
    }

    public @NonNull URI getDebuggableURI() {
        return this.debuggableURI;
    }

    public @NonNull MetamodelManager getMetamodelManager() {
        return this.executor.getVMExecutor().getEnvironmentFactory().getMetamodelManager();
    }

    public @NonNull IDebuggableRunnerFactory getRunnerFactory() {
        return this.debuggableRunnerFactory;
    }

    public URI getTraceFileURI() {
        return this.fTraceFileURI;
    }

    protected CompiledUnit getUnit() {
        return this.executor.getUnit();
    }

    protected @NonNull IVMContext getVMContext() {
        return this.executor.getVMContext();
    }

    protected void handleLoadExtents(Diagnostic diagnostic) {
    }

    protected void handleExecution(ExecutionDiagnostic execDiagnostic) {
        List<IVMStackTraceElement> stackTrace = execDiagnostic.getStackTrace();
        if (stackTrace != null && execDiagnostic.getCode() != 110) {
            this.fErrorLog.println(execDiagnostic);
            if (!stackTrace.isEmpty()) {
                this.fErrorLog.println("[OCL Stack trace:]");
                execDiagnostic.printStackTrace(this.fErrorLog);
                this.fErrorLog.println();
            }
        }
        if (execDiagnostic.getException() != null) {
            this.fErrorLog.println("[Java cause:]");
            execDiagnostic.getException().printStackTrace(this.fErrorLog);
        }
        this.fErrorLog.flush();
    }

    protected void handleLoadDebuggable(Diagnostic diagnostic) {
    }

    protected void handleSaveExtents(Diagnostic diagnostic) {
    }

    public Diagnostic initialize() {
        IVMContext vmContext = this.getVMContext();
        vmContext.setShell(this.fDebugShell);
        if (this.fDiagnostic != null) {
            return this.fDiagnostic;
        }
        this.fDiagnostic = this.debuggableRunnerFactory.createDiagnostic("Transformation runner initiliaze");
        Diagnostic loadDiagnostic = this.executor.loadDebuggable();
        if (!DebuggableRunner.isSuccess(loadDiagnostic)) {
            this.fDiagnostic.add(loadDiagnostic);
        }
        this.handleLoadDebuggable(loadDiagnostic);
        NamedElement debuggable = this.executor.getDebuggable();
        if (debuggable == null) {
            return this.fDiagnostic;
        }
        return this.fDiagnostic;
    }

    public void setErrorLog(@NonNull PrintWriter errorLog) {
        this.fErrorLog = errorLog;
    }

    public void setTraceFile(URI traceFileURI) {
        this.fTraceFileURI = traceFileURI;
    }
}

