/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.ConsumerWithException;
import org.eclipse.net4j.util.RunnableWithException;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;

public class SafeBrowser
extends Browser {
    private static final int STYLE = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.util.ui.widgets.SafeBrowser.STYLE", 262144);
    private boolean documentAvailable;
    private List<RunnableWithException> deferredScripts;

    public SafeBrowser(Composite parent) {
        super(parent, STYLE);
        this.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                SafeBrowser.this.documentAvailable = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(ProgressEvent event) {
                List<RunnableWithException> runnables;
                SafeBrowser.this.documentAvailable = true;
                SafeBrowser safeBrowser = SafeBrowser.this;
                synchronized (safeBrowser) {
                    runnables = SafeBrowser.this.deferredScripts;
                    SafeBrowser.this.deferredScripts = null;
                }
                if (runnables != null) {
                    for (RunnableWithException runnable : runnables) {
                        try {
                            runnable.run();
                        }
                        catch (Exception ex) {
                            OM.LOG.error((Throwable)ex);
                        }
                    }
                }
            }
        });
    }

    public boolean isDocumentAvailable() {
        return this.documentAvailable;
    }

    public Object evaluate(String script, boolean trusted) throws SWTException {
        this.checkDocumentAvailable(script);
        return this.internalEvaluate(script, trusted);
    }

    public void evaluateSafe(String script, boolean trusted, ConsumerWithException<Object, SWTException> resultHandler) throws SWTException {
        RunnableWithException runnable = () -> {
            Object result = this.internalEvaluate(script, trusted);
            resultHandler.accept(result);
        };
        if (this.documentAvailable) {
            try {
                runnable.run();
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        } else {
            this.deferScript(runnable);
        }
    }

    public boolean execute(String script) {
        this.checkDocumentAvailable(script);
        return this.internalExecute(script);
    }

    public boolean executeSafe(String script) {
        if (this.documentAvailable) {
            return this.internalExecute(script);
        }
        this.deferScript(() -> {
            boolean bl = this.internalExecute(script);
        });
        return false;
    }

    protected void checkSubclass() {
    }

    private Object internalEvaluate(String script, boolean trusted) throws SWTException {
        return super.evaluate(script, trusted);
    }

    private boolean internalExecute(String script) {
        return super.execute(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deferScript(RunnableWithException runnable) {
        SafeBrowser safeBrowser = this;
        synchronized (safeBrowser) {
            if (this.deferredScripts == null) {
                this.deferredScripts = new ArrayList<RunnableWithException>();
            }
            this.deferredScripts.add(runnable);
        }
    }

    private void checkDocumentAvailable(String script) {
        if (!this.documentAvailable) {
            throw new DocumentUnavailableException();
        }
    }

    public static final class DocumentUnavailableException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;
    }
}

