/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.uicore.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.modisco.infra.browser.uicore.internal.Activator;
import org.eclipse.modisco.infra.browser.uicore.internal.Messages;
import org.eclipse.modisco.infra.browser.uicore.internal.util.QueryErrorDialog;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.query.ModelQuery;
import org.eclipse.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.modisco.infra.query.runtime.ModelQueryContext;
import org.eclipse.modisco.infra.query.runtime.ModelQueryResult;
import org.eclipse.modisco.infra.query.runtime.RuntimeFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

@Deprecated
public final class QueryUtil {
    private static final int MESSAGE_DELAY = 100;
    private static Job messageJob;
    private static List<Throwable> errors;

    static {
        errors = new ArrayList<Throwable>();
    }

    private QueryUtil() {
    }

    public static Object basicEvaluate(ModelQuery modelQuery, EObject context) {
        ModelQuerySetCatalog querySetCatalog = ModelQuerySetCatalog.getSingleton();
        try {
            AbstractModelQuery modelQueryImpl = querySetCatalog.getModelQueryImpl(modelQuery);
            ModelQueryContext modelQueryContext = RuntimeFactory.eINSTANCE.createModelQueryContext();
            modelQueryContext.getSelectedModelElements().add((Object)context);
            List parameters = Collections.emptyList();
            List results = modelQueryImpl.evaluate(modelQueryContext, parameters);
            if (results.size() > 0) {
                ModelQueryResult modelQueryResult = (ModelQueryResult)results.get(0);
                Exception exc = modelQueryResult.getException();
                if (exc != null) {
                    QueryUtil.showMessageDialog(exc);
                    MoDiscoLogger.logError((Throwable)exc, (Plugin)Activator.getDefault());
                } else {
                    return ((ModelQueryResult)results.get(0)).getValue();
                }
            }
            return null;
        }
        catch (Throwable e) {
            QueryUtil.showMessageDialog(e);
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return null;
        }
    }

    private static void showMessageDialog(Throwable e) {
        if (messageJob == null) {
            messageJob = new Job(Messages.QueryUtil_displayQueryErrorMessageJob){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (errors.size() == 1) {
                                Throwable error = (Throwable)errors.get(0);
                                StackTraceElement[] stackTrace = error.getStackTrace();
                                String stack = "";
                                if (stackTrace.length > 0) {
                                    stack = "\nat:" + stackTrace[0].toString();
                                }
                                QueryErrorDialog.openError(null, Messages.QueryUtil_QueryError, String.valueOf(error.getClass().getSimpleName()) + " : " + error.getMessage() + stack);
                            } else {
                                QueryErrorDialog.openError(null, Messages.QueryUtil_QueryError, NLS.bind((String)Messages.QueryUtil_queryErrorsOccurred, (Object)errors.size()));
                            }
                            errors.clear();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        } else {
            messageJob.cancel();
        }
        errors.add(e);
        messageJob.setPriority(50);
        messageJob.schedule(100L);
    }
}

