/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConstantTag implements Enumerator
{
    STRING(0, "String", "String"),
    INTEGER(1, "Integer", "Integer"),
    DOUBLE(2, "Double", "Double"),
    BYTE(3, "Byte", "Byte"),
    CHARACTER(4, "Character", "Character"),
    FLOAT(5, "Float", "Float"),
    SHORT(6, "Short", "Short"),
    LONG(7, "Long", "Long"),
    ENUM_LITERAL(8, "EnumLiteral", "EnumLiteral"),
    NULL(9, "Null", "Null");

    public static final int STRING_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int DOUBLE_VALUE = 2;
    public static final int BYTE_VALUE = 3;
    public static final int CHARACTER_VALUE = 4;
    public static final int FLOAT_VALUE = 5;
    public static final int SHORT_VALUE = 6;
    public static final int LONG_VALUE = 7;
    public static final int ENUM_LITERAL_VALUE = 8;
    public static final int NULL_VALUE = 9;
    private static final ConstantTag[] VALUES_ARRAY;
    public static final List<ConstantTag> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConstantTag[]{STRING, INTEGER, DOUBLE, BYTE, CHARACTER, FLOAT, SHORT, LONG, ENUM_LITERAL, NULL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConstantTag get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstantTag result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstantTag getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstantTag result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstantTag get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return DOUBLE;
            }
            case 3: {
                return BYTE;
            }
            case 4: {
                return CHARACTER;
            }
            case 5: {
                return FLOAT;
            }
            case 6: {
                return SHORT;
            }
            case 7: {
                return LONG;
            }
            case 8: {
                return ENUM_LITERAL;
            }
            case 9: {
                return NULL;
            }
        }
        return null;
    }

    private ConstantTag(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

