/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionHelper;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.AtlTypesProcessor;

public class AtlModelAnalyser {
    private EObject root;
    private String fileContext;
    private int modelOffset;
    private List<EObject> lostElements;
    private AtlCompletionHelper fHelper;

    public AtlModelAnalyser(AtlCompletionHelper helper, EObject emfRoot, int modelOffset, String fileContext) {
        this.fHelper = helper;
        this.root = emfRoot;
        this.fileContext = fileContext;
        this.modelOffset = modelOffset;
        this.computeLostElements();
    }

    private void computeLostElements() {
        this.lostElements = new ArrayList<EObject>();
        if (this.root != null) {
            for (EObject element : this.root.eResource().getContents()) {
                if (AtlCompletionHelper.getLocation(element) != null) continue;
                this.lostElements.add(element);
            }
        }
    }

    public String getContext(int offset) throws BadLocationException {
        String context = "atl_context";
        EObject locatedElement = this.getLocatedElement(offset);
        String lastKeyword = this.fHelper.getLastKeyWord(offset);
        context = lastKeyword != null ? (lastKeyword.equalsIgnoreCase("helper") && (locatedElement != null || this.getLostTypesNames().contains("Helper")) ? "helper_context" : (lastKeyword.equalsIgnoreCase("rule") ? "rule_context" : (lastKeyword.equalsIgnoreCase("query") ? "query_context" : (lastKeyword.equalsIgnoreCase("from") && this.root != null ? "rule_context" : ((lastKeyword.equalsIgnoreCase("to") || lastKeyword.equalsIgnoreCase("do")) && (locatedElement != null || this.getLostTypesNames().contains("MatchedRule") || this.getLostTypesNames().contains("CalledRule") || this.getLostTypesNames().contains("LazyMatchedRule")) ? "rule_context" : (lastKeyword.equalsIgnoreCase("using") ? "rule_context" : this.fileContext)))))) : "atl_context";
        return context;
    }

    public List<EObject> getContainers(EObject element) throws BadLocationException {
        ArrayList<EObject> res = new ArrayList<EObject>();
        EObject tmp = element;
        while (tmp != null) {
            if (res.contains(tmp = this.getContainer(tmp))) continue;
            res.add(tmp);
        }
        return res;
    }

    public EObject getContainer(EObject element) throws BadLocationException {
        EObject res = null;
        if (element.eContainer() != null) {
            res = element.eContainer();
        } else if (this.root != null) {
            int[] elementOffsets = this.fHelper.getElementOffsets(element, this.modelOffset);
            if (elementOffsets != null) {
                TreeIterator ti = this.root.eResource().getAllContents();
                int maxDebOffset = -1;
                while (ti.hasNext()) {
                    int[] tmpOffsets;
                    EObject tmp = (EObject)ti.next();
                    if (element.equals(tmp) || (tmpOffsets = this.fHelper.getElementOffsets(tmp, this.modelOffset)) == null || tmpOffsets[0] > elementOffsets[0] || tmpOffsets[1] < elementOffsets[1] || tmpOffsets[0] == elementOffsets[0] && tmpOffsets[1] == elementOffsets[1] || tmpOffsets[0] <= maxDebOffset) continue;
                    maxDebOffset = tmpOffsets[0];
                    if (element.equals(tmp)) continue;
                    res = tmp;
                }
            } else if (AtlTypesProcessor.oclIsKindOf(element, "SimpleOutPatternElement") || AtlTypesProcessor.oclIsKindOf(element, "InPattern")) {
                res = this.root;
            } else if (AtlTypesProcessor.oclIsKindOf(element, "IfExp") || AtlTypesProcessor.oclIsKindOf(element, "IteratorExp") || AtlTypesProcessor.oclIsKindOf(element, "CollectionExp")) {
                res = this.getPreviouslyParsedElement(element);
            }
        }
        return res;
    }

    public EObject getPreviouslyParsedElement(EObject element) throws BadLocationException {
        EObject res = null;
        if (this.root != null) {
            TreeIterator ti = this.root.eResource().getAllContents();
            EObject last = this.root;
            while (ti.hasNext()) {
                EObject tmp = (EObject)ti.next();
                if (element.equals(tmp)) {
                    res = last;
                    break;
                }
                last = tmp;
            }
        }
        return res;
    }

    public EObject getPreviousElement(EObject element) throws BadLocationException {
        int[] elementOffsets;
        EObject res = null;
        if (this.root != null && (elementOffsets = this.fHelper.getElementOffsets(element, this.modelOffset)) != null) {
            TreeIterator ti = this.root.eResource().getAllContents();
            int maxEndOffset = -1;
            while (ti.hasNext()) {
                int[] tmpOffsets;
                EObject tmp = (EObject)ti.next();
                if (tmp.equals(element) || (tmpOffsets = this.fHelper.getElementOffsets(tmp, this.modelOffset)) == null || tmpOffsets[1] > elementOffsets[0] || tmpOffsets[1] <= maxEndOffset) continue;
                maxEndOffset = tmpOffsets[1];
                if (element.equals(tmp)) continue;
                res = tmp;
            }
        }
        return res;
    }

    public EObject getPreviousElement(EObject element, String type) throws BadLocationException {
        EObject previous = this.getPreviousElement(element);
        if (previous == null) {
            return null;
        }
        if (AtlTypesProcessor.oclIsKindOf(previous, type)) {
            return previous;
        }
        return this.getPreviousElement(previous, type);
    }

    public EObject getLocatedElement(int offset) throws BadLocationException {
        return this.fHelper.getLocatedElement(this.root, offset, this.modelOffset);
    }

    public List<String> getLostTypesNames() {
        ArrayList<String> res = new ArrayList<String>();
        for (EObject element : this.lostElements) {
            res.add(element.eClass().getName());
        }
        return res;
    }

    public List<EObject> getLostElementsByType(String typeName) {
        ArrayList<EObject> res = new ArrayList<EObject>();
        for (EObject element : this.lostElements) {
            if (!element.eClass().getName().equalsIgnoreCase(typeName)) continue;
            res.add(element);
        }
        return res;
    }

    public EObject getLastLostElementByType(String typeName) {
        List<EObject> found = this.getLostElementsByType(typeName);
        if (!found.isEmpty()) {
            return found.get(found.size() - 1);
        }
        return null;
    }

    public void displayModel() {
        if (this.root != null) {
            try {
                this.root.eResource().save((OutputStream)System.err, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("no model to display");
        }
    }

    public String getText(EObject locatedElement) throws BadLocationException {
        return this.fHelper.getText(locatedElement, this.modelOffset);
    }

    public int getModelOffset() {
        return this.modelOffset;
    }

    public EObject getRoot() {
        return this.root;
    }

    public AtlCompletionHelper getHelper() {
        return this.fHelper;
    }
}

