/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.preferences.MavenConfigurationImpl;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryRefreshJob;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IArchetype;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.IProjectCreationListener;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.BuildPathManager;
import org.eclipse.m2e.tests.common.FileHelpers;
import org.eclipse.m2e.tests.common.FilexWagon;
import org.eclipse.m2e.tests.common.HttxWagon;
import org.eclipse.m2e.tests.common.JobHelpers;
import org.eclipse.m2e.tests.common.WorkspaceHelpers;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public abstract class AbstractMavenProjectTestCase {
    private static final boolean STOP_ON_FAILED_TEST = Boolean.getBoolean("m2e.stopOnFailedTest");
    public static final int DELETE_RETRY_COUNT = 10;
    public static final long DELETE_RETRY_DELAY = 6000L;
    protected static final IProgressMonitor monitor = new IProgressMonitor(){
        AtomicBoolean canceled = new AtomicBoolean();

        public void worked(int work) {
            AbstractMavenProjectTestCase.driveEvents();
        }

        public void subTask(String name) {
            AbstractMavenProjectTestCase.driveEvents();
        }

        public void setTaskName(String name) {
            AbstractMavenProjectTestCase.driveEvents();
        }

        public void setCanceled(boolean value) {
            this.canceled.set(value);
        }

        public boolean isCanceled() {
            return this.canceled.get();
        }

        public void internalWorked(double work) {
            AbstractMavenProjectTestCase.driveEvents();
        }

        public void done() {
            AbstractMavenProjectTestCase.driveEvents();
        }

        public void beginTask(String name, int totalWork) {
            AbstractMavenProjectTestCase.driveEvents();
        }
    };
    protected IWorkspace workspace;
    @Rule
    public TestName name = new TestName();
    @Rule(order=-2147483648)
    public TestWatcher watchman = new TestWatcher(){

        protected void failed(Throwable e, Description description) {
            if (STOP_ON_FAILED_TEST) {
                AtomicBoolean wait = new AtomicBoolean(true);
                Shell shell = new Shell(Display.getCurrent());
                shell.setLayout((Layout)new FillLayout());
                Button button = new Button((Composite)shell, 8);
                button.setText("Shutdown test");
                SelectionListener.widgetSelectedAdapter(ev -> wait.set(false));
                shell.setVisible(true);
                shell.pack();
                while (wait.get() && !shell.isDisposed()) {
                    AbstractMavenProjectTestCase.driveEvents();
                    Display.getCurrent().sleep();
                }
            }
        }

        protected void succeeded(Description description) {
        }
    };
    protected File repo;
    protected ProjectRegistryRefreshJob projectRefreshJob;
    protected Job downloadSourcesJob;
    protected IMavenConfiguration mavenConfiguration;
    private String oldUserSettingsFile;

    @Before
    public void setUp() throws Exception {
        ArtifactRepository localRepository;
        monitor.setCanceled(false);
        this.workspace = ResourcesPlugin.getWorkspace();
        this.mavenConfiguration = MavenPlugin.getMavenConfiguration();
        this.setAutoBuilding(false);
        this.setAutomaticallyUpdateConfiguration(false);
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", ".svn/");
        JavaCore.setOptions((Hashtable)options);
        this.projectRefreshJob = MavenPluginActivator.getDefault().getProjectManagerRefreshJob();
        this.projectRefreshJob.sleep();
        this.downloadSourcesJob = ((BuildPathManager)MavenJdtPlugin.getDefault().getBuildpathManager()).getDownloadSourcesJob();
        this.downloadSourcesJob.sleep();
        this.oldUserSettingsFile = this.mavenConfiguration.getUserSettingsFile();
        File settings = new File("settings.xml").getCanonicalFile();
        if (settings.canRead()) {
            String userSettingsFile = settings.getAbsolutePath();
            this.mavenConfiguration.setUserSettingsFile(userSettingsFile);
        }
        if ((localRepository = MavenPlugin.getMaven().getLocalRepository()) != null) {
            this.repo = new File(localRepository.getBasedir());
        } else {
            Assert.fail((String)"Cannot determine local repository path");
        }
        LifecycleMappingFactory.setUseDefaultLifecycleMappingMetadataSource((boolean)true);
        LifecycleMappingFactory.setDefaultLifecycleMappingMetadataSource(null);
        WorkspaceHelpers.cleanWorkspace();
        Files.createDirectories(Path.of(this.workspace.getRoot().getLocationURI()).resolve(".mvn"), new FileAttribute[0]);
        FilexWagon.reset();
        HttxWagon.reset();
        AbstractMavenProjectTestCase.driveEvents();
    }

    protected void useSettings(String settings) throws IOException, CoreException {
        String userSettingsFile = new File(settings).getCanonicalFile().getAbsolutePath();
        this.mavenConfiguration.setUserSettingsFile(userSettingsFile);
    }

    @After
    public void tearDown() throws Exception {
        this.waitForJobsToComplete();
        AbstractMavenProjectTestCase.driveEvents();
        if (!STOP_ON_FAILED_TEST) {
            WorkspaceHelpers.cleanWorkspace();
        }
        this.mavenConfiguration.setUserSettingsFile(this.oldUserSettingsFile);
        this.projectRefreshJob.wakeUp();
        this.setAutoBuilding(false);
        this.setAutomaticallyUpdateConfiguration(false);
        FilexWagon.reset();
        HttxWagon.reset();
    }

    protected void setAutoBuilding(boolean autobuilding) throws CoreException {
        IWorkspaceDescription description = this.workspace.getDescription();
        description.setAutoBuilding(autobuilding);
        this.workspace.setDescription(description);
    }

    protected boolean isAutoBuilding() {
        IWorkspaceDescription description = this.workspace.getDescription();
        return description.isAutoBuilding();
    }

    protected void setAutomaticallyUpdateConfiguration(boolean update) {
        ((MavenConfigurationImpl)this.mavenConfiguration).setAutomaticallyUpdateConfiguration(update);
    }

    protected void refreshMavenProject(IProject project) {
        MavenPlugin.getMavenProjectRegistry().refresh(new MavenUpdateRequest(project, false, false));
    }

    protected void deleteProject(String projectName) throws CoreException, InterruptedException {
        IProject project = this.workspace.getRoot().getProject(projectName);
        this.deleteProject(project);
    }

    protected void deleteProject(IProject project) throws InterruptedException, CoreException {
        Exception cause = null;
        int i = 0;
        while (i < 10) {
            block4: {
                try {
                    this.doDeleteProject(project);
                }
                catch (InterruptedException | OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    cause = e;
                    Thread.sleep(6000L);
                    break block4;
                }
                return;
            }
            ++i;
        }
        throw new CoreException(Status.error((String)"Could not delete project", cause));
    }

    private void doDeleteProject(final IProject project) throws CoreException, InterruptedException {
        AbstractMavenProjectTestCase.waitForJobsToComplete(monitor);
        this.workspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (project.exists()) {
                    this.deleteMember(".classpath", project, monitor);
                    this.deleteMember(".project", project, monitor);
                    project.delete(false, true, monitor);
                }
            }

            private void deleteMember(String name, IProject project2, IProgressMonitor monitor) throws CoreException {
                IResource member = project2.findMember(name);
                if (member != null && member.exists()) {
                    member.delete(true, monitor);
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    protected IProject createProject(String projectName, String pomResource) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(pomResource);){
                return this.createProject(projectName, is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex1) {
            throw new CoreException(Status.error((String)ex1.toString(), (Throwable)ex1));
        }
    }

    protected IProject createProject(String projectName, InputStream pomContent) throws CoreException {
        IProject project = this.workspace.getRoot().getProject(projectName);
        this.workspace.run(m -> {
            IFile pomFile;
            project.create(m);
            if (!project.isOpen()) {
                project.open(m);
            }
            if (!(pomFile = project.getFile("pom.xml")).exists()) {
                try {
                    pomFile.create(pomContent, true, m);
                }
                catch (CoreException ex) {
                    throw new CoreException(Status.error((String)ex.toString(), (Throwable)ex));
                }
            }
        }, null);
        return project;
    }

    protected IProject createExisting(String projectName, String projectLocation) throws IOException, CoreException {
        return this.createExisting(projectName, projectLocation, false);
    }

    protected IProject createExisting(String projectName, String projectLocation, boolean addNature) throws IOException, CoreException {
        File dir = new File(this.workspace.getRoot().getLocation().toFile(), projectName);
        if (dir.isFile()) {
            dir = dir.getParentFile();
        }
        AbstractMavenProjectTestCase.copyDir(new File(projectLocation), dir);
        IProject project = this.workspace.getRoot().getProject(projectName);
        this.workspace.run(m -> {
            if (!project.exists()) {
                IProjectDescription projectDescription = this.workspace.newProjectDescription(project.getName());
                if (addNature) {
                    projectDescription.setNatureIds(new String[]{"org.eclipse.m2e.core.maven2Nature"});
                }
                projectDescription.setLocation(null);
                project.create(projectDescription, m);
                project.open(0, m);
            } else {
                project.refreshLocal(2, m);
            }
            AbstractMavenProjectTestCase.ensureDefaultCharset(project, m);
        }, null);
        if (!this.isAutoBuilding()) {
            this.refreshMavenProject(project);
        }
        return project;
    }

    protected IProject importProject(String pomLocation) throws IOException, CoreException {
        return this.importProject(pomLocation, new ResolverConfiguration());
    }

    protected IProject importProject(String pomLocation, ResolverConfiguration configuration) throws IOException, CoreException {
        return this.importProject(pomLocation, configuration, null);
    }

    protected IProject importProject(String pomLocation, ResolverConfiguration configuration, IProjectCreationListener listener) throws IOException, CoreException {
        File pomFile = new File(pomLocation);
        return this.importProjects(pomFile.getParentFile().getCanonicalPath(), new String[]{pomFile.getName()}, configuration, false, listener)[0];
    }

    protected IProject[] importProjects(String basedir, String[] pomNames, ResolverConfiguration configuration) throws IOException, CoreException {
        return this.importProjects(basedir, pomNames, configuration, false);
    }

    protected IProject[] importProjects(String basedir, String[] pomNames, ResolverConfiguration configuration, boolean skipSanityCheck) throws IOException, CoreException {
        return this.importProjects(basedir, pomNames, configuration, skipSanityCheck, null);
    }

    protected IProject[] importProjects(String basedir, String[] pomNames, ResolverConfiguration configuration, boolean skipSanityCheck, IProjectCreationListener listener) throws IOException, CoreException {
        MavenModelManager mavenModelManager = MavenPlugin.getMavenModelManager();
        File src = new File(basedir);
        File dst = new File(this.workspace.getRoot().getLocation().toFile(), src.getName());
        AbstractMavenProjectTestCase.copyDir(src, dst);
        ArrayList<MavenProjectInfo> projectInfos = new ArrayList<MavenProjectInfo>();
        String[] stringArray = pomNames;
        int n = pomNames.length;
        int n2 = 0;
        while (n2 < n) {
            String pomName = stringArray[n2];
            File pomFile = new File(dst, pomName);
            Model model = mavenModelManager.readMavenModel(pomFile);
            MavenProjectInfo projectInfo = new MavenProjectInfo(pomName, pomFile, model, null);
            this.setBasedirRename(projectInfo);
            projectInfos.add(projectInfo);
            ++n2;
        }
        ProjectImportConfiguration importConfiguration = new ProjectImportConfiguration(configuration);
        ArrayList importResults = new ArrayList();
        IProjectConfigurationManager configManager = MavenPlugin.getProjectConfigurationManager();
        this.workspace.run(m -> importResults.addAll(configManager.importProjects((Collection)projectInfos, importConfiguration, listener, m)), configManager.getRule(), 1, monitor);
        IProject[] projects = new IProject[projectInfos.size()];
        int i = 0;
        while (i < projectInfos.size()) {
            IMavenProjectImportResult importResult = (IMavenProjectImportResult)importResults.get(i);
            Assert.assertSame(projectInfos.get(i), (Object)importResult.getMavenProjectInfo());
            projects[i] = importResult.getProject();
            AbstractMavenProjectTestCase.ensureDefaultCharset(projects[i], monitor);
            Assert.assertNotNull((String)("Failed to import project " + String.valueOf(projectInfos)), (Object)projects[i]);
            if (!skipSanityCheck) {
                Model model = ((MavenProjectInfo)projectInfos.get(i)).getModel();
                IMavenProjectRegistry mavenProjectRegistry = MavenPlugin.getMavenProjectRegistry();
                IMavenProjectFacade facade = mavenProjectRegistry.create(projects[i], monitor);
                if (facade == null) {
                    Assert.fail((String)("Project " + model.getGroupId() + "-" + model.getArtifactId() + "-" + model.getVersion() + " was not imported. Errors: " + WorkspaceHelpers.toString(WorkspaceHelpers.findErrorMarkers(projects[i]))));
                }
            }
            ++i;
        }
        return projects;
    }

    private void setBasedirRename(MavenProjectInfo projectInfo) throws IOException {
        File workspaceRoot = this.workspace.getRoot().getLocation().toFile();
        File basedir = projectInfo.getPomFile().getParentFile().getCanonicalFile();
        projectInfo.setBasedirRename(basedir.getParentFile().equals(workspaceRoot) ? 2 : 0);
    }

    private static void ensureDefaultCharset(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project.getDefaultCharset(false) == null) {
            project.setDefaultCharset("UTF-8", monitor);
        }
    }

    protected IProject importProject(String projectName, String projectLocation, ResolverConfiguration configuration) throws IOException, CoreException {
        ProjectImportConfiguration importConfiguration = new ProjectImportConfiguration(configuration);
        importConfiguration.setProjectNameTemplate(projectName);
        return this.importProject(projectName, projectLocation, importConfiguration);
    }

    protected IProject importProject(String projectName, String projectLocation, ProjectImportConfiguration importConfiguration) throws IOException, CoreException {
        File dir = new File(this.workspace.getRoot().getLocation().toFile(), projectName);
        AbstractMavenProjectTestCase.copyDir(new File(projectLocation), dir);
        File pomFile = new File(dir, "pom.xml");
        Model model = MavenPlugin.getMavenModelManager().readMavenModel(pomFile);
        MavenProjectInfo projectInfo = new MavenProjectInfo(projectName, pomFile, model, null);
        this.setBasedirRename(projectInfo);
        this.workspace.run(m -> {
            MavenPlugin.getProjectConfigurationManager().importProjects(Collections.singleton(projectInfo), importConfiguration, m);
            IProject project = this.workspace.getRoot().getProject(ProjectConfigurationManager.getProjectName((ProjectImportConfiguration)importConfiguration, (Model)projectInfo.getModel()));
            Assert.assertNotNull((String)("Failed to import project " + String.valueOf(projectInfo)), (Object)project);
        }, MavenPlugin.getProjectConfigurationManager().getRule(), 1, monitor);
        return this.workspace.getRoot().getProject(projectName);
    }

    protected void waitForJobsToComplete() throws InterruptedException, CoreException {
        AbstractMavenProjectTestCase.waitForJobsToComplete(monitor);
    }

    public static void waitForJobsToComplete(IProgressMonitor monitor) throws InterruptedException, CoreException {
        JobHelpers.waitForJobsToComplete(monitor);
    }

    protected IClasspathEntry[] getMavenContainerEntries(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathContainer container = BuildPathManager.getMaven2ClasspathContainer((IJavaProject)javaProject);
        return container.getClasspathEntries();
    }

    protected static String toString(IMarker[] markers) {
        return WorkspaceHelpers.toString(markers);
    }

    protected static String toString(List<IMarker> markers) {
        return WorkspaceHelpers.toString(markers);
    }

    protected void copyContent(IProject project, String from, String to) throws Exception {
        this.copyContent(project, project.getFile(from).getContents(), to, true);
    }

    protected void copyContent(IProject project, String from, String to, boolean waitForJobsToComplete) throws Exception {
        this.copyContent(project, project.getFile(from).getContents(), to, waitForJobsToComplete);
    }

    protected void copyContent(IProject project, File from, String to) throws Exception {
        this.copyContent(project, new FileInputStream(from), to, true);
    }

    protected static <T> T withDefaultLifecycleMapping(PluginExecutionAction defaultAction, Callable<T> action) throws Exception {
        IMavenConfiguration configuration = MavenPlugin.getMavenConfiguration();
        PluginExecutionAction oldvalue = configuration.getDefaultMojoExecutionAction();
        try {
            configuration.setDefaultMojoExecutionAction(defaultAction);
            T t = action.call();
            return t;
        }
        finally {
            configuration.setDefaultMojoExecutionAction(oldvalue);
        }
    }

    private void copyContent(IProject project, InputStream contents, String to, boolean waitForJobsToComplete) throws CoreException, IOException, InterruptedException {
        IFile file;
        try {
            file = project.getFile(to);
            if (!file.exists()) {
                file.create(contents, 1, monitor);
            } else {
                file.setContents(contents, 1, monitor);
            }
        }
        finally {
            contents.close();
        }
        if (waitForJobsToComplete) {
            if (!this.isAutoBuilding() && file.getParent().getType() == 4 && "pom.xml".equals(file.getName())) {
                this.refreshMavenProject(project);
            }
            this.waitForJobsToComplete();
        }
    }

    public static void copyDir(File src, File dst) throws IOException {
        FileHelpers.copyDir(src, dst);
    }

    public static void copyDir(File src, File dst, FileFilter filter) throws IOException {
        FileHelpers.copyDir(src, dst, filter);
    }

    protected static List<IMarker> findErrorMarkers(IProject project) throws CoreException {
        return WorkspaceHelpers.findErrorMarkers(project);
    }

    protected static List<IMarker> findMarkers(IProject project, int targetSeverity) throws CoreException {
        return WorkspaceHelpers.findMarkers(project, targetSeverity);
    }

    protected static void assertNoErrors(IProject project) throws CoreException {
        WorkspaceHelpers.assertNoErrors(project);
    }

    protected static void assertMavenNature(IProject project) throws CoreException {
        Assert.assertTrue((String)("project " + project.getName() + " has no maven nature"), (boolean)project.hasNature("org.eclipse.m2e.core.maven2Nature"));
    }

    protected static Set<IProject> getProjectsFromEvents(Collection<MavenProjectChangedEvent> events) {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (MavenProjectChangedEvent event : events) {
            projects.add(event.getSource().getProject());
        }
        return projects;
    }

    protected void injectRedirectingWagons() throws Exception {
        this.injectWagon(FilexWagon.class, "filex");
        this.injectWagon(HttxWagon.class, HttxWagon.PROTOCOL);
    }

    private void injectWagon(Class<? extends Wagon> wagonClass, String wagonRoleHint) throws CoreException, CycleDetectedInComponentGraphException {
        PlexusContainer container = (PlexusContainer)MavenPlugin.getMaven().lookup(PlexusContainer.class);
        if (container.getContainerRealm().getResource(wagonClass.getName().replace('.', '/') + ".class") == null) {
            container.getContainerRealm().importFrom(wagonClass.getClassLoader(), wagonClass.getName());
            ComponentDescriptor descriptor = new ComponentDescriptor();
            descriptor.setRealm(container.getContainerRealm());
            descriptor.setRoleClass(Wagon.class);
            descriptor.setImplementationClass(wagonClass);
            descriptor.setRoleHint(wagonRoleHint);
            descriptor.setInstantiationStrategy("per-lookup");
            container.addComponentDescriptor(descriptor);
        }
    }

    protected Collection<IProject> createProjectsFromArchetype(String projectName, IArchetype archetype, IPath location) throws CoreException {
        return this.createProjectsFromArchetype(projectName, archetype, Map.of(), location);
    }

    protected Collection<IProject> createProjectsFromArchetype(String projectName, IArchetype archetype, Map<String, String> properties, IPath location) throws CoreException {
        ArrayList<IProject> eclipseProjects = new ArrayList<IProject>();
        this.workspace.run(m -> {
            Collection projects = M2EUIPluginActivator.getDefault().getArchetypePlugin().getGenerator().createArchetypeProjects(location, archetype, projectName, projectName, "0.0.1-SNAPSHOT", "test", properties, monitor);
            MavenPlugin.getProjectConfigurationManager().importProjects(projects, new ProjectImportConfiguration(), null, monitor).stream().filter(r -> r.getProject() != null && r.getProject().exists()).map(r -> r.getProject()).forEach(eclipseProjects::add);
        }, MavenPlugin.getProjectConfigurationManager().getRule(), 1, monitor);
        try {
            this.waitForJobsToComplete();
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted");
        }
        return eclipseProjects;
    }

    protected void deserializeFromWorkspaceState(IMavenProjectFacade projectFacade) throws IllegalAccessException {
        Field[] fieldArray = projectFacade.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Modifier.isTransient(field.getModifiers())) {
                field.setAccessible(true);
                field.set(projectFacade, null);
            }
            ++n2;
        }
        MavenPluginActivator.getDefault().getMavenProjectManagerImpl().putMavenProject((MavenProjectFacade)projectFacade, null);
    }

    public static Set<IFile> getPomFiles(IProject ... projects) {
        return Stream.of(projects).map(p -> p.getFile("pom.xml")).collect(Collectors.toSet());
    }

    public static void driveEvents() {
        Display current = Display.getCurrent();
        if (current != null) {
            while (current.readAndDispatch()) {
            }
        }
    }
}

