/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ValueImpl;

public class ClassValueImpl
extends ValueImpl {
    private String classQName;

    public ClassValueImpl(String classQName) {
        this.classQName = classQName;
    }

    @Override
    protected Expression getExpression(CompilationUnit unit, AST ast) {
        String clsName = this.classQName;
        if (this.addImports(ast, unit, clsName)) {
            clsName = ClassValueImpl.getSimpleName(clsName);
        }
        Name name = ast.newName(clsName);
        SimpleType simpleType = ast.newSimpleType(name);
        TypeLiteral literal = ast.newTypeLiteral();
        literal.setType((Type)simpleType);
        return literal;
    }

    @Override
    public String toString() {
        return this.classQName;
    }

    public int hashCode() {
        return this.classQName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassValueImpl other = (ClassValueImpl)obj;
        return this.classQName.equals(other.classQName);
    }
}

