/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.context.persistence;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCacheType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCaching;

public class EclipseLinkCachingEntity
extends AbstractModel
implements Cloneable,
Serializable {
    private String name;
    private EclipseLinkCaching parent;
    public static final String CACHE_TYPE_PROPERTY = "cacheType";
    public static final String CACHE_SIZE_PROPERTY = "cacheSize";
    public static final String SHARED_CACHE_PROPERTY = "sharedCache";
    private EclipseLinkCacheType cacheType;
    private Integer cacheSize;
    private Boolean cacheIsShared;
    private static final long serialVersionUID = 1L;
    public static final Transformer<EclipseLinkCachingEntity, String> NAME_TRANSFORMER = new NameTransformer();

    public EclipseLinkCachingEntity(EclipseLinkCaching parent, String name) {
        this(parent);
        if (StringTools.isBlank((String)name)) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    private EclipseLinkCachingEntity(EclipseLinkCaching parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (!(o instanceof EclipseLinkCachingEntity)) {
            return false;
        }
        EclipseLinkCachingEntity other = (EclipseLinkCachingEntity)o;
        return (this.cacheType == null ? other.cacheType == null : this.cacheType.equals((Object)other.cacheType)) && (this.cacheIsShared == null ? other.cacheIsShared == null : this.cacheIsShared.equals(other.cacheIsShared)) && (this.cacheSize == null ? other.cacheSize == null : this.cacheSize.equals(other.cacheSize));
    }

    public int hashCode() {
        return this.cacheType == null ? 0 : this.cacheType.hashCode();
    }

    public EclipseLinkCachingEntity clone() {
        try {
            return (EclipseLinkCachingEntity)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean isEmpty() {
        return this.cacheType == null && this.cacheSize == null && this.cacheIsShared == null;
    }

    public boolean entityNameIsValid() {
        return !StringTools.isBlank((String)this.name);
    }

    public EclipseLinkCaching getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public EclipseLinkCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(EclipseLinkCacheType cacheType) {
        EclipseLinkCacheType old = this.cacheType;
        this.cacheType = cacheType;
        this.firePropertyChanged(CACHE_TYPE_PROPERTY, (Object)old, (Object)cacheType);
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        Integer old = this.cacheSize;
        this.cacheSize = cacheSize;
        this.firePropertyChanged(CACHE_SIZE_PROPERTY, old, cacheSize);
    }

    public Boolean cacheIsShared() {
        return this.cacheIsShared;
    }

    public void setSharedCache(Boolean isShared) {
        Boolean old = this.cacheIsShared;
        this.cacheIsShared = isShared;
        this.firePropertyChanged(SHARED_CACHE_PROPERTY, old, isShared);
    }

    public void toString(StringBuilder sb) {
        sb.append("name: ");
        sb.append(this.name);
        sb.append(", cacheType: ");
        sb.append((Object)this.cacheType);
        sb.append(", cacheSize: ");
        sb.append(this.cacheSize);
        sb.append(", cacheIsShared: ");
        sb.append(this.cacheIsShared);
    }

    public static class NameTransformer
    extends TransformerAdapter<EclipseLinkCachingEntity, String> {
        public String transform(EclipseLinkCachingEntity entity) {
            return entity.getName();
        }
    }
}

