/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.gitflow.GitFlowConfig;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class GitFlowRepository {
    private Repository repository;

    public GitFlowRepository(@NonNull Repository repository) {
        this.repository = repository;
    }

    public boolean hasBranches() {
        try {
            List branches = Git.wrap((Repository)this.repository).branchList().call();
            return !branches.isEmpty();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasBranch(String branch) throws GitAPIException {
        String fullBranchName = "refs/heads/" + branch;
        List branchList = Git.wrap((Repository)this.repository).branchList().call();
        for (Ref ref : branchList) {
            if (!fullBranchName.equals(ref.getTarget().getName())) continue;
            return true;
        }
        return false;
    }

    public Ref findBranch(String branchName) throws IOException {
        return this.repository.exactRef("refs/heads/" + branchName);
    }

    public boolean isFeature() throws IOException {
        String branch = this.repository.getBranch();
        return branch != null && branch.startsWith(this.getConfig().getFeaturePrefix());
    }

    public boolean isDevelop() throws IOException {
        String branch = this.repository.getBranch();
        return branch != null && branch.equals(this.getConfig().getDevelop());
    }

    public boolean isMaster() throws IOException {
        String branch = this.repository.getBranch();
        return branch != null && branch.equals(this.getConfig().getMaster());
    }

    public boolean isRelease() throws IOException {
        String branch = this.repository.getBranch();
        return branch != null && branch.startsWith(this.getConfig().getReleasePrefix());
    }

    public boolean isHotfix() throws IOException {
        String branch = this.repository.getBranch();
        return branch != null && branch.startsWith(this.getConfig().getHotfixPrefix());
    }

    public RevCommit findHead() throws WrongGitFlowStateException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RevWalk walk = new RevWalk(this.repository);){
            ObjectId head = this.repository.resolve("HEAD");
            if (head == null) {
                throw new WrongGitFlowStateException(CoreText.GitFlowRepository_gitFlowRepositoryMayNotBeEmpty);
            }
            return walk.parseCommit((AnyObjectId)head);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public RevCommit findHead(String branchName) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk walk = new RevWalk(this.repository);){
            String revstr = "refs/heads/" + branchName;
            ObjectId head = this.repository.resolve(revstr);
            if (head != null) return walk.parseCommit((AnyObjectId)head);
            return null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public RevCommit findCommit(String sha1) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk walk = new RevWalk(this.repository);){
            ObjectId head = this.repository.resolve(sha1);
            return walk.parseCommit((AnyObjectId)head);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public List<Ref> getFeatureBranches() {
        return this.getPrefixBranches("refs/heads/" + this.getConfig().getFeaturePrefix());
    }

    public List<Ref> getReleaseBranches() {
        return this.getPrefixBranches("refs/heads/" + this.getConfig().getReleasePrefix());
    }

    public List<Ref> getHotfixBranches() {
        return this.getPrefixBranches("refs/heads/" + this.getConfig().getHotfixPrefix());
    }

    private List<Ref> getPrefixBranches(String prefix) {
        try {
            List branches = Git.wrap((Repository)this.repository).branchList().call();
            ArrayList<Ref> prefixBranches = new ArrayList<Ref>();
            for (Ref ref : branches) {
                if (!ref.getName().startsWith(prefix)) continue;
                prefixBranches.add(ref);
            }
            return prefixBranches;
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFeatureBranchName(Ref ref) {
        return ref.getName().substring(("refs/heads/" + this.getConfig().getFeaturePrefix()).length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RevCommit findCommitForTag(String tagName) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk revWalk = new RevWalk(this.repository);){
            Ref tagRef = this.repository.exactRef("refs/tags/" + tagName);
            if (tagRef != null) return revWalk.parseCommit((AnyObjectId)tagRef.getObjectId());
            return null;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public void setRemote(String featureName, String value) throws IOException {
        this.getConfig().setRemote(featureName, value);
    }

    public void setUpstreamBranchName(String featureName, String value) throws IOException {
        this.getConfig().setUpstreamBranchName(featureName, value);
    }

    public String getUpstreamBranchName(String featureName) {
        return this.getConfig().getUpstreamBranchName(featureName);
    }

    public GitFlowConfig getConfig() {
        return new GitFlowConfig(this.repository.getConfig());
    }

    public boolean isOnDevelop(@NonNull RevCommit selectedCommit) throws IOException {
        String develop = this.getConfig().getDevelopFull();
        return this.isOnBranch(selectedCommit, develop);
    }

    private boolean isOnBranch(RevCommit commit, String fullBranch) throws IOException {
        Ref branchRef = this.repository.exactRef(fullBranch);
        if (branchRef == null) {
            return false;
        }
        try {
            List list = Git.wrap((Repository)this.repository).branchList().setContains(commit.name()).call();
            return list.contains(branchRef);
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }
}

