/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.editor;

import org.eclipse.cdt.lsp.plugin.LspPlugin;
import org.eclipse.cdt.lsp.server.ICLanguageServerProvider;
import org.eclipse.cdt.lsp.util.LspUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IEditorAssociationOverride;
import org.eclipse.ui.part.FileEditorInput;

public class CEditorAssociationOverride
implements IEditorAssociationOverride {
    private final ICLanguageServerProvider cLanguageServerProvider = LspPlugin.getDefault().getCLanguageServerProvider();

    public IEditorDescriptor[] overrideEditors(IEditorInput editorInput, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        if (this.isNoCElement(contentType)) {
            return editorDescriptors;
        }
        if (this.isEnabledFor(editorInput, contentType)) {
            return this.editorFilter("org.eclipse.cdt.ui.editor.CEditor", editorDescriptors);
        }
        return this.editorFilter("org.eclipse.cdt.lsp.CEditor", editorDescriptors);
    }

    public IEditorDescriptor[] overrideEditors(String fileName, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fileName);
        if (resource != null && resource instanceof IFile) {
            return this.overrideEditors((IEditorInput)new FileEditorInput((IFile)resource), contentType, editorDescriptors);
        }
        return editorDescriptors;
    }

    public IEditorDescriptor overrideDefaultEditor(IEditorInput editorInput, IContentType contentType, IEditorDescriptor editorDescriptor) {
        IEditorDescriptor descriptor = this.getEditorDescriptor(editorInput, contentType);
        return descriptor != null ? descriptor : editorDescriptor;
    }

    public IEditorDescriptor overrideDefaultEditor(String fileName, IContentType contentType, IEditorDescriptor editorDescriptor) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fileName);
        if (resource != null && resource instanceof IFile) {
            return this.overrideDefaultEditor((IEditorInput)new FileEditorInput((IFile)resource), contentType, editorDescriptor);
        }
        return editorDescriptor;
    }

    private boolean isEnabledFor(IEditorInput editorInput, IContentType contentType) {
        if (this.cLanguageServerProvider == null) {
            return false;
        }
        IResource resource = (IResource)editorInput.getAdapter(IResource.class);
        if (resource != null) {
            boolean enabled = this.cLanguageServerProvider.isEnabledFor(resource.getProject());
            if (enabled) {
                this.deleteCodanMarkers(resource);
            }
            return enabled;
        }
        return LspUtils.isFileOpenedInLspEditor(editorInput, contentType);
    }

    private void deleteCodanMarkers(final IResource resource) {
        WorkspaceJob wsJob = new WorkspaceJob("Remove codan markers"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    resource.deleteMarkers("org.eclipse.cdt.codan.core.codanProblem", true, 2);
                }
                catch (CoreException e) {
                    Platform.getLog(CEditorAssociationOverride.class).log(e.getStatus());
                }
                return Status.OK_STATUS;
            }
        };
        wsJob.setRule((ISchedulingRule)resource);
        wsJob.setSystem(true);
        wsJob.schedule();
    }

    private boolean isNoCElement(IContentType contentType) {
        if (contentType == null) {
            return true;
        }
        return !LspUtils.isCContentType(contentType.getId());
    }

    private IEditorDescriptor[] editorFilter(String editorId, IEditorDescriptor[] editorDescriptors) {
        if (editorId != null) {
            int i = 0;
            while (i < editorDescriptors.length) {
                if (editorId.equals(editorDescriptors[i].getId())) {
                    IEditorDescriptor[] filteredDesc = new IEditorDescriptor[editorDescriptors.length - 1];
                    System.arraycopy(editorDescriptors, 0, filteredDesc, 0, i);
                    System.arraycopy(editorDescriptors, i + 1, filteredDesc, i, editorDescriptors.length - i - 1);
                    return filteredDesc;
                }
                ++i;
            }
        }
        return editorDescriptors;
    }

    private IEditorDescriptor getEditorDescriptor(IEditorInput editorInput, IContentType contentType) {
        if (this.isNoCElement(contentType)) {
            return null;
        }
        if (this.isEnabledFor(editorInput, contentType)) {
            return this.getEditorDescriptorById(editorInput.getName(), "org.eclipse.cdt.lsp.CEditor", contentType);
        }
        return this.getEditorDescriptorById(editorInput.getName(), "org.eclipse.cdt.ui.editor.CEditor", contentType);
    }

    private IEditorDescriptor getEditorDescriptorById(String fileName, String editorId, IContentType contentType) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor[] iEditorDescriptorArray = registry.getEditors(fileName, contentType);
        int n = iEditorDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor descriptor = iEditorDescriptorArray[n2];
            if (editorId.equals(descriptor.getId())) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }
}

