/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryNameKey;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsHolder;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsManager;
import org.eclipse.cdt.internal.core.settings.model.CRefSettingsHolder;

class CSettingsRefInfo {
    private HashMap<CExternalSettingsManager.CContainerRef, CRefSettingsHolder> fESHolderMap = new LinkedHashMap<CExternalSettingsManager.CContainerRef, CRefSettingsHolder>();

    CSettingsRefInfo() {
    }

    CSettingsRefInfo(ICStorageElement el) {
        ICStorageElement[] iCStorageElementArray = el.getChildren();
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            String name = child.getName();
            if ("externalSettings".equals(name)) {
                CRefSettingsHolder h = new CRefSettingsHolder(child);
                CExternalSettingsManager.CContainerRef r = h.getContainerInfo();
                this.fESHolderMap.put(r, h);
            }
            ++n2;
        }
    }

    CSettingsRefInfo(CSettingsRefInfo base) {
        this.fESHolderMap = (LinkedHashMap)base.fESHolderMap.clone();
        for (Map.Entry<CExternalSettingsManager.CContainerRef, CRefSettingsHolder> e : this.fESHolderMap.entrySet()) {
            CRefSettingsHolder h = e.getValue();
            h = new CRefSettingsHolder(h);
            e.setValue(h);
        }
    }

    CExternalSettingsManager.CContainerRef[] getReferences(String factoryId) {
        ArrayList<CExternalSettingsManager.CContainerRef> list = new ArrayList<CExternalSettingsManager.CContainerRef>();
        for (CExternalSettingsManager.CContainerRef r : this.fESHolderMap.keySet()) {
            if (!r.getFactoryId().equals(factoryId)) continue;
            list.add(r);
        }
        return list.toArray(new CExternalSettingsManager.CContainerRef[list.size()]);
    }

    CExternalSettingsManager.CContainerRef[] getReferences() {
        return this.fESHolderMap.keySet().toArray(new CExternalSettingsManager.CContainerRef[this.fESHolderMap.size()]);
    }

    CRefSettingsHolder get(CExternalSettingsManager.CContainerRef cRef) {
        return this.fESHolderMap.get(cRef);
    }

    void serialize(ICStorageElement element) {
        for (CRefSettingsHolder h : this.fESHolderMap.values()) {
            ICStorageElement child = element.createChild("externalSettings");
            h.serialize(child);
        }
    }

    void put(CRefSettingsHolder holder) {
        this.fESHolderMap.put(holder.getContainerInfo(), holder);
    }

    CRefSettingsHolder remove(CExternalSettingsManager.CContainerRef cRef) {
        return this.fESHolderMap.remove(cRef);
    }

    CExternalSetting[] createExternalSettings() {
        if (this.fESHolderMap.size() == 0) {
            return new CExternalSetting[0];
        }
        if (this.fESHolderMap.size() == 1) {
            return this.fESHolderMap.values().iterator().next().getExternalSettings();
        }
        CExternalSettingsHolder holder = new CExternalSettingsHolder();
        for (CExternalSettingsHolder cExternalSettingsHolder : this.fESHolderMap.values()) {
            holder.setExternalSettings(cExternalSettingsHolder.getExternalSettings(), true);
        }
        return holder.getExternalSettings();
    }

    ICSettingEntry[] getAllEntries(int kind) {
        LinkedHashMap<EntryNameKey, ICSettingEntry> map = new LinkedHashMap<EntryNameKey, ICSettingEntry>();
        for (CRefSettingsHolder h : this.fESHolderMap.values()) {
            CExternalSetting[] settings = h.getExternalSettings();
            int i = 0;
            while (i < settings.length) {
                ICSettingEntry[] entries = settings[i].getEntries(kind);
                CDataUtil.fillEntriesMapByNameKey(map, entries);
                ++i;
            }
        }
        return map.values().toArray(new ICSettingEntry[map.size()]);
    }
}

