/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IOUtils2 {
    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix);
        tempFile.delete();
        tempFile.mkdirs();
        return tempFile;
    }

    public static String getPortableAbsolutePath(URL url) {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(url.getPath());
        }
        String path = f.getAbsolutePath();
        path = StringUtils.replace((String)path, (String)"%20", (String)" ");
        return IOUtils2.toPortablePath(path);
    }

    public static String toPortablePath(String path) {
        return FilenameUtils.separatorsToUnix((String)path);
    }

    public static String readString(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        return IOUtils2.readString(input);
    }

    public static String readString(InputStream input) throws IOException {
        try {
            String string = IOUtils.toString((InputStream)input);
            return string;
        }
        finally {
            input.close();
        }
    }

    public static String readString(Reader input) throws IOException {
        try {
            String string = IOUtils.toString((Reader)input);
            return string;
        }
        finally {
            input.close();
        }
    }

    public static String readFirstLine(InputStream input) throws IOException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(input));
            String string = br.readLine();
            return string;
        }
        finally {
            input.close();
        }
    }

    public static String readString(IFile file) throws Exception {
        return IOUtils2.readString(file.getContents(true));
    }

    public static byte[] readBytes(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        return IOUtils2.readBytes(input);
    }

    public static byte[] readBytes(InputStream input) throws IOException {
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)input);
            return byArray;
        }
        finally {
            input.close();
        }
    }

    public static byte[] readByteArray(ObjectInputStream ois) throws IOException {
        int length = ois.readInt();
        byte[] bytes = new byte[length];
        ois.readFully(bytes);
        return bytes;
    }

    public static void writeBytes(File file, InputStream input) throws IOException {
        IOUtils2.copyAndClose(new FileOutputStream(file), input);
    }

    public static void copyAndClose(OutputStream output, InputStream input) throws IOException {
        try {
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    public static void writeBytes(File file, byte[] input) throws IOException {
        IOUtils2.writeBytes(new FileOutputStream(file), input);
    }

    public static void writeBytes(OutputStream output, byte[] input) throws IOException {
        try {
            output.write(input);
        }
        finally {
            output.close();
        }
    }

    public static void writeByteArray(ObjectOutputStream oos, byte[] bytes) throws IOException {
        oos.writeInt(bytes.length);
        oos.write(bytes);
    }

    public static void writeString(OutputStream output, String outString) throws IOException {
        IOUtils.copy((InputStream)IOUtils.toInputStream((String)outString), (OutputStream)output);
    }

    public static boolean setFileContents(IFile file, InputStream inputStream) throws CoreException {
        if (file.exists()) {
            file.setContents(inputStream, true, false, null);
            return false;
        }
        IOUtils2.ensureFolderExists(file);
        file.create(inputStream, true, null);
        return true;
    }

    public static void setFileContents(IFile file, String contents) throws CoreException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes());
        IOUtils2.setFileContents(file, inputStream);
    }

    public static void storeProperties(IFile file, Properties properties) throws CoreException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        properties.store(baos, null);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        IOUtils2.setFileContents(file, bais);
    }

    public static void ensureFolderExists(IFile file) throws CoreException {
        if (file.getParent() instanceof IFolder) {
            IOUtils2.ensureFolderExists((IFolder)file.getParent());
        }
    }

    public static IFolder ensureFolderExists(IProject project, String path) throws CoreException {
        IFolder folder = project.getFolder((IPath)new Path(path));
        IOUtils2.ensureFolderExists(folder);
        return folder;
    }

    public static void ensureFolderExists(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                IOUtils2.ensureFolderExists((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }
}

