/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.wizards.AbstractDesignWizardPage;
import org.eclipse.wb.internal.core.wizards.DesignerNewElementWizard;
import org.eclipse.wb.internal.core.wizards.WizardUtils;

public abstract class AbstractDesignWizard
extends DesignerNewElementWizard {
    private static final String EDITOR_ID = "org.eclipse.wb.core.guiEditor";
    protected AbstractDesignWizardPage m_mainPage;

    public void addPages() {
        if (!this.validateSelection()) {
            return;
        }
        this.m_mainPage = this.createMainPage();
        this.addPage((IWizardPage)this.m_mainPage);
        this.m_mainPage.setInitialSelection(this.getSelection());
    }

    protected abstract AbstractDesignWizardPage createMainPage();

    protected boolean validateSelection() {
        return true;
    }

    @Override
    public boolean performFinish() {
        boolean canFinish = super.performFinish();
        if (canFinish) {
            this.openEditor();
        }
        return canFinish;
    }

    @Override
    protected void finishPage(IProgressMonitor monitor) throws Exception {
        if (this.getJavaProject() != null && this.getJavaProject().getModuleDescription() != null) {
            this.updateModuleInfo(this.getJavaProject().getModuleDescription());
        }
        this.m_mainPage.createType(monitor);
    }

    public final IJavaElement getCreatedElement() {
        return this.m_mainPage.getCreatedType();
    }

    private void updateModuleInfo(IModuleDescription moduleDescription) throws Exception {
        Set<String> moduleNames = Set.of(moduleDescription.getRequiredModuleNames());
        if (moduleNames.containsAll(this.getRequiredModuleNames())) {
            return;
        }
        IFile moduleInfo = (IFile)moduleDescription.getResource();
        ArrayList<String> lines = new ArrayList<String>(Files.readAllLines(moduleInfo.getLocation().toPath()));
        boolean moduleHeaderFound = false;
        boolean moduleBodyFound = false;
        int i = 0;
        while (i < lines.size()) {
            if (((String)lines.get(i)).contains("module")) {
                moduleHeaderFound = true;
            }
            if (((String)lines.get(i)).contains("{")) {
                moduleBodyFound = true;
            }
            if (moduleHeaderFound && moduleBodyFound) {
                for (String moduleName : this.getRequiredModuleNames()) {
                    if (moduleNames.contains(moduleName)) continue;
                    lines.add(i + 1, String.format("\trequires %s;", moduleName));
                }
                break;
            }
            ++i;
        }
        String sourceCode = lines.stream().reduce((u, v) -> u + System.lineSeparator() + v).orElse(null);
        if (sourceCode != null) {
            Throwable throwable = null;
            Iterator<String> iterator = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(sourceCode.getBytes(StandardCharsets.UTF_8));){
                moduleInfo.setContents((InputStream)is, 1, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        ProjectUtils.requireModuleAttribute(this.getJavaProject());
    }

    protected abstract Set<String> getRequiredModuleNames();

    protected void openEditor() {
        IFile file = (IFile)this.m_mainPage.getModifiedResource();
        this.openEditor(file);
    }

    protected void openEditor(IFile file) {
        this.openResource(file, EDITOR_ID);
    }

    protected final IJavaProject getJavaProject() {
        IStructuredSelection selection = this.getSelection();
        return WizardUtils.getJavaProject(selection);
    }
}

