/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.helpers;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.internal.core.BundleResourceProvider;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.description.IToolkitProvider;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.description.resource.ClassResourceInfo;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.model.description.resource.ResourceInfo;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.osgi.framework.Bundle;

public final class DescriptionHelper {
    private static Schema m_wbpComponentSchema;
    public static final String[] ICON_EXTS;
    private static final String POINT_TOOLKITS = "org.eclipse.wb.core.toolkits";
    private static Map<String, ToolkitDescription> m_idToToolkit;

    static {
        ICON_EXTS = new String[]{".png", ".gif"};
    }

    public static void addDescriptionResources(LinkedList<ClassResourceInfo> descriptions, ILoadingContext context, Class<?> currentClass) throws Exception {
        if (currentClass != null) {
            ResourceInfo resource = DescriptionHelper.getComponentDescriptionResource(context, currentClass);
            if (resource != null) {
                DescriptionHelper.validateComponentDescription(resource);
                descriptions.addFirst(new ClassResourceInfo(currentClass, resource));
            }
            Class<?>[] classArray = currentClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceClass = classArray[n2];
                DescriptionHelper.addDescriptionResources(descriptions, context, interfaceClass);
                ++n2;
            }
            DescriptionHelper.addDescriptionResources(descriptions, context, currentClass.getSuperclass());
        }
    }

    public static synchronized void validateComponentDescription(ResourceInfo resource) throws Exception {
        if (EnvironmentUtils.isTestingTime()) {
            if (m_wbpComponentSchema == null) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                BundleResourceProvider provider = BundleResourceProvider.get((String)"org.eclipse.wb.core.databinding.xsd");
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream schemaStream = provider.getFile("schema/wbp-component.xsd");){
                    m_wbpComponentSchema = factory.newSchema(new StreamSource(schemaStream));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            try (InputStream contents = resource.getURL().openStream();){
                try {
                    Validator validator = m_wbpComponentSchema.newValidator();
                    validator.validate(new StreamSource(contents));
                }
                catch (Throwable e) {
                    throw new Exception("Exception during validation " + String.valueOf(resource.getURL()), e);
                }
            }
        }
    }

    public static ImageDescriptor getIcon(ILoadingContext context, Class<?> componentClass) throws Exception {
        return DescriptionHelper.getIcon(context, componentClass, "");
    }

    public static ImageDescriptor getIcon(ILoadingContext context, Class<?> componentClass, String suffix) throws Exception {
        String iconPath = componentClass.getName().replace('.', '/') + suffix;
        return DescriptionHelper.getIcon(context, iconPath);
    }

    public static ImageDescriptor getIcon(ILoadingContext context, String iconPath) throws Exception {
        String[] stringArray = ICON_EXTS;
        int n = ICON_EXTS.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            String iconName = iconPath + ext;
            ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo0(context, iconName, true);
            if (resourceInfo != null) {
                return ImageDescriptor.createFromURL((URL)resourceInfo.getURL());
            }
            ++n2;
        }
        return null;
    }

    public static boolean hasForcedToolkitForComponent(ILoadingContext context, String toolkitId, String componentClassName) throws Exception {
        String name = componentClassName.replace('.', '/') + ".wbp-forced-toolkit.txt";
        ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo0(context, name, true);
        if (resourceInfo != null) {
            return IOUtils2.readString((InputStream)resourceInfo.getURL().openStream()).equals(toolkitId);
        }
        return false;
    }

    public static boolean hasComponentDescriptionResource(ILoadingContext context, Class<?> componentClass) throws Exception {
        return DescriptionHelper.getComponentDescriptionResource(context, componentClass) != null;
    }

    public static ResourceInfo getComponentDescriptionResource(ILoadingContext context, Class<?> componentClass) throws Exception {
        String name = componentClass.getName().replace('.', '/') + ".wbp-component.xml";
        return DescriptionHelper.getResourceInfo(context, componentClass, name);
    }

    static ResourceInfo getResourceInfo(ILoadingContext context, Class<?> resourceClass, String defaultPath) throws Exception {
        for (IDescriptionVersionsProvider provider : context.getDescriptionVersionsProviders()) {
            List<String> versions = provider.getVersions(resourceClass);
            for (String version : versions) {
                String versionedPath = version + "/" + defaultPath;
                ResourceInfo resource = DescriptionHelper.getResourceInfo0(context, versionedPath, false);
                if (resource == null) continue;
                return resource;
            }
        }
        return DescriptionHelper.getResourceInfo0(context, defaultPath, true);
    }

    private static ResourceInfo getResourceInfo0(ILoadingContext context, String name, boolean tryContext) throws Exception {
        ResourceInfo result;
        String key = "ComponentDescriptionHelper.getResourceInfo0.hasResult";
        HashMap<String, ResourceInfo> cacheResult = (HashMap<String, ResourceInfo>)context.getGlobalValue(key);
        if (cacheResult == null) {
            cacheResult = new HashMap<String, ResourceInfo>();
            context.putGlobalValue(key, cacheResult);
        }
        if ((result = (ResourceInfo)cacheResult.get(name)) != null) {
            return result;
        }
        String key2 = "ComponentDescriptionHelper.getResourceInfo0.noResult";
        HashSet<String> cacheNoResult = (HashSet<String>)context.getGlobalValue(key2);
        if (cacheNoResult == null) {
            cacheNoResult = new HashSet<String>();
            context.putGlobalValue(key2, cacheNoResult);
        }
        if (cacheNoResult.contains(name)) {
            return null;
        }
        result = DescriptionHelper.getResourceInfo00(context, name, tryContext);
        if (result != null) {
            cacheResult.put(name, result);
        } else {
            cacheNoResult.add(name);
        }
        return result;
    }

    private static ResourceInfo getResourceInfo00(ILoadingContext context, String name, boolean tryContext) throws Exception {
        Object resource = DescriptionHelper.getResourceInfo(name, context.getToolkitId());
        if (resource != null) {
            return resource;
        }
        for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements()) {
            if (!DescriptionHelper.hasMatchingResourcePrefix(toolkitElement, name)) continue;
            return null;
        }
        if (tryContext && (resource = context.getResource(name)) != null) {
            return new ResourceInfo(null, null, (URL)resource);
        }
        return null;
    }

    private static ResourceInfo getResourceInfo(IConfigurationElement toolkitElement, String name) throws Exception {
        if (!DescriptionHelper.canHaveResource(toolkitElement, name)) {
            return null;
        }
        String toolkitId = ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)toolkitElement, (String)"id");
        Bundle bundle = ExternalFactoriesHelper.getExtensionBundle((IConfigurationElement)toolkitElement);
        return DescriptionHelper.getResourceInfo(toolkitId, bundle, name);
    }

    private static boolean canHaveResource(IConfigurationElement toolkitElement, String name) {
        IConfigurationElement[] prefixElements = DescriptionHelper.getResourcePrefixElements(toolkitElement);
        if (prefixElements.length != 0) {
            return DescriptionHelper.hasMatchingResourcePrefix(prefixElements, name);
        }
        return true;
    }

    private static boolean hasMatchingResourcePrefix(IConfigurationElement toolkitElement, String name) {
        IConfigurationElement[] prefixElements = DescriptionHelper.getResourcePrefixElements(toolkitElement);
        return DescriptionHelper.hasMatchingResourcePrefix(prefixElements, name);
    }

    private static IConfigurationElement[] getResourcePrefixElements(IConfigurationElement toolkitElement) {
        IConfigurationElement[] prefixContainers;
        IConfigurationElement[] iConfigurationElementArray = prefixContainers = toolkitElement.getChildren("resourcePrefixes");
        if (prefixContainers.length != 0) {
            IConfigurationElement containerElement = iConfigurationElementArray[0];
            return containerElement.getChildren("resourcePrefix");
        }
        return new IConfigurationElement[0];
    }

    private static boolean hasMatchingResourcePrefix(IConfigurationElement[] prefixElements, String name) {
        IConfigurationElement[] iConfigurationElementArray = prefixElements;
        int n = prefixElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement prefixElement = iConfigurationElementArray[n2];
            String prefix = prefixElement.getValue().replace('.', '/');
            if (name.startsWith(prefix)) {
                return true;
            }
            String nameWithoutVersion = StringUtils.substringAfter((String)name, (String)"/");
            if (nameWithoutVersion.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ResourceInfo getResourceInfo(String toolkitId, Bundle bundle, String name) throws Exception {
        URL resource = bundle.getEntry("wbp-meta/" + name);
        if (resource != null) {
            ToolkitDescription toolkit = toolkitId != null ? DescriptionHelper.getToolkit(toolkitId) : null;
            return new ResourceInfo(bundle, toolkit, resource);
        }
        return null;
    }

    public static ResourceInfo getResourceInfo(String name) throws Exception {
        return DescriptionHelper.getResourceInfo(name, null);
    }

    public static ResourceInfo getResourceInfo(String name, String activeToolkitId) throws Exception {
        List<IConfigurationElement> toolkitElements = DescriptionHelper.getToolkitElements();
        if (!StringUtils.isEmpty((CharSequence)activeToolkitId)) {
            for (IConfigurationElement toolkitElement : toolkitElements) {
                ResourceInfo resourceInfo;
                String toolkitId = ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)toolkitElement, (String)"id");
                if (!toolkitId.equals(activeToolkitId) || (resourceInfo = DescriptionHelper.getResourceInfo(toolkitElement, name)) == null) continue;
                return resourceInfo;
            }
        }
        for (IConfigurationElement toolkitElement : toolkitElements) {
            ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo(toolkitElement, name);
            if (resourceInfo == null) continue;
            return resourceInfo;
        }
        return null;
    }

    public static List<IConfigurationElement> getToolkitElements() {
        return ExternalFactoriesHelper.getElements((String)POINT_TOOLKITS, (String)"toolkit");
    }

    public static List<IConfigurationElement> getToolkitElements(String toolkitId) {
        ArrayList<IConfigurationElement> toolkitElements = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement element : DescriptionHelper.getToolkitElements()) {
            if (!ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"id").equals(toolkitId)) continue;
            toolkitElements.add(element);
        }
        return toolkitElements;
    }

    public static ToolkitDescription[] getToolkits() throws Exception {
        ArrayList<ToolkitDescription> toolkits = new ArrayList<ToolkitDescription>();
        HashSet<String> addedToolkits = new HashSet<String>();
        for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements()) {
            String id = toolkitElement.getAttribute("id");
            if (addedToolkits.contains(id)) continue;
            addedToolkits.add(id);
            toolkits.add(DescriptionHelper.getToolkit(id));
        }
        return toolkits.toArray(new ToolkitDescription[toolkits.size()]);
    }

    public static synchronized ToolkitDescription getToolkit(String toolkitId) throws Exception {
        Assert.isNotNull((Object)toolkitId);
        if (m_idToToolkit == null) {
            m_idToToolkit = new TreeMap<String, ToolkitDescription>();
            for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements()) {
                IConfigurationElement[] providerElements;
                IConfigurationElement[] iConfigurationElementArray = providerElements = toolkitElement.getChildren("provider");
                int n = providerElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement providerElement = iConfigurationElementArray[n2];
                    IToolkitProvider toolkitProvider = (IToolkitProvider)providerElement.createExecutableExtension("class");
                    ToolkitDescription toolkitDescription = toolkitProvider.getDescription();
                    m_idToToolkit.put(toolkitDescription.getId(), toolkitDescription);
                    ++n2;
                }
            }
        }
        ToolkitDescription toolkitDescription = m_idToToolkit.get(toolkitId);
        Assert.isNotNull((Object)toolkitDescription, (String)("Can not find description for toolkit: " + toolkitId));
        return toolkitDescription;
    }

    public static Class<?> loadModelClass(String className) throws Exception {
        for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements()) {
            Bundle bundle = ExternalFactoriesHelper.getExtensionBundle((IConfigurationElement)toolkitElement);
            try {
                return bundle.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(className);
    }
}

