/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseQueryGroup;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFilter;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;

public class PackageBasedQueryGroup
extends BaseQueryGroup {
    private final Set<IQuerySpecification<?>> querySpecifications = new HashSet();
    private final String packageName;
    private final boolean includeSubPackages;
    private IRegistryView view;

    public PackageBasedQueryGroup(String packageName) {
        this(packageName, false);
    }

    public PackageBasedQueryGroup(String packageName, boolean includeSubPackages) {
        this.packageName = packageName;
        this.includeSubPackages = includeSubPackages;
        IQuerySpecificationRegistry registry = QuerySpecificationRegistry.getInstance();
        this.view = registry.createView(new PackageNameBasedViewFilter());
        for (IQuerySpecificationRegistryEntry entry : this.view.getEntries()) {
            this.querySpecifications.add((IQuerySpecification)entry.get());
        }
        SpecificationSetUpdater listener = new SpecificationSetUpdater();
        this.view.addViewListener(listener);
    }

    @Override
    public Set<IQuerySpecification<?>> getSpecifications() {
        return Collections.unmodifiableSet(new HashSet(this.querySpecifications));
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isIncludeSubPackages() {
        return this.includeSubPackages;
    }

    public void refresh() {
    }

    private final class PackageNameBasedViewFilter
    implements IRegistryViewFilter {
        private PackageNameBasedViewFilter() {
        }

        @Override
        public boolean isEntryRelevant(IQuerySpecificationRegistryEntry entry) {
            String name;
            String fqn = entry.getFullyQualifiedName();
            return PackageBasedQueryGroup.this.packageName.length() + 1 < fqn.length() && (PackageBasedQueryGroup.this.includeSubPackages ? fqn.startsWith(PackageBasedQueryGroup.this.packageName + ".") : fqn.equals(PackageBasedQueryGroup.this.packageName + "." + (name = fqn.substring(fqn.lastIndexOf(46) + 1, fqn.length()))));
        }
    }

    private final class SpecificationSetUpdater
    implements IQuerySpecificationRegistryChangeListener {
        private SpecificationSetUpdater() {
        }

        @Override
        public void entryAdded(IQuerySpecificationRegistryEntry entry) {
            PackageBasedQueryGroup.this.querySpecifications.add((IQuerySpecification)entry.get());
        }

        @Override
        public void entryRemoved(IQuerySpecificationRegistryEntry entry) {
            PackageBasedQueryGroup.this.querySpecifications.remove(entry.get());
        }
    }
}

