/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguageFactory;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.ui.hover.XbaseInformationControlInput;

final class PatternImporter
extends ReplacementTextApplier {
    private ImportState importStatus;
    private Pattern targetPattern;

    PatternImporter() {
    }

    private Pattern getTargetPattern(ConfigurableCompletionProposal prop) {
        XbaseInformationControlInput input;
        Object info = prop.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        if (info instanceof XbaseInformationControlInput && (input = (XbaseInformationControlInput)info).getElement() instanceof Pattern) {
            return (Pattern)input.getElement();
        }
        return null;
    }

    public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
        if (document instanceof IXtextDocument) {
            IXtextDocument xtextDocument = (IXtextDocument)document;
            this.targetPattern = this.getTargetPattern(proposal);
            if (this.targetPattern == null || Strings.isNullOrEmpty((String)this.targetPattern.getName())) {
                return;
            }
            final String targetPackage = PatternLanguageHelper.getPackageName((Pattern)this.targetPattern);
            this.importStatus = (ImportState)((Object)((IXtextDocument)document).readOnly((IUnitOfWork)new IUnitOfWork<ImportState, XtextResource>(){

                public ImportState exec(XtextResource state) throws Exception {
                    PatternModel model = (PatternModel)Iterators.find((Iterator)state.getAllContents(), (Predicate)Predicates.instanceOf(PatternModel.class));
                    if (Objects.equals(targetPackage, model.getPackageName())) {
                        return ImportState.SAMEPACKAGE;
                    }
                    VQLImportSection importSection = model.getImportPackages();
                    PatternImport relatedImport = importSection.getPatternImport().stream().filter(decl -> PatternImporter.this.targetPattern.equals(decl.getPattern()) || PatternImporter.this.targetPattern.getName().equals(decl.getPattern().getName())).findFirst().orElse(null);
                    if (relatedImport == null) {
                        return ImportState.NONE;
                    }
                    if (PatternImporter.this.targetPattern.equals(relatedImport.getPattern())) {
                        return ImportState.FOUND;
                    }
                    return ImportState.CONFLICTING;
                }
            }));
            String replacementString = this.getActualReplacementString(proposal) + "();";
            ReplaceEdit edit = new ReplaceEdit(proposal.getReplacementOffset(), proposal.getReplacementLength(), replacementString);
            edit.apply(document);
            int cursorOffset = this.getActualReplacementString(proposal).length() + 2;
            if (this.importStatus == ImportState.NONE) {
                xtextDocument.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource state) throws Exception {
                        VQLImportSection importSection = (VQLImportSection)Iterators.find((Iterator)state.getAllContents(), (Predicate)Predicates.instanceOf(VQLImportSection.class), null);
                        if (importSection.getImportDeclarations().size() + importSection.getPackageImport().size() + importSection.getPatternImport().size() == 0) {
                            VQLImportSection newSection = PatternLanguageFactory.eINSTANCE.createVQLImportSection();
                            ((PatternModel)importSection.eContainer()).setImportPackages(newSection);
                            importSection = newSection;
                        }
                        PatternImport newImport = PatternLanguageFactory.eINSTANCE.createPatternImport();
                        newImport.setPattern(PatternImporter.this.targetPattern);
                        importSection.getPatternImport().add((Object)newImport);
                    }
                });
                cursorOffset += 9 + PatternLanguageHelper.getFullyQualifiedName((Pattern)this.targetPattern).length();
            }
            proposal.setCursorPosition(cursorOffset);
        }
    }

    public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
        if (this.importStatus != ImportState.CONFLICTING) {
            return this.targetPattern.getName();
        }
        return PatternLanguageHelper.getFullyQualifiedName((Pattern)this.targetPattern);
    }

    private static enum ImportState {
        NONE,
        SAMEPACKAGE,
        FOUND,
        CONFLICTING;

    }
}

