/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers.MoveCopyCallback;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.handlers.HandlerUtil;

public class DownloadFilesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        DirectoryDialog dlg = new DirectoryDialog(shell);
        dlg.setFilterPath(this.getFilterPath());
        dlg.setText(Messages.DownloadFilesHandler_folderDlg_text);
        dlg.setMessage(Messages.DownloadFilesHandler_folderDlg_message);
        String destination = dlg.open();
        if (destination == null) {
            return null;
        }
        final File destinationFile = new File(destination);
        this.saveFilterPath(destinationFile);
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List nodes = selection.toList();
        IRuntimeModel peer = ((IFSTreeNode)nodes.get(0)).getRuntimeModel();
        peer.operationDownload(nodes, destinationFile, (IConfirmCallback)new MoveCopyCallback()).runInUserJob((ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                IContainer[] iContainerArray = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(destinationFile.toURI());
                int n = iContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer container = iContainerArray[n2];
                    if (container != null) {
                        try {
                            container.refreshLocal(1, null);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
        });
        return null;
    }

    private String getFilterPath() {
        String lastFolder = UIPlugin.getDefault().getDialogSettings().get(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".lastFolder");
        if (lastFolder != null) {
            return lastFolder;
        }
        Location loc = Platform.getInstanceLocation();
        if (loc != null) {
            URL url = loc.getURL();
            try {
                File file = URIUtil.toFile((URI)url.toURI());
                if (file != null) {
                    return file.getPath();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private void saveFilterPath(File destinationFile) {
        if (destinationFile != null) {
            UIPlugin.getDefault().getDialogSettings().put(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".lastFolder", destinationFile.getPath());
        }
    }
}

