/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tree.tools.internal.menu;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sirius.editor.tree.tools.internal.menu.EClassHierarchy;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tree.description.DescriptionFactory;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemEditionTool;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.description.TreeItemMappingContainer;
import org.eclipse.sirius.tree.description.TreeItemStyleDescription;
import org.eclipse.sirius.tree.description.TreePopupMenu;
import org.eclipse.sirius.viewpoint.description.tool.ChangeContext;
import org.eclipse.sirius.viewpoint.description.tool.ContainerViewVariable;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;
import org.eclipse.sirius.viewpoint.description.tool.ElementDropVariable;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.MenuItemDescription;
import org.eclipse.sirius.viewpoint.description.tool.MenuItemDescriptionReference;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.SetValue;
import org.eclipse.sirius.viewpoint.description.tool.ToolFactory;

class TreeDescriptionBuilderFromEClass {
    private Multimap<EClass, TreeItemMapping> doneClasses;
    private Multimap<EClass, OperationAction> doneItems;
    private EClass rootEClass;
    private TreeDescription treeDesc;
    private EClassHierarchy hiearchy;

    TreeDescriptionBuilderFromEClass(TreeDescription treeDesc, EClass eClassToStartFrom) {
        this.rootEClass = eClassToStartFrom;
        this.treeDesc = treeDesc;
        this.hiearchy = new EClassHierarchy(treeDesc.eResource().getResourceSet());
    }

    public void fillContent() {
        this.doneClasses = HashMultimap.create();
        this.doneItems = HashMultimap.create();
        this.buildMappingRecursively((TreeItemMappingContainer)this.treeDesc, this.rootEClass, "var:self");
    }

    private TreeItemMapping buildMappingRecursively(TreeItemMappingContainer container, EClass eClassToStartFrom, String semanticCandidateExpression2) {
        TreeItemMapping map = DescriptionFactory.eINSTANCE.createTreeItemMapping();
        map.setDomainClass(this.qualifiedName(eClassToStartFrom));
        map.setName(eClassToStartFrom.getName());
        map.setSemanticCandidatesExpression(semanticCandidateExpression2);
        map.setSemanticElements("var:self");
        TreeItemStyleDescription style = DescriptionFactory.eINSTANCE.createTreeItemStyleDescription();
        map.setDefaultStyle(style);
        style.setLabelExpression("feature:name");
        style.setLabelSize(10);
        Option<EAttribute> editableName = this.lookForEditableName(eClassToStartFrom);
        if (editableName.some()) {
            this.handleEditableName(map, editableName);
        }
        this.doneClasses.put((Object)eClassToStartFrom, (Object)map);
        container.getSubItemMappings().add((Object)map);
        TreePopupMenu menu = DescriptionFactory.eINSTANCE.createTreePopupMenu();
        menu.setName("New");
        for (EReference ownedReferences : Iterables.filter((Iterable)eClassToStartFrom.getEAllReferences(), (Predicate)new Predicate<EReference>(){

            public boolean apply(EReference input) {
                return input.isContainment() && input.getEType() instanceof EClass;
            }
        })) {
            EClass targetClass = (EClass)ownedReferences.getEType();
            ArrayList concreteSubclasses = Lists.newArrayList(this.hiearchy.getConcreteSubclassesLeafs(targetClass));
            if (concreteSubclasses.size() > 0) {
                map.getPopupMenus().add((Object)menu);
            }
            for (EClass leaf : concreteSubclasses) {
                String semanticCandidateExpression;
                TreeItemMapping childMap = this.getAlreadyExistingMapping(leaf, semanticCandidateExpression = "feature:" + ownedReferences.getName());
                if (childMap == null) {
                    childMap = this.buildMappingRecursively((TreeItemMappingContainer)map, leaf, semanticCandidateExpression);
                } else {
                    map.getReusedTreeItemMappings().add((Object)childMap);
                }
                Option<OperationAction> createChild = this.getAlreadyExistingMenuItem(leaf, ownedReferences.getName());
                if (createChild.some()) {
                    MenuItemDescriptionReference ref = ToolFactory.eINSTANCE.createMenuItemDescriptionReference();
                    ref.setItem((MenuItemDescription)createChild.get());
                    menu.getMenuItemDescriptions().add((Object)ref);
                    continue;
                }
                OperationAction newMenuItem = ToolFactory.eINSTANCE.createOperationAction();
                newMenuItem.setName(leaf.getName());
                ContainerViewVariable var = ToolFactory.eINSTANCE.createContainerViewVariable();
                var.setName("view");
                newMenuItem.setView(var);
                ChangeContext goToElement = ToolFactory.eINSTANCE.createChangeContext();
                goToElement.setBrowseExpression("feature:target");
                CreateInstance newChild = ToolFactory.eINSTANCE.createCreateInstance();
                newChild.setReferenceName(ownedReferences.getName());
                newChild.setTypeName(this.qualifiedName(leaf));
                goToElement.getSubModelOperations().add((Object)newChild);
                InitialOperation op = ToolFactory.eINSTANCE.createInitialOperation();
                op.setFirstModelOperations((ModelOperation)goToElement);
                newMenuItem.setInitialOperation(op);
                newMenuItem.setForceRefresh(true);
                this.doneItems.put((Object)leaf, (Object)newMenuItem);
                menu.getMenuItemDescriptions().add((Object)newMenuItem);
            }
        }
        return map;
    }

    protected void handleEditableName(TreeItemMapping map, Option<EAttribute> editableName) {
        EAttribute editableFeature = (EAttribute)editableName.get();
        TreeItemEditionTool editTool = DescriptionFactory.eINSTANCE.createTreeItemEditionTool();
        editTool.setName(editableFeature.getName());
        EditMaskVariables maskVar = ToolFactory.eINSTANCE.createEditMaskVariables();
        maskVar.setMask("{0}");
        editTool.setMask(maskVar);
        SetValue setVal = ToolFactory.eINSTANCE.createSetValue();
        setVal.setFeatureName(editableFeature.getName());
        setVal.setValueExpression("var:arg0");
        ElementDropVariable elementVar = ToolFactory.eINSTANCE.createElementDropVariable();
        elementVar.setName("element");
        editTool.setElement(elementVar);
        ElementDropVariable rootVar = ToolFactory.eINSTANCE.createElementDropVariable();
        elementVar.setName("root");
        editTool.setRoot(rootVar);
        editTool.setFirstModelOperation((ModelOperation)setVal);
        map.setDirectEdit(editTool);
    }

    private String qualifiedName(EClass eClassToStartFrom) {
        return eClassToStartFrom.getEPackage().getName() + "." + eClassToStartFrom.getName();
    }

    private TreeItemMapping getAlreadyExistingMapping(EClass leaf, String semanticCandidateExpression) {
        TreeItemMapping found = null;
        Iterator it = this.doneClasses.get((Object)leaf).iterator();
        while (it.hasNext() && found == null) {
            TreeItemMapping cur = (TreeItemMapping)it.next();
            if (!semanticCandidateExpression.equals(cur.getSemanticCandidatesExpression())) continue;
            found = cur;
        }
        return found;
    }

    private Option<OperationAction> getAlreadyExistingMenuItem(EClass leaf, String referenceName) {
        OperationAction found = null;
        Iterator it = this.doneItems.get((Object)leaf).iterator();
        while (it.hasNext() && found == null) {
            OperationAction cur = (OperationAction)it.next();
            UnmodifiableIterator itNewInstance = Iterators.filter((Iterator)cur.eAllContents(), CreateInstance.class);
            while (itNewInstance.hasNext()) {
                CreateInstance newInstance = (CreateInstance)itNewInstance.next();
                if (!referenceName.equals(newInstance.getReferenceName())) continue;
                found = cur;
            }
        }
        return Options.newSome(found);
    }

    private Option<EAttribute> lookForEditableName(EClass eClassToStartFrom) {
        UnmodifiableIterator it = Iterators.filter((Iterator)eClassToStartFrom.getEAllAttributes().iterator(), (Predicate)new Predicate<EAttribute>(){

            public boolean apply(EAttribute input) {
                return "name".equals(input.getName()) && "EString".equals(input.getEType().getName());
            }
        });
        if (it.hasNext()) {
            return Options.newSome((Object)((EAttribute)it.next()));
        }
        return Options.newNone();
    }
}

