/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.classifier;

import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractAllInstancesOperation;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.SetValue;

public class ClassifierAllInstancesOperation
extends AbstractAllInstancesOperation {
    public static final @NonNull ClassifierAllInstancesOperation INSTANCE = new ClassifierAllInstancesOperation();

    public static @NonNull SetValue allInstances(@NonNull Executor executor, @NonNull CollectionTypeId returnTypeId, @NonNull Class type) {
        ModelManager modelManager = executor.getModelManager();
        Iterable<? extends Object> instances = modelManager.getInstances(type);
        HashSet<Object> results = new HashSet<Object>();
        if (instances != null) {
            IdResolver idResolver = executor.getIdResolver();
            for (Object object : instances) {
                results.add(idResolver.boxedValueOf(object));
            }
        }
        return ValueUtil.createSetValue(returnTypeId, results);
    }

    @Override
    public @NonNull SetValue evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceVal) {
        Class type = ClassifierAllInstancesOperation.asClass(sourceVal);
        return type.allInstances(executor, (CollectionTypeId)returnTypeId);
    }
}

