/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.service.MPCOAuthParameters;
import org.eclipse.epp.internal.mpc.core.service.Messages;
import org.eclipse.epp.internal.mpc.core.util.ServiceUtil;
import org.eclipse.epp.mpc.core.service.IMarketplaceStorageService;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.userstorage.IBlob;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.StorageFactory;
import org.eclipse.userstorage.internal.StorageService;
import org.eclipse.userstorage.oauth.EclipseOAuthCredentialsProvider;
import org.eclipse.userstorage.oauth.OAuthParameters;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.spi.ICredentialsProvider;
import org.eclipse.userstorage.spi.ISettings;
import org.eclipse.userstorage.spi.StorageCache;
import org.eclipse.userstorage.util.FileStorageCache;
import org.eclipse.userstorage.util.Settings;
import org.osgi.framework.BundleContext;

public class MarketplaceStorageService
implements IMarketplaceStorageService {
    private static final String DEFAULT_STORAGE_SERVICE_NAME = Messages.MarketplaceStorageService_defaultStorageServiceName;
    static final String DEFAULT_APPLICATION_TOKEN = "MZ04RMOpksKN5GpxKXafq2MSjSP";
    private static final String[] MIGRATE_SECURE_STORAGE_KEYS = new String[]{"username", "password", "termsOfUseAgreed"};
    private String applicationToken = "MZ04RMOpksKN5GpxKXafq2MSjSP";
    private URI serviceUri;
    private String marketplaceBaseUri;
    private StorageFactory storageFactory;
    private IStorage storage;
    private IStorageService.Dynamic customStorageService;
    private List<IMarketplaceStorageService.LoginListener> loginListeners;
    private EclipseOAuthCredentialsProvider credentialsProvider;

    @Override
    public String getMarketplaceBaseUri() {
        return this.marketplaceBaseUri;
    }

    public void setMarketplaceBaseUri(String marketplaceBaseUri) {
        this.marketplaceBaseUri = marketplaceBaseUri;
    }

    @Override
    public URI getServiceUri() {
        return this.serviceUri;
    }

    public synchronized void setServiceUri(URI serviceUri) {
        if (this.serviceUri == null && serviceUri != null || this.serviceUri != null && !this.serviceUri.equals(serviceUri)) {
            this.serviceUri = serviceUri;
            this.storageFactory = null;
            this.storage = null;
        }
    }

    @Override
    public synchronized StorageFactory getStorageFactory() {
        if (this.storageFactory == null) {
            this.storageFactory = this.createStorageFactory();
        }
        return this.storageFactory;
    }

    public synchronized void setStorageFactory(StorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    protected StorageFactory createStorageFactory() {
        if (this.serviceUri == null) {
            return StorageFactory.DEFAULT;
        }
        HashMap<String, String> settingsMap = new HashMap<String, String>();
        settingsMap.put(this.applicationToken, this.serviceUri.toString());
        Settings.MemorySettings storageFactorySettings = new Settings.MemorySettings(settingsMap);
        return new StorageFactory((ISettings)storageFactorySettings);
    }

    protected IStorage createStorage() {
        MarketplaceStorageService.ensureTmpdirExists();
        IStorage storage = this.getStorageFactory().create(this.applicationToken, (StorageCache)new FileStorageCache.SingleApplication(this.applicationToken));
        this.credentialsProvider = new EclipseOAuthCredentialsProvider((OAuthParameters)new MPCOAuthParameters());
        this.credentialsProvider.setInteractive(false);
        storage.setCredentialsProvider((ICredentialsProvider)this.credentialsProvider);
        return storage;
    }

    private static void ensureTmpdirExists() {
        try {
            File tmpDir;
            String tmpdirProperty = System.getProperty("java.io.tmpdir");
            if (tmpdirProperty != null && !(tmpDir = new File(tmpdirProperty)).exists()) {
                tmpDir.mkdirs();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized IStorage getStorage() {
        if (this.storage == null) {
            this.storage = this.createStorage();
        }
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    @Override
    public IBlob getBlob(String key) {
        return this.getStorage().getBlob(key);
    }

    @Override
    public String getRegisteredUser() {
        Credentials credentials = this.getStorageCredentials();
        return credentials == null ? null : credentials.getUsername();
    }

    @Override
    public <T> T runWithLogin(Callable<T> c) throws Exception {
        String oldUser = this.getCurrentUser();
        boolean wasInteractive = this.credentialsProvider.isInteractive();
        this.credentialsProvider.setInteractive(true);
        try {
            T result;
            T t = result = c.call();
            return t;
        }
        finally {
            this.credentialsProvider.setInteractive(wasInteractive);
            String newUser = this.getCurrentUser();
            this.notifyLoginChanged(oldUser, newUser);
        }
    }

    private void notifyLoginChanged(String oldUser, String newUser) {
        List<IMarketplaceStorageService.LoginListener> loginListeners;
        if ((newUser == null && oldUser != null || newUser != null && !newUser.equals(oldUser)) && (loginListeners = this.loginListeners) != null && !loginListeners.isEmpty()) {
            for (IMarketplaceStorageService.LoginListener loginListener : loginListeners) {
                loginListener.loginChanged(oldUser, newUser);
            }
        }
    }

    @Override
    public synchronized void addLoginListener(IMarketplaceStorageService.LoginListener listener) {
        if (this.loginListeners == null) {
            this.loginListeners = new CopyOnWriteArrayList<IMarketplaceStorageService.LoginListener>();
        }
        if (!this.loginListeners.contains(listener)) {
            this.loginListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeLoginListener(IMarketplaceStorageService.LoginListener listener) {
        if (this.loginListeners != null) {
            this.loginListeners.remove(listener);
        }
    }

    private String getCurrentUser() {
        Credentials credentials = this.getStorageCredentials();
        if (credentials != null && credentials.getPassword() != null) {
            return credentials.getUsername();
        }
        return null;
    }

    private Credentials getStorageCredentials() {
        ICredentialsProvider provider = this.getStorage().getCredentialsProvider();
        if (provider == null) {
            return null;
        }
        IStorageService service = this.getStorage().getService();
        return provider.hasCredentials(service) ? provider.getCredentials(service) : null;
    }

    public void activate(BundleContext context, Map<?, ?> properties) {
        String applicationToken;
        Object serviceUrlValue = ServiceUtil.getOverridablePropertyValue(properties, "serviceUrl");
        if (serviceUrlValue != null) {
            URI serviceUri = URI.create(serviceUrlValue.toString());
            String serviceName = MarketplaceStorageService.getProperty(properties, "serviceName", DEFAULT_STORAGE_SERVICE_NAME);
            IStorageService registered = this.registerStorageService(serviceUri, serviceName);
            this.setServiceUri(registered.getServiceURI());
        }
        this.applicationToken = applicationToken = MarketplaceStorageService.getProperty(properties, "applicationToken", DEFAULT_APPLICATION_TOKEN);
        Object marketplaceBaseUri = ServiceUtil.getOverridablePropertyValue(properties, "url");
        if (marketplaceBaseUri != null) {
            this.marketplaceBaseUri = marketplaceBaseUri.toString();
        }
        this.getStorage();
    }

    private IStorageService registerStorageService(URI serviceUri, String serviceName) {
        this.customStorageService = null;
        URI normalizedUri = MarketplaceStorageService.normalizePath(serviceUri);
        URI denormalizedUri = MarketplaceStorageService.normalizePath(serviceUri, false);
        IStorageService service = IStorageService.Registry.INSTANCE.getService(normalizedUri);
        IStorageService extraService = IStorageService.Registry.INSTANCE.getService(denormalizedUri);
        if (service == null) {
            if (extraService != null) {
                return extraService;
            }
            this.customStorageService = IStorageService.Registry.INSTANCE.addService(serviceName, normalizedUri);
            service = this.customStorageService;
            return service;
        }
        if (extraService != null && extraService != service) {
            service = MarketplaceStorageService.cleanupExtraStorageService(service, extraService);
        }
        return service;
    }

    private static IStorageService cleanupExtraStorageService(IStorageService service, IStorageService extraService) {
        IStorageService keepService;
        IStorageService.Dynamic removeDynamic;
        if (extraService instanceof IStorageService.Dynamic) {
            removeDynamic = (IStorageService.Dynamic)extraService;
            keepService = service;
        } else if (service instanceof IStorageService.Dynamic) {
            removeDynamic = (IStorageService.Dynamic)service;
            keepService = extraService;
        } else {
            return service;
        }
        if (removeDynamic instanceof StorageService && keepService instanceof StorageService) {
            StorageService removeImpl = (StorageService)removeDynamic;
            StorageService keepImpl = (StorageService)keepService;
            ISecurePreferences removeSecurePreferences = removeImpl.getSecurePreferences();
            ISecurePreferences keepSecurePreferences = keepImpl.getSecurePreferences();
            try {
                MarketplaceStorageService.copySecurePreferences(removeSecurePreferences, keepSecurePreferences);
            }
            catch (Exception e) {
                MarketplaceClientCore.error(NLS.bind((String)"Failed to migrate secure storage values from {0} to {1}", (Object)removeDynamic.getServiceURI(), (Object)keepService.getServiceURI()), e);
            }
        }
        removeDynamic.remove();
        return keepService;
    }

    private static void copySecurePreferences(ISecurePreferences source, ISecurePreferences target) throws StorageException, IOException {
        HashSet<String> sourceKeys = new HashSet<String>(Arrays.asList(source.keys()));
        HashSet<String> targetKeys = new HashSet<String>(Arrays.asList(target.keys()));
        boolean changed = false;
        String[] stringArray = MIGRATE_SECURE_STORAGE_KEYS;
        int n = MIGRATE_SECURE_STORAGE_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (sourceKeys.contains(key) && !targetKeys.contains(key)) {
                boolean encrypted = source.isEncrypted(key);
                target.put(key, source.get(key, null), encrypted);
                changed = true;
            }
            ++n2;
        }
        if (changed) {
            target.flush();
        }
    }

    private static URI normalizePath(URI uri) {
        return MarketplaceStorageService.normalizePath(uri, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static URI normalizePath(URI uri, boolean trailingSlash) {
        Object normalizedPath;
        if (uri.isOpaque()) {
            return uri;
        }
        String path = uri.getPath();
        if (path == null) {
            if (!trailingSlash) return uri;
            normalizedPath = "/";
        } else if (path.endsWith("/")) {
            if (trailingSlash) {
                return uri;
            }
            normalizedPath = path.length() == 1 ? null : path.substring(0, path.length() - 1);
        } else {
            if (!trailingSlash) return uri;
            normalizedPath = path + "/";
        }
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), (String)normalizedPath, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            return uri;
        }
    }

    private static String getProperty(Map<?, ?> properties, String key, String defaultValue) {
        Object value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public void deactivate() {
        if (this.customStorageService != null) {
            this.customStorageService.remove();
        }
        this.customStorageService = null;
    }
}

