/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.impl;

import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.Commentable;
import org.eclipse.emf.cdo.lm.reviews.Heading;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.impl.CommentImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.StringUtil;

public class HeadingImpl
extends CommentImpl
implements Heading {
    protected static final int PARENT_INDEX_EDEFAULT = 0;
    protected static final String OUTLINE_NUMBER_EDEFAULT = null;

    protected HeadingImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.HEADING;
    }

    @Override
    public Heading getPreviousHeading() {
        Commentable commentable = this.getCommentable();
        if (commentable == null) {
            return null;
        }
        EList<Comment> parentComments = commentable.getComments();
        int index = parentComments.indexOf((Object)this);
        if (index == -1) {
            return null;
        }
        int i = index - 1;
        while (i >= 0) {
            Comment comment = (Comment)parentComments.get(i);
            if (comment instanceof Heading) {
                return (Heading)comment;
            }
            --i;
        }
        return null;
    }

    @Override
    public Heading getNextHeading() {
        Commentable commentable = this.getCommentable();
        if (commentable == null) {
            return null;
        }
        EList<Comment> parentComments = commentable.getComments();
        int index = parentComments.indexOf((Object)this);
        if (index == -1) {
            return null;
        }
        int i = index + 1;
        int size = parentComments.size();
        while (i < size) {
            Comment comment = (Comment)parentComments.get(i);
            if (comment instanceof Heading) {
                return (Heading)comment;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getParentIndex() {
        Commentable commentable = this.getCommentable();
        if (commentable == null) {
            return 1;
        }
        EList<Comment> parentComments = commentable.getComments();
        int index = parentComments.indexOf((Object)this);
        if (index == -1) {
            return 1;
        }
        int count = 1;
        int i = 0;
        while (i < index) {
            Comment comment = (Comment)parentComments.get(i);
            if (comment instanceof Heading) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public String getOutlineNumber() {
        StringBuilder builder = new StringBuilder();
        HeadingImpl.formatOutlineNumber(builder, this);
        return builder.toString();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getPreviousHeading();
            }
            case 12: {
                return this.getNextHeading();
            }
            case 13: {
                return this.getParentIndex();
            }
            case 14: {
                return this.getOutlineNumber();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.getPreviousHeading() != null;
            }
            case 12: {
                return this.getNextHeading() != null;
            }
            case 13: {
                return this.getParentIndex() != 0;
            }
            case 14: {
                return OUTLINE_NUMBER_EDEFAULT == null ? this.getOutlineNumber() != null : !OUTLINE_NUMBER_EDEFAULT.equals(this.getOutlineNumber());
            }
        }
        return super.eIsSet(featureID);
    }

    private static void formatOutlineNumber(StringBuilder builder, Heading heading) {
        Heading parentHeading = heading.getParentHeading();
        if (parentHeading != null) {
            HeadingImpl.formatOutlineNumber(builder, parentHeading);
        }
        StringUtil.appendSeparator((StringBuilder)builder, (char)'.');
        builder.append(heading.getParentIndex());
    }
}

