/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.wsdd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.model.ecore.resource.Resource;
import org.apache.axis.model.ecore.xmi.util.XMLProcessor;
import org.apache.axis.model.util.AxisXMLResource;
import org.apache.axis.model.wsdd.Deployment;
import org.apache.axis.model.wsdd.WSDDExtendedMetaData;
import org.apache.axis.model.wsdd.impl.WSDDPackageImpl;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;

public final class WSDDUtil {
    private static final Log log = LogFactory.getLog(WSDDUtil.class.getName());

    private WSDDUtil() {
    }

    public static Deployment load(InputSource is) throws IOException {
        WSDDPackageImpl.eINSTANCE.eClass();
        AxisXMLResource resource = new AxisXMLResource();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("EXTENDED_META_DATA", new WSDDExtendedMetaData());
        options.put("IGNORE_NAMESPACE_FOR_UNQUALIFIED_QNAME", "http://xml.apache.org/axis/wsdd/");
        resource.load(is, options);
        return (Deployment)resource.getContents().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Deployment buildDefaultConfiguration(ClassLoader cl, String type) throws IOException {
        Deployment deployment;
        String resourceName = "org/apache/axis/" + type + "/" + type + "-config.wsdd";
        InputStream in = cl.getResourceAsStream(resourceName);
        if (in == null) {
            throw new IOException("Resource " + resourceName + " not found");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading resource " + resourceName));
        }
        try {
            deployment = WSDDUtil.load(new InputSource(in));
        }
        finally {
            in.close();
        }
        resourceName = "META-INF/axis/default-" + type + "-config.wsdd";
        Enumeration<URL> resources = cl.getResources(resourceName);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading " + url));
            }
            in = url.openStream();
            try {
                deployment.merge(WSDDUtil.load(new InputSource(in)));
            }
            finally {
                in.close();
            }
        }
        return deployment;
    }

    public static void save(Deployment deployment, OutputStream out) throws IOException {
        AxisXMLResource resource = new AxisXMLResource();
        XMLProcessor processor = new XMLProcessor();
        resource.getContents().add(deployment);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        processor.save(out, (Resource)resource, options);
    }

    public static void save(Deployment deployment, Writer writer) throws IOException {
        AxisXMLResource resource = new AxisXMLResource();
        XMLProcessor processor = new XMLProcessor();
        resource.getContents().add(deployment);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("DECLARE_XML", Boolean.FALSE);
        processor.save(writer, (Resource)resource, options);
    }
}

