/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.EndpointConfig;

final class ImmutableEndpointConfig
implements EndpointConfig {
    @Nullable
    private final EndpointConfig.EndpointIpamConfig ipamConfig;
    @Nullable
    private final List<String> links;
    @Nullable
    private final List<String> aliases;
    @Nullable
    private final String gateway;
    @Nullable
    private final String ipAddress;
    @Nullable
    private final Integer ipPrefixLen;
    @Nullable
    private final String ipv6Gateway;
    @Nullable
    private final String globalIPv6Address;
    @Nullable
    private final Integer globalIPv6PrefixLen;
    @Nullable
    private final String macAddress;

    private ImmutableEndpointConfig(@Nullable EndpointConfig.EndpointIpamConfig ipamConfig, @Nullable List<String> links, @Nullable List<String> aliases, @Nullable String gateway, @Nullable String ipAddress, @Nullable Integer ipPrefixLen, @Nullable String ipv6Gateway, @Nullable String globalIPv6Address, @Nullable Integer globalIPv6PrefixLen, @Nullable String macAddress) {
        this.ipamConfig = ipamConfig;
        this.links = links;
        this.aliases = aliases;
        this.gateway = gateway;
        this.ipAddress = ipAddress;
        this.ipPrefixLen = ipPrefixLen;
        this.ipv6Gateway = ipv6Gateway;
        this.globalIPv6Address = globalIPv6Address;
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
        this.macAddress = macAddress;
    }

    @Override
    @JsonProperty(value="IPAMConfig")
    @Nullable
    public EndpointConfig.EndpointIpamConfig ipamConfig() {
        return this.ipamConfig;
    }

    @Override
    @JsonProperty(value="Links")
    @Nullable
    public List<String> links() {
        return this.links;
    }

    @Override
    @JsonProperty(value="Aliases")
    @Nullable
    public List<String> aliases() {
        return this.aliases;
    }

    @Override
    @JsonProperty(value="Gateway")
    @Nullable
    public String gateway() {
        return this.gateway;
    }

    @Override
    @JsonProperty(value="IPAddress")
    @Nullable
    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    @JsonProperty(value="IPPrefixLen")
    @Nullable
    public Integer ipPrefixLen() {
        return this.ipPrefixLen;
    }

    @Override
    @JsonProperty(value="IPv6Gateway")
    @Nullable
    public String ipv6Gateway() {
        return this.ipv6Gateway;
    }

    @Override
    @JsonProperty(value="GlobalIPv6Address")
    @Nullable
    public String globalIPv6Address() {
        return this.globalIPv6Address;
    }

    @Override
    @JsonProperty(value="GlobalIPv6PrefixLen")
    @Nullable
    public Integer globalIPv6PrefixLen() {
        return this.globalIPv6PrefixLen;
    }

    @Override
    @JsonProperty(value="MacAddress")
    @Nullable
    public String macAddress() {
        return this.macAddress;
    }

    public final ImmutableEndpointConfig withIpamConfig(@Nullable EndpointConfig.EndpointIpamConfig value) {
        if (this.ipamConfig == value) {
            return this;
        }
        return new ImmutableEndpointConfig(value, this.links, this.aliases, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableEndpointConfig withLinks(String ... elements) {
        if (elements == null) {
            return new ImmutableEndpointConfig(this.ipamConfig, null, this.aliases, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableEndpointConfig.createUnmodifiableList(false, ImmutableEndpointConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEndpointConfig(this.ipamConfig, newValue, this.aliases, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableEndpointConfig withLinks(@Nullable Iterable<String> elements) {
        if (this.links == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableEndpointConfig.createUnmodifiableList(false, ImmutableEndpointConfig.createSafeList(elements, true, false));
        return new ImmutableEndpointConfig(this.ipamConfig, newValue, this.aliases, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableEndpointConfig withAliases(String ... elements) {
        if (elements == null) {
            return new ImmutableEndpointConfig(this.ipamConfig, this.links, null, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableEndpointConfig.createUnmodifiableList(false, ImmutableEndpointConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEndpointConfig(this.ipamConfig, this.links, newValue, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableEndpointConfig withAliases(@Nullable Iterable<String> elements) {
        if (this.aliases == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableEndpointConfig.createUnmodifiableList(false, ImmutableEndpointConfig.createSafeList(elements, true, false));
        return new ImmutableEndpointConfig(this.ipamConfig, this.links, newValue, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableEndpointConfig withGateway(@Nullable String value) {
        if (Objects.equals(this.gateway, value)) {
            return this;
        }
        return new ImmutableEndpointConfig(this.ipamConfig, this.links, this.aliases, value, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableEndpointConfig withIpAddress(@Nullable String value) {
        if (Objects.equals(this.ipAddress, value)) {
            return this;
        }
        return new ImmutableEndpointConfig(this.ipamConfig, this.links, this.aliases, this.gateway, value, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableEndpointConfig withIpPrefixLen(@Nullable Integer value) {
        if (Objects.equals(this.ipPrefixLen, value)) {
            return this;
        }
        return new ImmutableEndpointConfig(this.ipamConfig, this.links, this.aliases, this.gateway, this.ipAddress, value, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableEndpointConfig withIpv6Gateway(@Nullable String value) {
        if (Objects.equals(this.ipv6Gateway, value)) {
            return this;
        }
        return new ImmutableEndpointConfig(this.ipamConfig, this.links, this.aliases, this.gateway, this.ipAddress, this.ipPrefixLen, value, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableEndpointConfig withGlobalIPv6Address(@Nullable String value) {
        if (Objects.equals(this.globalIPv6Address, value)) {
            return this;
        }
        return new ImmutableEndpointConfig(this.ipamConfig, this.links, this.aliases, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, value, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableEndpointConfig withGlobalIPv6PrefixLen(@Nullable Integer value) {
        if (Objects.equals(this.globalIPv6PrefixLen, value)) {
            return this;
        }
        return new ImmutableEndpointConfig(this.ipamConfig, this.links, this.aliases, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, value, this.macAddress);
    }

    public final ImmutableEndpointConfig withMacAddress(@Nullable String value) {
        if (Objects.equals(this.macAddress, value)) {
            return this;
        }
        return new ImmutableEndpointConfig(this.ipamConfig, this.links, this.aliases, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEndpointConfig && this.equalTo(0, (ImmutableEndpointConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableEndpointConfig another) {
        return Objects.equals(this.ipamConfig, another.ipamConfig) && Objects.equals(this.links, another.links) && Objects.equals(this.aliases, another.aliases) && Objects.equals(this.gateway, another.gateway) && Objects.equals(this.ipAddress, another.ipAddress) && Objects.equals(this.ipPrefixLen, another.ipPrefixLen) && Objects.equals(this.ipv6Gateway, another.ipv6Gateway) && Objects.equals(this.globalIPv6Address, another.globalIPv6Address) && Objects.equals(this.globalIPv6PrefixLen, another.globalIPv6PrefixLen) && Objects.equals(this.macAddress, another.macAddress);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ipamConfig);
        h += (h << 5) + Objects.hashCode(this.links);
        h += (h << 5) + Objects.hashCode(this.aliases);
        h += (h << 5) + Objects.hashCode(this.gateway);
        h += (h << 5) + Objects.hashCode(this.ipAddress);
        h += (h << 5) + Objects.hashCode(this.ipPrefixLen);
        h += (h << 5) + Objects.hashCode(this.ipv6Gateway);
        h += (h << 5) + Objects.hashCode(this.globalIPv6Address);
        h += (h << 5) + Objects.hashCode(this.globalIPv6PrefixLen);
        h += (h << 5) + Objects.hashCode(this.macAddress);
        return h;
    }

    public String toString() {
        return "EndpointConfig{ipamConfig=" + this.ipamConfig + ", links=" + this.links + ", aliases=" + this.aliases + ", gateway=" + this.gateway + ", ipAddress=" + this.ipAddress + ", ipPrefixLen=" + this.ipPrefixLen + ", ipv6Gateway=" + this.ipv6Gateway + ", globalIPv6Address=" + this.globalIPv6Address + ", globalIPv6PrefixLen=" + this.globalIPv6PrefixLen + ", macAddress=" + this.macAddress + "}";
    }

    public static ImmutableEndpointConfig copyOf(EndpointConfig instance) {
        if (instance instanceof ImmutableEndpointConfig) {
            return (ImmutableEndpointConfig)instance;
        }
        return ImmutableEndpointConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements EndpointConfig.Builder {
        private EndpointConfig.EndpointIpamConfig ipamConfig;
        private List<String> links = null;
        private List<String> aliases = null;
        private String gateway;
        private String ipAddress;
        private Integer ipPrefixLen;
        private String ipv6Gateway;
        private String globalIPv6Address;
        private Integer globalIPv6PrefixLen;
        private String macAddress;

        private Builder() {
        }

        public final Builder from(EndpointConfig instance) {
            String macAddressValue;
            Integer globalIPv6PrefixLenValue;
            String globalIPv6AddressValue;
            String ipv6GatewayValue;
            Integer ipPrefixLenValue;
            String ipAddressValue;
            String gatewayValue;
            List<String> aliasesValue;
            List<String> linksValue;
            Objects.requireNonNull(instance, "instance");
            EndpointConfig.EndpointIpamConfig ipamConfigValue = instance.ipamConfig();
            if (ipamConfigValue != null) {
                this.ipamConfig(ipamConfigValue);
            }
            if ((linksValue = instance.links()) != null) {
                this.addAllLinks(linksValue);
            }
            if ((aliasesValue = instance.aliases()) != null) {
                this.addAllAliases(aliasesValue);
            }
            if ((gatewayValue = instance.gateway()) != null) {
                this.gateway(gatewayValue);
            }
            if ((ipAddressValue = instance.ipAddress()) != null) {
                this.ipAddress(ipAddressValue);
            }
            if ((ipPrefixLenValue = instance.ipPrefixLen()) != null) {
                this.ipPrefixLen(ipPrefixLenValue);
            }
            if ((ipv6GatewayValue = instance.ipv6Gateway()) != null) {
                this.ipv6Gateway(ipv6GatewayValue);
            }
            if ((globalIPv6AddressValue = instance.globalIPv6Address()) != null) {
                this.globalIPv6Address(globalIPv6AddressValue);
            }
            if ((globalIPv6PrefixLenValue = instance.globalIPv6PrefixLen()) != null) {
                this.globalIPv6PrefixLen(globalIPv6PrefixLenValue);
            }
            if ((macAddressValue = instance.macAddress()) != null) {
                this.macAddress(macAddressValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="IPAMConfig")
        public final Builder ipamConfig(@Nullable EndpointConfig.EndpointIpamConfig ipamConfig) {
            this.ipamConfig = ipamConfig;
            return this;
        }

        public final Builder link(String element) {
            if (this.links == null) {
                this.links = new ArrayList<String>();
            }
            this.links.add(Objects.requireNonNull(element, "links element"));
            return this;
        }

        public final Builder links(String ... elements) {
            if (this.links == null) {
                this.links = new ArrayList<String>();
            }
            for (String element : elements) {
                this.links.add(Objects.requireNonNull(element, "links element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Links")
        public final Builder links(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.links = null;
                return this;
            }
            this.links = new ArrayList<String>();
            return this.addAllLinks(elements);
        }

        public final Builder addAllLinks(Iterable<String> elements) {
            Objects.requireNonNull(elements, "links element");
            if (this.links == null) {
                this.links = new ArrayList<String>();
            }
            for (String element : elements) {
                this.links.add(Objects.requireNonNull(element, "links element"));
            }
            return this;
        }

        public final Builder aliase(String element) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            this.aliases.add(Objects.requireNonNull(element, "aliases element"));
            return this;
        }

        public final Builder aliases(String ... elements) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            for (String element : elements) {
                this.aliases.add(Objects.requireNonNull(element, "aliases element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Aliases")
        public final Builder aliases(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.aliases = null;
                return this;
            }
            this.aliases = new ArrayList<String>();
            return this.addAllAliases(elements);
        }

        public final Builder addAllAliases(Iterable<String> elements) {
            Objects.requireNonNull(elements, "aliases element");
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            for (String element : elements) {
                this.aliases.add(Objects.requireNonNull(element, "aliases element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Gateway")
        public final Builder gateway(@Nullable String gateway) {
            this.gateway = gateway;
            return this;
        }

        @Override
        @JsonProperty(value="IPAddress")
        public final Builder ipAddress(@Nullable String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @Override
        @JsonProperty(value="IPPrefixLen")
        public final Builder ipPrefixLen(@Nullable Integer ipPrefixLen) {
            this.ipPrefixLen = ipPrefixLen;
            return this;
        }

        @Override
        @JsonProperty(value="IPv6Gateway")
        public final Builder ipv6Gateway(@Nullable String ipv6Gateway) {
            this.ipv6Gateway = ipv6Gateway;
            return this;
        }

        @Override
        @JsonProperty(value="GlobalIPv6Address")
        public final Builder globalIPv6Address(@Nullable String globalIPv6Address) {
            this.globalIPv6Address = globalIPv6Address;
            return this;
        }

        @Override
        @JsonProperty(value="GlobalIPv6PrefixLen")
        public final Builder globalIPv6PrefixLen(@Nullable Integer globalIPv6PrefixLen) {
            this.globalIPv6PrefixLen = globalIPv6PrefixLen;
            return this;
        }

        @Override
        @JsonProperty(value="MacAddress")
        public final Builder macAddress(@Nullable String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        @Override
        public ImmutableEndpointConfig build() {
            return new ImmutableEndpointConfig(this.ipamConfig, this.links == null ? null : ImmutableEndpointConfig.createUnmodifiableList(true, this.links), this.aliases == null ? null : ImmutableEndpointConfig.createUnmodifiableList(true, this.aliases), this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
        }
    }

    static final class EndpointIpamConfig
    implements EndpointConfig.EndpointIpamConfig {
        @Nullable
        private final String ipv4Address;
        @Nullable
        private final String ipv6Address;
        @Nullable
        private final List<String> linkLocalIPs;

        private EndpointIpamConfig(@Nullable String ipv4Address, @Nullable String ipv6Address, @Nullable List<String> linkLocalIPs) {
            this.ipv4Address = ipv4Address;
            this.ipv6Address = ipv6Address;
            this.linkLocalIPs = linkLocalIPs;
        }

        @Override
        @JsonProperty(value="IPv4Address")
        @Nullable
        public String ipv4Address() {
            return this.ipv4Address;
        }

        @Override
        @JsonProperty(value="IPv6Address")
        @Nullable
        public String ipv6Address() {
            return this.ipv6Address;
        }

        @Override
        @JsonProperty(value="LinkLocalIPs")
        @Nullable
        public List<String> linkLocalIPs() {
            return this.linkLocalIPs;
        }

        public final EndpointIpamConfig withIpv4Address(@Nullable String value) {
            if (Objects.equals(this.ipv4Address, value)) {
                return this;
            }
            return new EndpointIpamConfig(value, this.ipv6Address, this.linkLocalIPs);
        }

        public final EndpointIpamConfig withIpv6Address(@Nullable String value) {
            if (Objects.equals(this.ipv6Address, value)) {
                return this;
            }
            return new EndpointIpamConfig(this.ipv4Address, value, this.linkLocalIPs);
        }

        public final EndpointIpamConfig withLinkLocalIPs(String ... elements) {
            if (elements == null) {
                return new EndpointIpamConfig(this.ipv4Address, this.ipv6Address, null);
            }
            List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableEndpointConfig.createUnmodifiableList(false, ImmutableEndpointConfig.createSafeList(Arrays.asList(elements), true, false));
            return new EndpointIpamConfig(this.ipv4Address, this.ipv6Address, newValue);
        }

        public final EndpointIpamConfig withLinkLocalIPs(@Nullable Iterable<String> elements) {
            if (this.linkLocalIPs == elements) {
                return this;
            }
            List<String> newValue = elements == null ? null : ImmutableEndpointConfig.createUnmodifiableList(false, ImmutableEndpointConfig.createSafeList(elements, true, false));
            return new EndpointIpamConfig(this.ipv4Address, this.ipv6Address, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof EndpointIpamConfig && this.equalTo(0, (EndpointIpamConfig)another);
        }

        private boolean equalTo(int synthetic, EndpointIpamConfig another) {
            return Objects.equals(this.ipv4Address, another.ipv4Address) && Objects.equals(this.ipv6Address, another.ipv6Address) && Objects.equals(this.linkLocalIPs, another.linkLocalIPs);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.ipv4Address);
            h += (h << 5) + Objects.hashCode(this.ipv6Address);
            h += (h << 5) + Objects.hashCode(this.linkLocalIPs);
            return h;
        }

        public String toString() {
            return "EndpointIpamConfig{ipv4Address=" + this.ipv4Address + ", ipv6Address=" + this.ipv6Address + ", linkLocalIPs=" + this.linkLocalIPs + "}";
        }

        public static EndpointIpamConfig copyOf(EndpointConfig.EndpointIpamConfig instance) {
            if (instance instanceof EndpointIpamConfig) {
                return (EndpointIpamConfig)instance;
            }
            return EndpointIpamConfig.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements EndpointConfig.EndpointIpamConfig.Builder {
            private String ipv4Address;
            private String ipv6Address;
            private List<String> linkLocalIPs = null;

            private Builder() {
            }

            public final Builder from(EndpointConfig.EndpointIpamConfig instance) {
                List<String> linkLocalIPsValue;
                String ipv6AddressValue;
                Objects.requireNonNull(instance, "instance");
                String ipv4AddressValue = instance.ipv4Address();
                if (ipv4AddressValue != null) {
                    this.ipv4Address(ipv4AddressValue);
                }
                if ((ipv6AddressValue = instance.ipv6Address()) != null) {
                    this.ipv6Address(ipv6AddressValue);
                }
                if ((linkLocalIPsValue = instance.linkLocalIPs()) != null) {
                    this.addAllLinkLocalIPs(linkLocalIPsValue);
                }
                return this;
            }

            @Override
            @JsonProperty(value="IPv4Address")
            public final Builder ipv4Address(@Nullable String ipv4Address) {
                this.ipv4Address = ipv4Address;
                return this;
            }

            @Override
            @JsonProperty(value="IPv6Address")
            public final Builder ipv6Address(@Nullable String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            public final Builder linkLocalIP(String element) {
                if (this.linkLocalIPs == null) {
                    this.linkLocalIPs = new ArrayList<String>();
                }
                this.linkLocalIPs.add(Objects.requireNonNull(element, "linkLocalIPs element"));
                return this;
            }

            public final Builder linkLocalIPs(String ... elements) {
                if (this.linkLocalIPs == null) {
                    this.linkLocalIPs = new ArrayList<String>();
                }
                for (String element : elements) {
                    this.linkLocalIPs.add(Objects.requireNonNull(element, "linkLocalIPs element"));
                }
                return this;
            }

            @Override
            @JsonProperty(value="LinkLocalIPs")
            public final Builder linkLocalIPs(@Nullable Iterable<String> elements) {
                if (elements == null) {
                    this.linkLocalIPs = null;
                    return this;
                }
                this.linkLocalIPs = new ArrayList<String>();
                return this.addAllLinkLocalIPs(elements);
            }

            public final Builder addAllLinkLocalIPs(Iterable<String> elements) {
                Objects.requireNonNull(elements, "linkLocalIPs element");
                if (this.linkLocalIPs == null) {
                    this.linkLocalIPs = new ArrayList<String>();
                }
                for (String element : elements) {
                    this.linkLocalIPs.add(Objects.requireNonNull(element, "linkLocalIPs element"));
                }
                return this;
            }

            @Override
            public EndpointIpamConfig build() {
                return new EndpointIpamConfig(this.ipv4Address, this.ipv6Address, this.linkLocalIPs == null ? null : ImmutableEndpointConfig.createUnmodifiableList(true, this.linkLocalIPs));
            }
        }
    }
}

