/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class HorizontalShift
extends AbstractLayoutAlgorithm {
    private static final double DELTA = 10.0;
    private static final double VSPACING = 2.0;

    public HorizontalShift(int styles) {
        super(styles);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        void var13_13;
        ArrayList<List<InternalNode>> row = new ArrayList<List<InternalNode>>();
        InternalNode[] internalNodeArray = entitiesToLayout;
        int n = entitiesToLayout.length;
        boolean n2 = false;
        while (var13_13 < n) {
            InternalNode element = internalNodeArray[var13_13];
            HorizontalShift.addToRowList(element, row);
            ++var13_13;
        }
        int heightSoFar = 0;
        Collections.sort(row, (arg0, arg1) -> {
            LayoutEntity node0 = ((InternalNode)arg0.get(0)).getLayoutEntity();
            LayoutEntity node1 = ((InternalNode)arg1.get(0)).getLayoutEntity();
            return (int)(node0.getYInLayout() - node1.getYInLayout());
        });
        for (List list : row) {
            Collections.sort(list, (arg0, arg1) -> (int)(arg1.getLayoutEntity().getYInLayout() - arg0.getLayoutEntity().getYInLayout()));
            int i = 0;
            int width = (int)(boundsWidth / 2.0 - (double)(list.size() * 75));
            heightSoFar = (int)((double)heightSoFar + (((InternalNode)list.get(0)).getLayoutEntity().getHeightInLayout() + 16.0));
            for (InternalNode currentNode : list) {
                double location = width + 10 * ++i;
                currentNode.setLocation(location, heightSoFar);
                width = (int)((double)width + currentNode.getLayoutEntity().getWidthInLayout());
            }
        }
    }

    private static void addToRowList(InternalNode node, List<List<InternalNode>> list) {
        double layoutY = node.getLayoutEntity().getYInLayout();
        for (List<InternalNode> currentRow : list) {
            InternalNode currentRowNode = currentRow.get(0);
            double currentRowY = currentRowNode.getLayoutEntity().getYInLayout();
            if (!(layoutY >= currentRowY - 10.0) || !(layoutY <= currentRowY + 10.0)) continue;
            currentRow.add(node);
            return;
        }
        ArrayList<InternalNode> newRow = new ArrayList<InternalNode>();
        newRow.add(node);
        list.add(newRow);
    }

    @Override
    protected int getCurrentLayoutStep() {
        return 0;
    }

    @Override
    protected int getTotalNumberOfLayoutSteps() {
        return 0;
    }

    @Override
    protected boolean isValidConfiguration(boolean asynchronous, boolean continuous) {
        return true;
    }

    @Override
    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
    }

    @Override
    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
    }

    @Override
    public void setLayoutArea(double x, double y, double width, double height) {
    }
}

