/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.templates;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.text.templates.TemplateReaderWriter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

@Singleton
public class XtextTemplateStore
extends TemplateStore {
    private static final Logger log = Logger.getLogger(XtextTemplateStore.class);
    private final URL resource;

    @Inject
    public XtextTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, @Named(value="languageName") String key, AbstractUIPlugin plugin) {
        super(registry, store, key + ".templates");
        this.resource = this.getTemplateFileURL(plugin);
        try {
            this.load();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected URL getResource() {
        return this.resource;
    }

    protected URL getTemplateFileURL(AbstractUIPlugin plugin) {
        return plugin.getBundle().getEntry("templates/templates.xml");
    }

    protected void loadContributedTemplates() throws IOException {
        if (this.resource == null) {
            return;
        }
        TemplateReaderWriter reader = new TemplateReaderWriter();
        InputStream openStream = null;
        try {
            openStream = this.resource.openStream();
            try {
                TemplatePersistenceData[] read;
                TemplatePersistenceData[] templatePersistenceDataArray = read = reader.read(openStream, null);
                int n = read.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplatePersistenceData templatePersistenceData = templatePersistenceDataArray[n2];
                    this.internalAdd(templatePersistenceData);
                    ++n2;
                }
            }
            finally {
                openStream.close();
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void handleException(IOException x) {
        log.error((Object)x.getMessage(), (Throwable)x);
    }
}

