/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.projection;

import org.eclipse.jface.text.Position;
import org.eclipse.wst.json.core.document.IJSONArray;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.ui.internal.projection.JSONObjectFoldingPosition;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.projection.AbstractStructuredFoldingStrategy;

public class JSONFoldingStrategy
extends AbstractStructuredFoldingStrategy {
    protected Position calcNewFoldPosition(IndexedRegion indexedRegion) {
        JSONObjectFoldingPosition retPos = null;
        if (indexedRegion.getStartOffset() >= 0 && indexedRegion.getLength() >= 0) {
            IJSONNode node = (IJSONNode)indexedRegion;
            IStructuredDocumentRegion startRegion = node.getStartStructuredDocumentRegion();
            IStructuredDocumentRegion endRegion = node.getEndStructuredDocumentRegion();
            if (startRegion != null && endRegion != null) {
                if (startRegion.getEndOffset() == endRegion.getStartOffset()) {
                    return null;
                }
                if (endRegion.getEndOffset() >= startRegion.getStartOffset() && endRegion.getEndOffset() <= this.getDocument().getLength()) {
                    retPos = new JSONObjectFoldingPosition(startRegion, endRegion);
                }
            }
        }
        return retPos;
    }

    protected boolean indexedRegionValidType(IndexedRegion indexedRegion) {
        return indexedRegion instanceof IJSONObject || indexedRegion instanceof IJSONArray || indexedRegion instanceof IJSONPair;
    }
}

