"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const language_service_1 = require("@volar/language-service");
function register(htmlLs) {
    return (pugDoc, pos) => {
        const htmlPos = pugDoc.map.getGeneratedPosition(pos);
        if (!htmlPos) {
            return;
        }
        const htmlResult = htmlLs.findDocumentHighlights(pugDoc.map.embeddedDocument, htmlPos, pugDoc.htmlDocument);
        return (0, language_service_1.transformLocations)(htmlResult, htmlRange => pugDoc.map.getSourceRange(htmlRange));
    };
}
exports.register = register;
//# sourceMappingURL=documentHighlight.js.map