import type { Disposable, DocumentSelector, ProviderResult, ServiceContext, LanguageServicePlugin } from '@volar/language-service';
import type * as html from 'vscode-html-languageservice';
import type { TextDocument } from 'vscode-languageserver-textdocument';
import * as pug from './lib/languageService';
export interface Provide {
    'pug/pugDocument': (document: TextDocument) => pug.PugDocument | undefined;
    'pug/languageService': () => pug.LanguageService;
}
export declare function create({ documentSelector, getCustomData, onDidChangeCustomData, }?: {
    documentSelector?: DocumentSelector;
    getCustomData?(context: ServiceContext): ProviderResult<html.IHTMLDataProvider[]>;
    onDidChangeCustomData?(listener: () => void, context: ServiceContext): Disposable;
}): LanguageServicePlugin;
//# sourceMappingURL=index.d.ts.map