/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model;

import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.parser.AbstractParser;
import org.eclipse.wb.internal.core.databinding.parser.IModelResolver;
import org.eclipse.wb.internal.core.databinding.parser.ISubParser;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.ContainerAstObjectInfo;
import org.eclipse.wb.internal.swing.databinding.model.DataBindingsCodeUtils;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.TypeObjectInfo;
import org.eclipse.wb.internal.swing.databinding.model.UndefineObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeansObserveTypeContainer;
import org.eclipse.wb.internal.swing.databinding.model.beans.ElPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.AutoBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JComboBoxBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JListBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JTableBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.UpdateStrategyInfo;
import org.eclipse.wb.internal.swing.databinding.model.components.ComponentsObserveTypeContainer;
import org.eclipse.wb.internal.swing.databinding.model.components.JavaInfoReferenceProvider;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.BeanPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.ElPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.ObjectPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;

public final class DataBindingsRootInfo
implements ISubParser {
    public static final String INIT_DATA_BINDINGS_METHOD_NAME = "initDataBindings";
    public static final String[] ACCESS_VALUES = new String[]{"public ", "protected ", "private ", ""};
    private static final String BINDINGS_CREATE_AUTO_BINDING = "org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy,";
    private static final String SWING_BINDINGS_CREATE_JLIST_BINDING = "org.jdesktop.swingbinding.SwingBindings.createJListBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy,";
    private static final String SWING_BINDINGS_CREATE_JTABLE_BINDING = "org.jdesktop.swingbinding.SwingBindings.createJTableBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy,";
    private static final String SWING_BINDINGS_CREATE_JCOMBO_BOX_BINDING = "org.jdesktop.swingbinding.SwingBindings.createJComboBoxBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy,";
    private static final String CONSTRUCTOR_SIGNATURE = "<init>(org.eclipse.wb.internal.swing.databinding.model.bindings.UpdateStrategyInfo,org.eclipse.wb.internal.swing.databinding.model.ObserveInfo,org.eclipse.wb.internal.swing.databinding.model.ObserveInfo,org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo,org.eclipse.wb.internal.swing.databinding.model.ObserveInfo,org.eclipse.wb.internal.swing.databinding.model.ObserveInfo,org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo)";
    private static Constructor<JListBindingInfo> m_constructorJList;
    private static Constructor<JTableBindingInfo> m_constructorJTable;
    private static Constructor<JComboBoxBindingInfo> m_constructorJComboBox;
    private final DatabindingsProvider m_provider;
    private final List<BindingInfo> m_bindings = new ArrayList<BindingInfo>();
    private MethodDeclaration m_initDataBindings;
    private boolean m_addToGroup;
    private boolean m_addInitializeContext;
    private boolean m_addPostInitializeContext;

    public DataBindingsRootInfo(DatabindingsProvider provider) {
        this.m_provider = provider;
    }

    public List<BindingInfo> getBindings() {
        return this.m_bindings;
    }

    public MethodDeclaration getInitDataBindings() {
        return this.m_initDataBindings;
    }

    public void setInitDataBindings(MethodDeclaration initDataBindings) {
        this.m_initDataBindings = initDataBindings;
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((MethodDeclaration)this.m_initDataBindings);
        ITypeBinding returnType = methodBinding == null ? null : methodBinding.getReturnType();
        this.m_addToGroup = returnType != null && "org.jdesktop.beansbinding.BindingGroup".equals(AstNodeUtils.getFullyQualifiedName((ITypeBinding)returnType, (boolean)false));
    }

    public AstObjectInfo parseExpression(AstEditor editor, String signature, ClassInstanceCreation creation, Expression[] arguments, IModelResolver resolver, IDatabindingsProvider provider) throws Exception {
        ITypeBinding binding = AstNodeUtils.getTypeBinding((Expression)creation);
        if (binding == null) {
            return null;
        }
        if (AstNodeUtils.isSuccessorOf((ITypeBinding)binding, (String)"org.jdesktop.beansbinding.Converter") || AstNodeUtils.isSuccessorOf((ITypeBinding)binding, (String)"org.jdesktop.beansbinding.Validator")) {
            String parameters = null;
            if (arguments.length > 0) {
                String source = editor.getSource((ASTNode)creation);
                parameters = source.substring(source.indexOf(40));
            }
            return new TypeObjectInfo(GenericUtils.getCreationType(editor, creation), parameters);
        }
        return null;
    }

    public AstObjectInfo parseExpression(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver) throws Exception {
        if (m_constructorJList == null) {
            m_constructorJList = ReflectionUtils.getConstructorBySignature(JListBindingInfo.class, (String)CONSTRUCTOR_SIGNATURE);
            m_constructorJTable = ReflectionUtils.getConstructorBySignature(JTableBindingInfo.class, (String)CONSTRUCTOR_SIGNATURE);
            m_constructorJComboBox = ReflectionUtils.getConstructorBySignature(JComboBoxBindingInfo.class, (String)CONSTRUCTOR_SIGNATURE);
        }
        if (signature.startsWith(BINDINGS_CREATE_AUTO_BINDING)) {
            switch (arguments.length) {
                case 4: {
                    return this.createAutoBindingForObjectToProperty(editor, signature, invocation, arguments, resolver);
                }
                case 5: {
                    if (signature.endsWith(",java.lang.String)")) {
                        return this.createAutoBindingForObjectToProperty(editor, signature, invocation, arguments, resolver);
                    }
                }
                case 6: {
                    return this.createAutoBindingForProperties(editor, signature, invocation, arguments, resolver);
                }
            }
        } else if (signature.startsWith(SWING_BINDINGS_CREATE_JLIST_BINDING)) {
            if (signature.endsWith(",java.util.List,javax.swing.JList)") || signature.endsWith(",java.util.List,javax.swing.JList,java.lang.String)")) {
                return this.createBindingForListToJComponent(editor, signature, invocation, arguments, resolver, m_constructorJList);
            }
            if (signature.endsWith(",org.jdesktop.beansbinding.Property,javax.swing.JList)") || signature.endsWith(",org.jdesktop.beansbinding.Property,javax.swing.JList,java.lang.String)")) {
                return this.createBindingForListPropertyToJComponent(editor, signature, invocation, arguments, resolver, m_constructorJList);
            }
        } else if (signature.startsWith(SWING_BINDINGS_CREATE_JTABLE_BINDING)) {
            if (signature.endsWith(",java.util.List,javax.swing.JTable)") || signature.endsWith(",java.util.List,javax.swing.JTable,java.lang.String)")) {
                return this.createBindingForListToJComponent(editor, signature, invocation, arguments, resolver, m_constructorJTable);
            }
            if (signature.endsWith(",org.jdesktop.beansbinding.Property,javax.swing.JTable)") || signature.endsWith(",org.jdesktop.beansbinding.Property,javax.swing.JTable,java.lang.String)")) {
                return this.createBindingForListPropertyToJComponent(editor, signature, invocation, arguments, resolver, m_constructorJTable);
            }
        } else if (signature.startsWith(SWING_BINDINGS_CREATE_JCOMBO_BOX_BINDING)) {
            if (signature.endsWith(",java.util.List,javax.swing.JComboBox)") || signature.endsWith(",java.util.List,javax.swing.JComboBox,java.lang.String)")) {
                return this.createBindingForListToJComponent(editor, signature, invocation, arguments, resolver, m_constructorJComboBox);
            }
            if (signature.endsWith(",org.jdesktop.beansbinding.Property,javax.swing.JComboBox)") || signature.endsWith(",org.jdesktop.beansbinding.Property,javax.swing.JComboBox,java.lang.String)")) {
                return this.createBindingForListPropertyToJComponent(editor, signature, invocation, arguments, resolver, m_constructorJComboBox);
            }
        } else if (signature.endsWith("initializeBindings()")) {
            this.m_addInitializeContext = true;
        } else if (signature.endsWith("postInitializeBindings()")) {
            this.m_addPostInitializeContext = true;
        }
        return null;
    }

    private BindingInfo addBinding(AstEditor editor, String signature, Expression[] arguments, BindingInfo binding) throws Exception {
        if (signature.endsWith(",java.lang.String)")) {
            String name = (String)CoreUtils.evaluate(String.class, (AstEditor)editor, (Expression)arguments[arguments.length - 1]);
            binding.setName(StringEscapeUtils.unescapeJava((String)name));
        }
        binding.preCreate();
        this.m_bindings.add(binding);
        return binding;
    }

    private BindingInfo createAutoBindingForObjectToProperty(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver) throws Exception {
        UpdateStrategyInfo strategyInfo = DataBindingsRootInfo.createStrategy(arguments[0]);
        ObserveInfo model = this.getObserveInfo(arguments[1]);
        if (model == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errModelArgumentNotFound, arguments[1]), (Throwable)new Throwable());
            return null;
        }
        IGenericType[] types = GenericUtils.getReturnTypeArguments(editor, invocation, 3);
        ObjectPropertyInfo modelAstProperty = new ObjectPropertyInfo(types[0]);
        ObserveInfo modelProperty = ((PropertyInfo)modelAstProperty).getObserveProperty(model);
        Assert.isNotNull((Object)modelProperty);
        DataBindingsRootInfo.assertEquals(modelProperty, modelAstProperty);
        ObserveInfo target = this.getObserveInfo(arguments[2]);
        if (target == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errTargetArgumentNotFound, arguments[2]), (Throwable)new Throwable());
            return null;
        }
        PropertyInfo targetAstProperty = (PropertyInfo)resolver.getModel(arguments[3]);
        if (targetAstProperty == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errTargetPropertyArgumentNotFound, arguments[3]), (Throwable)new Throwable());
            return null;
        }
        ObserveInfo targetProperty = targetAstProperty.getObserveProperty(target);
        if (targetProperty == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errTargetProperty2NotFound, arguments[2], arguments[3]), (Throwable)new Throwable());
            targetProperty = DataBindingsRootInfo.createDefaultProperty(targetAstProperty);
        } else {
            DataBindingsRootInfo.assertObserves(types, 1, target, targetAstProperty, targetProperty);
        }
        return this.addBinding(editor, signature, arguments, new AutoBindingInfo(strategyInfo, target, targetProperty, targetAstProperty, model, modelProperty, modelAstProperty));
    }

    private BindingInfo createAutoBindingForProperties(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver) throws Exception {
        UpdateStrategyInfo strategyInfo = DataBindingsRootInfo.createStrategy(arguments[0]);
        ObserveInfo model = this.getObserveInfo(arguments[1]);
        if (model == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errModelArgumentNotFound, arguments[1]), (Throwable)new Throwable());
            return null;
        }
        PropertyInfo modelAstProperty = (PropertyInfo)resolver.getModel(arguments[2]);
        if (modelAstProperty == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errModelPropertyArgumentNotFound, arguments[2]), (Throwable)new Throwable());
            return null;
        }
        ObserveInfo modelProperty = modelAstProperty.getObserveProperty(model);
        IGenericType[] types = GenericUtils.getReturnTypeArguments(editor, invocation, 4);
        if (modelProperty == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errModelProperty2NotFound, arguments[1], arguments[2]), (Throwable)new Throwable());
            modelProperty = DataBindingsRootInfo.createDefaultProperty(modelAstProperty);
        } else {
            DataBindingsRootInfo.assertObserves(types, 0, model, modelAstProperty, modelProperty);
        }
        ObserveInfo target = this.getObserveInfo(arguments[3]);
        if (target == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errTargetArgumentNotFound, arguments[3]), (Throwable)new Throwable());
            return null;
        }
        PropertyInfo targetAstProperty = (PropertyInfo)resolver.getModel(arguments[4]);
        if (targetAstProperty == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errArgumentNotFound, arguments[4]), (Throwable)new Throwable());
            return null;
        }
        ObserveInfo targetProperty = targetAstProperty.getObserveProperty(target);
        if (targetProperty == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errTargetProperty2NotFound, arguments[3], arguments[4]), (Throwable)new Throwable());
            targetProperty = DataBindingsRootInfo.createDefaultProperty(targetAstProperty);
        } else {
            DataBindingsRootInfo.assertObserves(types, 2, target, targetAstProperty, targetProperty);
        }
        return this.addBinding(editor, signature, arguments, new AutoBindingInfo(strategyInfo, target, targetProperty, targetAstProperty, model, modelProperty, modelAstProperty));
    }

    private BindingInfo createBindingForListToJComponent(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver, Constructor<? extends BindingInfo> constructor) throws Exception {
        UpdateStrategyInfo strategyInfo = DataBindingsRootInfo.createStrategy(arguments[0]);
        ObserveInfo model = this.getBeanObserveInfo(arguments[1]);
        if (model == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errModelArgumentNotFound, arguments[1]), (Throwable)new Throwable());
            return null;
        }
        ObjectPropertyInfo modelAstProperty = new ObjectPropertyInfo(model.getObjectType());
        ObserveInfo modelProperty = ((PropertyInfo)modelAstProperty).getObserveProperty(model);
        Assert.isNotNull((Object)modelProperty);
        DataBindingsRootInfo.assertEquals(modelProperty, modelAstProperty);
        ObserveInfo target = this.getComponentObserveInfo(arguments[2]);
        if (target == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errTargetArgumentNotFound, arguments[2]), (Throwable)new Throwable());
            return null;
        }
        ObjectPropertyInfo targetAstProperty = new ObjectPropertyInfo(target.getObjectType());
        ObserveInfo targetProperty = ((PropertyInfo)targetAstProperty).getObserveProperty(target);
        Assert.isNotNull((Object)targetProperty);
        DataBindingsRootInfo.assertEquals(targetProperty, targetAstProperty);
        return this.addBinding(editor, signature, arguments, constructor.newInstance(new Object[]{strategyInfo, target, targetProperty, targetAstProperty, model, modelProperty, modelAstProperty}));
    }

    private BindingInfo createBindingForListPropertyToJComponent(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver, Constructor<? extends BindingInfo> constructor) throws Exception {
        ObserveInfo target;
        UpdateStrategyInfo strategyInfo = DataBindingsRootInfo.createStrategy(arguments[0]);
        ObserveInfo model = this.getObserveInfo(arguments[1]);
        if (model == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errModelArgumentNotFound, arguments[1]), (Throwable)new Throwable());
            return null;
        }
        IGenericType[] types = GenericUtils.getReturnTypeArguments(editor, invocation, 2);
        GenericUtils.assertEquals(model.getObjectType(), types[1]);
        PropertyInfo modelAstProperty = (PropertyInfo)resolver.getModel(arguments[2]);
        if (modelAstProperty == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errModelPropertyArgumentNotFound, arguments[2]), (Throwable)new Throwable());
            return null;
        }
        ObserveInfo modelProperty = modelAstProperty.getObserveProperty(model);
        if (modelProperty == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errModelProperty2NotFound, arguments[1], arguments[2]), (Throwable)new Throwable());
            modelProperty = DataBindingsRootInfo.createDefaultProperty(modelAstProperty);
        }
        if ((target = this.getComponentObserveInfo(arguments[3])) == null) {
            AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.DataBindingsRootInfo_errTargetArgumentNotFound, arguments[3]), (Throwable)new Throwable());
            return null;
        }
        ObjectPropertyInfo targetAstProperty = new ObjectPropertyInfo(target.getObjectType());
        ObserveInfo targetProperty = ((PropertyInfo)targetAstProperty).getObserveProperty(target);
        Assert.isNotNull((Object)targetProperty);
        DataBindingsRootInfo.assertEquals(targetProperty, targetAstProperty);
        Assert.isTrue((boolean)(DatabindingsProvider.isSwingBinding(model, modelProperty) ^ DatabindingsProvider.isSwingBinding(target, targetProperty)));
        return this.addBinding(editor, signature, arguments, constructor.newInstance(new Object[]{strategyInfo, target, targetProperty, targetAstProperty, model, modelProperty, modelAstProperty}));
    }

    private static UpdateStrategyInfo createStrategy(Expression expression) {
        expression = AstNodeUtils.getActualVariableExpression((Expression)expression);
        return new UpdateStrategyInfo(expression.toString());
    }

    private ObserveInfo getObserveInfo(Expression expression) throws Exception {
        ObserveInfo observeInfo = this.getComponentObserveInfo(expression);
        if (observeInfo != null) {
            return observeInfo;
        }
        return this.getBeanObserveInfo(expression);
    }

    private ObserveInfo getBeanObserveInfo(Expression expression) throws Exception {
        BeansObserveTypeContainer beansContainer = (BeansObserveTypeContainer)this.m_provider.getContainer(ObserveType.BEANS);
        return beansContainer.resolve(expression);
    }

    private ObserveInfo getComponentObserveInfo(Expression expression) throws Exception {
        ComponentsObserveTypeContainer componentsContainer = (ComponentsObserveTypeContainer)this.m_provider.getContainer(ObserveType.WIDGETS);
        return componentsContainer.resolve(expression);
    }

    private static void assertEquals(ObserveInfo property, PropertyInfo astProperty) {
        if (property instanceof ElPropertyObserveInfo) {
            Assert.instanceOf(ElPropertyInfo.class, (Object)((Object)astProperty));
        } else {
            GenericUtils.assertEquals(property.getObjectType(), astProperty.getValueType());
        }
    }

    private static void assertObserves(IGenericType[] types, int index, ObserveInfo observe, PropertyInfo astProperty, ObserveInfo property) {
        GenericUtils.assertEquals(observe.getObjectType(), astProperty.getSourceObjectType());
        GenericUtils.assertEquals(types[index], astProperty.getSourceObjectType());
        GenericUtils.assertEquals(types[index + 1], astProperty.getValueType());
        if (property.getObjectType() != null) {
            DataBindingsRootInfo.assertEquals(property, astProperty);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ObserveInfo createDefaultProperty(PropertyInfo astProperty) {
        String text = "";
        PropertyInfo propertyInfo = astProperty;
        if (propertyInfo instanceof BeanPropertyInfo) {
            void beanProperty;
            BeanPropertyInfo beanPropertyInfo = (BeanPropertyInfo)propertyInfo;
            BeanPropertyInfo cfr_ignored_0 = (BeanPropertyInfo)propertyInfo;
            text = beanProperty.getPath();
        }
        return new UndefineObserveInfo(text, null);
    }

    public void preCommit() throws Exception {
        JavaInfoReferenceProvider.LAZY_DETECTED = true;
    }

    public boolean commit() throws Exception {
        JavaInfo javaInfoRoot = this.m_provider.getJavaInfoRoot();
        AstEditor editor = javaInfoRoot.getEditor();
        IJavaProject javaProject = editor.getJavaProject();
        CodeGenerationSupport generationSupport = new CodeGenerationSupport(CoreUtils.useGenerics((IJavaProject)javaProject), (AstObjectInfo)new ContainerAstObjectInfo(this.m_bindings));
        boolean reparse = DataBindingsCodeUtils.ensureDBLibraries(javaProject);
        ArrayList<Object> methodLines = new ArrayList<Object>();
        if (this.m_addInitializeContext) {
            methodLines.add("initializeBindings();");
            methodLines.add("//");
        }
        int size = this.m_bindings.size();
        int i = 0;
        while (i < size) {
            BindingInfo binding = this.m_bindings.get(i);
            if (i > 0 && binding.addSourceCodeSeparator()) {
                methodLines.add("//");
            }
            binding.addSourceCode(methodLines, generationSupport);
            ++i;
        }
        if (this.m_addToGroup) {
            String groupVariable = generationSupport.generateLocalName(new String[]{"bindingGroup"});
            methodLines.add("//");
            methodLines.add("org.jdesktop.beansbinding.BindingGroup " + groupVariable + " = new org.jdesktop.beansbinding.BindingGroup();");
            methodLines.add("//");
            for (BindingInfo binding : this.m_bindings) {
                if (binding.isManaged()) continue;
                methodLines.add(groupVariable + ".addBinding(" + binding.getVariableIdentifier() + ");");
            }
            if (this.m_addPostInitializeContext) {
                methodLines.add("//");
                methodLines.add("postInitializeBindings();");
                methodLines.add("//");
            }
            methodLines.add("return " + groupVariable + ";");
        } else if (this.m_addPostInitializeContext) {
            methodLines.add("//");
            methodLines.add("postInitializeBindings();");
        }
        if (this.m_initDataBindings != null) {
            editor.removeBodyDeclaration((BodyDeclaration)this.m_initDataBindings);
        }
        MethodDeclaration lastInfoMethod = DataBindingsCodeUtils.getLastInfoDeclaration(this.m_initDataBindings, javaInfoRoot);
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)javaInfoRoot);
        BodyDeclarationTarget target = new BodyDeclarationTarget(typeDeclaration, null, false);
        this.m_initDataBindings = editor.addMethodDeclaration(DataBindingsRootInfo.createMethodHeader(this.m_addToGroup, lastInfoMethod), methodLines, target);
        DataBindingsCodeUtils.ensureInvokeInitDataBindings(editor, lastInfoMethod);
        return reparse;
    }

    public void postCommit() throws Exception {
        JavaInfoReferenceProvider.LAZY_DETECTED = false;
    }

    private static String createMethodHeader(boolean addToGroup, MethodDeclaration lastInfoMethod) throws Exception {
        String returnType = addToGroup ? "org.jdesktop.beansbinding.BindingGroup " : "void ";
        int access = 1;
        if (Modifier.isStatic((int)lastInfoMethod.getModifiers())) {
            return ACCESS_VALUES[access] + "static " + returnType + "initDataBindings()";
        }
        return ACCESS_VALUES[access] + returnType + "initDataBindings()";
    }
}

