/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.generic;

import java.util.List;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.validator.LayoutRequestValidators;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.layout.generic.AbstractContainerRequestValidator;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IPasteComponentProcessor;

public final class SimpleContainerLayoutEditPolicy
extends LayoutEditPolicy {
    private final ObjectInfo m_model;
    private final SimpleContainer m_container;
    private final ILayoutRequestValidator m_requestValidator;

    public SimpleContainerLayoutEditPolicy(ObjectInfo model, SimpleContainer container) {
        this.m_model = model;
        this.m_container = container;
        ILayoutRequestValidator validator = new AbstractContainerRequestValidator(container);
        validator = LayoutRequestValidators.cache(validator);
        this.m_requestValidator = validator;
    }

    @Override
    protected ILayoutRequestValidator getRequestValidator() {
        return this.m_requestValidator;
    }

    @Override
    protected void showLayoutTargetFeedback(Request request) {
        PolicyUtils.showBorderTargetFeedback(this);
    }

    @Override
    protected void eraseLayoutTargetFeedback(Request request) {
        PolicyUtils.eraseBorderTargetFeedback(this);
    }

    @Override
    public Command getCommand(Request request) {
        if (!this.m_container.isEmpty()) {
            return null;
        }
        return super.getCommand(request);
    }

    @Override
    protected Command getCreateCommand(CreateRequest request) {
        final Object newObject = request.getNewObject();
        return new EditCommand(this.m_model){

            @Override
            protected void executeEdit() throws Exception {
                SimpleContainerLayoutEditPolicy.this.m_container.command_CREATE(newObject);
            }
        };
    }

    @Override
    protected Command getPasteCommand(PasteRequest request) {
        return GlobalState.getPasteRequestProcessor().getPasteCommand(request, new IPasteComponentProcessor(){

            @Override
            public void process(Object component) throws Exception {
                SimpleContainerLayoutEditPolicy.this.m_container.command_CREATE(component);
            }
        });
    }

    @Override
    protected Command getAddCommand(ChangeBoundsRequest request) {
        final List<EditPart> parts = request.getEditParts();
        if (parts.size() == 1) {
            return new EditCommand(this.m_model){

                @Override
                protected void executeEdit() throws Exception {
                    Object object = ((EditPart)((Object)parts.get(0))).getModel();
                    SimpleContainerLayoutEditPolicy.this.m_container.command_ADD(object);
                }
            };
        }
        return null;
    }
}

