/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions.errors;

import java.io.StringWriter;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.actions.errors.IErrorPage;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public abstract class BadNodesErrorPage
implements IErrorPage {
    private AstEditor m_editor;
    private EditorState.BadNodesCollection m_collection;
    private List m_nodesList;
    private Browser m_browser;

    /*
     * WARNING - void declaration
     */
    public final void setRoot(ObjectInfo rootObject) {
        ObjectInfo objectInfo = rootObject;
        if (objectInfo instanceof JavaInfo) {
            void javaInfo;
            JavaInfo javaInfo2 = (JavaInfo)objectInfo;
            JavaInfo cfr_ignored_0 = (JavaInfo)objectInfo;
            this.m_editor = javaInfo.getEditor();
            EditorState editorState = EditorState.get(this.m_editor);
            this.m_collection = this.getCollection(editorState);
        } else {
            this.m_collection = null;
        }
    }

    public final boolean hasErrors() {
        return this.m_collection != null && !this.m_collection.isEmpty();
    }

    public final Control create(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.create((Composite)container);
        Group group = new Group(container, 0);
        GridDataFactory.create((Control)group).grabH().fill();
        GridLayoutFactory.create((Composite)group);
        group.setText(Messages.BadNodesErrorPage_nodesGroup);
        this.m_nodesList = new List((Composite)group, 2560);
        GridDataFactory.create((Control)this.m_nodesList).hintC(100, 10).grab().fill();
        if (this.m_collection != null) {
            for (EditorState.BadNodeInformation badNode : this.m_collection.nodes()) {
                try {
                    this.m_nodesList.add(this.m_editor.getSource(badNode.getNode()));
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
        }
        this.m_nodesList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BadNodesErrorPage.this.showException();
            }
        });
        group = new Group(container, 0);
        GridDataFactory.create((Control)group).grab().fill();
        GridLayoutFactory.create((Composite)group);
        group.setText(Messages.BadNodesErrorPage_nodeGroup);
        this.m_browser = new Browser((Composite)group, 2048);
        GridDataFactory.create((Control)this.m_browser).hintC(100, 15).grab().fill();
        if (this.m_nodesList.getItemCount() != 0) {
            this.m_nodesList.select(0);
            this.showException();
        }
        return container;
    }

    private void showException() {
        try {
            int index = this.m_nodesList.getSelectionIndex();
            EditorState.BadNodeInformation badNode = this.m_collection.nodes().get(index);
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("<pre>");
            stringWriter.write(this.m_editor.getSource(badNode.getNode()));
            stringWriter.write("</pre>");
            stringWriter.write("<p>");
            Throwable exception = badNode.getException();
            exception = DesignerExceptionUtils.rewriteException((Throwable)exception);
            String text = DesignerExceptionUtils.getExceptionHTML((Throwable)exception);
            stringWriter.write(text);
            this.m_browser.setText(stringWriter.toString());
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    protected abstract EditorState.BadNodesCollection getCollection(EditorState var1);
}

