/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.InternalHandlerUtil;

public class CloseAllHandler
extends AbstractEvaluationHandler {
    private Expression enabledWhen;

    public CloseAllHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            page.closeAllEditors(true);
        }
        return null;
    }

    @Override
    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) {
                    IEditorReference[] refArray;
                    IWorkbenchPage page;
                    IWorkbenchPart part = InternalHandlerUtil.getActivePart(context);
                    Object perspective = InternalHandlerUtil.getVariable(context, "activeWorkbenchWindow.activePerspective");
                    if (part != null && perspective != null && part.getSite() != null && (page = part.getSite().getPage()) != null && (refArray = page.getEditorReferences()) != null && refArray.length > 0) {
                        return EvaluationResult.TRUE;
                    }
                    return EvaluationResult.FALSE;
                }

                public void collectExpressionInfo(ExpressionInfo info) {
                    info.addVariableNameAccess("activePart");
                    info.addVariableNameAccess("activeWorkbenchWindow.activePerspective");
                }
            };
        }
        return this.enabledWhen;
    }
}

