/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.series;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.compress.CompressLineSeries;
import org.eclipse.swtchart.internal.compress.CompressScatterSeries;
import org.eclipse.swtchart.internal.series.Series;
import org.eclipse.swtchart.model.CartesianSeriesModel;
import org.eclipse.swtchart.model.DoubleArraySeriesModel;

public class LineSeries<T>
extends Series<T>
implements ILineSeries<T> {
    private int symbolSize = 4;
    private Color symbolColor = Display.getDefault().getSystemColor(16);
    private Color[] symbolColors = new Color[0];
    private ILineSeries.PlotSymbolType symbolType = DEFAULT_SYMBOL_TYPE;
    private LineStyle lineStyle = DEFAULT_LINE_STYLE;
    private Color lineColor = Display.getDefault().getSystemColor(9);
    private int lineWidth = 1;
    private boolean areaEnabled = false;
    private boolean stepEnabled = false;
    private int antialias = -1;
    private String extendedSymbolType = "\ud83d\ude02";
    private static final int ALPHA = 50;
    private static final LineStyle DEFAULT_LINE_STYLE = LineStyle.SOLID;
    private static final int DEFAULT_LINE_WIDTH = 1;
    private static final int DEFAULT_LINE_COLOR = 9;
    private static final int DEFAULT_SYMBOL_COLOR = 16;
    private static final int DEFAULT_SIZE = 4;
    private static final ILineSeries.PlotSymbolType DEFAULT_SYMBOL_TYPE = ILineSeries.PlotSymbolType.CIRCLE;
    private static final int DEFAULT_ANTIALIAS = -1;
    private static final int MARGIN_AT_MIN_MAX_PLOT = 6;

    protected LineSeries(Chart chart, String id) {
        super(chart, id);
        this.compressor = new CompressLineSeries();
    }

    @Override
    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(LineStyle style) {
        if (style == null) {
            this.lineStyle = DEFAULT_LINE_STYLE;
            return;
        }
        this.lineStyle = style;
        if (this.compressor instanceof CompressScatterSeries) {
            ((CompressScatterSeries)this.compressor).setLineVisible(style != LineStyle.NONE);
        }
    }

    @Override
    public Color getLineColor() {
        if (this.lineColor.isDisposed()) {
            this.lineColor = Display.getDefault().getSystemColor(9);
        }
        return this.lineColor;
    }

    @Override
    public void setLineColor(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.lineColor = color == null ? Display.getDefault().getSystemColor(9) : color;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width <= 0 ? 1 : width;
    }

    @Override
    public ILineSeries.PlotSymbolType getSymbolType() {
        return this.symbolType;
    }

    @Override
    public void setSymbolType(ILineSeries.PlotSymbolType type) {
        this.symbolType = type == null ? DEFAULT_SYMBOL_TYPE : type;
    }

    @Override
    public String getExtendedPlotSymbolType() {
        return this.extendedSymbolType;
    }

    @Override
    public void setExtendedPlotSymbolType(String type) {
        this.extendedSymbolType = type;
    }

    @Override
    public int getSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public void setSymbolSize(int size) {
        this.symbolSize = size <= 0 ? 4 : size;
    }

    @Override
    public Color getSymbolColor() {
        return this.symbolColor;
    }

    @Override
    public void setSymbolColor(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.symbolColor = color == null ? Display.getDefault().getSystemColor(16) : color;
    }

    @Override
    public Color[] getSymbolColors() {
        Color[] copiedSymbolColors = new Color[this.symbolColors.length];
        System.arraycopy(this.symbolColors, 0, copiedSymbolColors, 0, this.symbolColors.length);
        return copiedSymbolColors;
    }

    @Override
    public void setSymbolColors(Color[] colors) {
        if (colors == null) {
            this.symbolColors = new Color[0];
            return;
        }
        Color[] colorArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            Color color = colorArray[n2];
            if (color.isDisposed()) {
                SWT.error((int)5);
            }
            ++n2;
        }
        this.symbolColors = new Color[colors.length];
        System.arraycopy(colors, 0, this.symbolColors, 0, colors.length);
    }

    @Override
    protected void setCompressor() {
        CartesianSeriesModel dataModel = this.getDataModel();
        if (dataModel instanceof DoubleArraySeriesModel && ((DoubleArraySeriesModel)dataModel).isXMonotoneIncreasing()) {
            this.compressor = new CompressLineSeries();
            return;
        }
        this.compressor = new CompressScatterSeries();
        ((CompressScatterSeries)this.compressor).setLineVisible(this.getLineStyle() != LineStyle.NONE);
    }

    @Override
    public void enableArea(boolean enabled) {
        this.areaEnabled = enabled;
    }

    @Override
    public boolean isAreaEnabled() {
        return this.areaEnabled;
    }

    @Override
    public void enableStep(boolean enabled) {
        this.stepEnabled = enabled;
    }

    @Override
    public boolean isStepEnabled() {
        return this.stepEnabled;
    }

    @Override
    public Range getAdjustedRange(Axis axis, int length) {
        Range range = axis.getDirection() == IAxis.Direction.X ? this.getXRange() : this.getYRange();
        int lowerPlotMargin = this.getSymbolSize() + 6;
        int upperPlotMargin = this.getSymbolSize() + 6;
        return this.getRangeWithMargin(lowerPlotMargin, upperPlotMargin, length, axis, range);
    }

    @Override
    public int getAntialias() {
        return this.antialias;
    }

    @Override
    public void setAntialias(int antialias) {
        if (antialias != -1 && antialias != 1 && antialias != 0) {
            SWT.error((int)5);
        }
        this.antialias = antialias;
    }

    private int[] getLinePoints(double[] xseries, double[] yseries, int[] indexes, int index, Axis xAxis, Axis yAxis) {
        int y4;
        int y3;
        double baseYCoordinate;
        int x2;
        int x1 = xAxis.getPixelCoordinate(xseries[index]);
        int x3 = x2 = xAxis.getPixelCoordinate(xseries[index + 1]);
        int x4 = x1;
        int y1 = yAxis.getPixelCoordinate(yseries[index]);
        int y2 = yAxis.getPixelCoordinate(yseries[index + 1]);
        double d = baseYCoordinate = yAxis.getRange().lower > 0.0 ? yAxis.getRange().lower : 0.0;
        if (yAxis.isLogScaleEnabled()) {
            y4 = y3 = yAxis.getPixelCoordinate(yAxis.getRange().lower);
        } else if (this.isValidStackSeries()) {
            y1 = yAxis.getPixelCoordinate(this.stackSeries[indexes[index]]);
            y2 = yAxis.getPixelCoordinate(this.stackSeries[indexes[index + 1]]);
            y3 = yAxis.getPixelCoordinate(this.stackSeries[indexes[index + 1]]) + Math.abs(yAxis.getPixelCoordinate(yseries[index + 1]) - yAxis.getPixelCoordinate(0.0)) * (xAxis.isHorizontalAxis() ? 1 : -1);
            y4 = yAxis.getPixelCoordinate(this.stackSeries[indexes[index]]) + Math.abs(yAxis.getPixelCoordinate(yseries[index]) - yAxis.getPixelCoordinate(0.0)) * (xAxis.isHorizontalAxis() ? 1 : -1);
        } else {
            y4 = y3 = yAxis.getPixelCoordinate(baseYCoordinate);
        }
        if (xAxis.isHorizontalAxis()) {
            return new int[]{x1, y1, x2, y2, x3, y3, x4, y4};
        }
        return new int[]{y1, x1, y2, x2, y3, x3, y4, x4};
    }

    @Override
    protected void draw(GC gc, int width, int height, Axis xAxis, Axis yAxis) {
        int oldAntialias = gc.getAntialias();
        int oldLineWidth = gc.getLineWidth();
        gc.setAntialias(this.antialias);
        gc.setLineWidth(this.lineWidth);
        if (this.lineStyle != LineStyle.NONE) {
            this.drawLineAndArea(gc, width, height, xAxis, yAxis);
        }
        if (this.symbolType != ILineSeries.PlotSymbolType.NONE || this.getLabel().isVisible() || this.getXErrorBar().isVisible() || this.getYErrorBar().isVisible()) {
            this.drawSymbolAndLabel(gc, width, height, xAxis, yAxis);
        }
        gc.setAntialias(oldAntialias);
        gc.setLineWidth(oldLineWidth);
    }

    private void drawLineAndArea(GC gc, int width, int height, Axis xAxis, Axis yAxis) {
        double[] xseries = this.compressor.getCompressedXSeries();
        double[] yseries = this.compressor.getCompressedYSeries();
        if (xseries.length == 0 || yseries.length == 0) {
            return;
        }
        int[] indexes = this.compressor.getCompressedIndexes();
        if (xAxis.isValidCategoryAxis()) {
            int i = 0;
            while (i < xseries.length) {
                xseries[i] = indexes[i];
                ++i;
            }
        }
        gc.setLineStyle(this.lineStyle.value());
        Color oldForeground = gc.getForeground();
        gc.setForeground(this.getLineColor());
        boolean isHorizontal = xAxis.isHorizontalAxis();
        if (this.stepEnabled || this.areaEnabled || this.stackEnabled) {
            int i = 0;
            while (i < xseries.length - 1) {
                int[] p = this.getLinePoints(xseries, yseries, indexes, i, xAxis, yAxis);
                if (this.lineStyle != LineStyle.NONE) {
                    if (this.stepEnabled) {
                        if (isHorizontal) {
                            gc.drawLine(p[0], p[1], p[2], p[1]);
                            gc.drawLine(p[2], p[1], p[2], p[3]);
                        } else {
                            gc.drawLine(p[0], p[1], p[0], p[3]);
                            gc.drawLine(p[0], p[3], p[2], p[3]);
                        }
                    } else {
                        gc.drawLine(p[0], p[1], p[2], p[3]);
                    }
                }
                if (this.areaEnabled) {
                    this.drawArea(gc, p, isHorizontal);
                }
                ++i;
            }
        } else if (this.lineStyle == LineStyle.SOLID) {
            LineSeries.drawLine(gc, xAxis, yAxis, xseries, yseries, isHorizontal);
        } else if (this.lineStyle != LineStyle.NONE) {
            LineSeries.drawLineWithStyle(gc, xAxis, yAxis, xseries, yseries, isHorizontal);
        }
        gc.setForeground(oldForeground);
    }

    private static void drawLine(GC gc, Axis xAxis, Axis yAxis, double[] xseries, double[] yseries, boolean isHorizontal) {
        double xLower = xAxis.getRange().lower;
        double xUpper = xAxis.getRange().upper;
        double yLower = yAxis.getRange().lower;
        double yUpper = yAxis.getRange().upper;
        int prevX = xAxis.getPixelCoordinate(xseries[0], xLower, xUpper);
        int prevY = yAxis.getPixelCoordinate(yseries[0], yLower, yUpper);
        boolean drawVerticalLine = false;
        int verticalLineYLower = 0;
        int verticalLineYUpper = 0;
        int i = 0;
        while (i < xseries.length - 1) {
            int x = xAxis.getPixelCoordinate(xseries[i + 1], xLower, xUpper);
            int y = yAxis.getPixelCoordinate(yseries[i + 1], yLower, yUpper);
            if (x == prevX && i < xseries.length - 2) {
                if (drawVerticalLine) {
                    verticalLineYLower = Math.min(verticalLineYLower, y);
                    verticalLineYUpper = Math.max(verticalLineYUpper, y);
                } else {
                    verticalLineYLower = Math.min(prevY, y);
                    verticalLineYUpper = Math.max(prevY, y);
                    drawVerticalLine = true;
                }
            } else {
                if (drawVerticalLine) {
                    if (isHorizontal) {
                        gc.drawLine(prevX, verticalLineYLower, prevX, verticalLineYUpper);
                    } else {
                        gc.drawLine(verticalLineYLower, prevX, verticalLineYUpper, prevX);
                    }
                    drawVerticalLine = false;
                }
                if (isHorizontal) {
                    gc.drawLine(prevX, prevY, x, y);
                } else {
                    gc.drawLine(prevY, prevX, y, x);
                }
            }
            prevX = x;
            prevY = y;
            ++i;
        }
    }

    private static void drawLineWithStyle(GC gc, Axis xAxis, Axis yAxis, double[] xseries, double[] yseries, boolean isHorizontal) {
        double xLower = xAxis.getRange().lower;
        double xUpper = xAxis.getRange().upper;
        double yLower = yAxis.getRange().lower;
        double yUpper = yAxis.getRange().upper;
        ArrayList<Integer> pointList = new ArrayList<Integer>();
        int prevX = xAxis.getPixelCoordinate(xseries[0], xLower, xUpper);
        int prevY = yAxis.getPixelCoordinate(yseries[0], yLower, yUpper);
        LineSeries.addPoint(pointList, prevX, prevY, isHorizontal);
        boolean drawVerticalLine = false;
        int verticalLineYLower = 0;
        int verticalLineYUpper = 0;
        int i = 0;
        while (i < xseries.length - 1) {
            int x = xAxis.getPixelCoordinate(xseries[i + 1], xLower, xUpper);
            int y = yAxis.getPixelCoordinate(yseries[i + 1], yLower, yUpper);
            if (x == prevX && i < xseries.length - 2) {
                if (drawVerticalLine) {
                    verticalLineYLower = Math.min(verticalLineYLower, y);
                    verticalLineYUpper = Math.max(verticalLineYUpper, y);
                } else {
                    verticalLineYLower = Math.min(prevY, y);
                    verticalLineYUpper = Math.max(prevY, y);
                    drawVerticalLine = true;
                }
            } else {
                if (drawVerticalLine) {
                    LineSeries.addPoint(pointList, prevX, verticalLineYLower, isHorizontal);
                    LineSeries.addPoint(pointList, prevX, verticalLineYUpper, isHorizontal);
                    LineSeries.addPoint(pointList, prevX, prevY, isHorizontal);
                }
                LineSeries.addPoint(pointList, x, y, isHorizontal);
                drawVerticalLine = false;
            }
            prevX = x;
            prevY = y;
            ++i;
        }
        int[] polyline = new int[pointList.size()];
        int i2 = 0;
        while (i2 < polyline.length) {
            polyline[i2] = (Integer)pointList.get(i2);
            ++i2;
        }
        boolean advanced = gc.getAdvanced();
        gc.setAdvanced(true);
        gc.drawPolyline(polyline);
        gc.setAdvanced(advanced);
    }

    private static void addPoint(List<Integer> pointList, int x, int y, boolean isHorizontal) {
        if (isHorizontal) {
            pointList.add(x);
            pointList.add(y);
        } else {
            pointList.add(y);
            pointList.add(x);
        }
    }

    private void drawArea(GC gc, int[] p, boolean isHorizontal) {
        int alpha = gc.getAlpha();
        gc.setAlpha(50);
        Color oldBackground = gc.getBackground();
        gc.setBackground(this.getLineColor());
        int[] pointArray = this.stepEnabled ? (isHorizontal ? new int[]{p[0], p[1], p[2], p[1], p[4], p[7], p[6], p[7], p[0], p[1]} : new int[]{p[0], p[1], p[0], p[3], p[6], p[5], p[6], p[7], p[0], p[1]}) : new int[]{p[0], p[1], p[2], p[3], p[4], p[5], p[6], p[7], p[0], p[1]};
        gc.fillPolygon(pointArray);
        gc.setAlpha(alpha);
        gc.setBackground(oldBackground);
    }

    private void drawSymbolAndLabel(GC gc, int width, int height, Axis xAxis, Axis yAxis) {
        double[] xseries = this.compressor.getCompressedXSeries();
        double[] yseries = this.compressor.getCompressedYSeries();
        int[] indexes = this.compressor.getCompressedIndexes();
        if (xAxis.isValidCategoryAxis()) {
            boolean isValidStackSeries = this.isValidStackSeries();
            int i = 0;
            while (i < xseries.length) {
                xseries[i] = indexes[i];
                if (isValidStackSeries) {
                    yseries[i] = this.stackSeries[indexes[i]];
                }
                ++i;
            }
        }
        int i = 0;
        while (i < xseries.length) {
            int v;
            int h;
            Color color = this.symbolColors.length > indexes[i] ? this.symbolColors[indexes[i]] : this.getSymbolColor();
            if (xAxis.isHorizontalAxis()) {
                h = xAxis.getPixelCoordinate(xseries[i]);
                v = yAxis.getPixelCoordinate(yseries[i]);
            } else {
                v = xAxis.getPixelCoordinate(xseries[i]);
                h = yAxis.getPixelCoordinate(yseries[i]);
            }
            if (this.getSymbolType() != ILineSeries.PlotSymbolType.NONE) {
                this.drawSeriesSymbol(gc, h, v, color);
            }
            this.seriesLabel.draw(gc, h, v, yseries[i], indexes[i], 1024);
            this.xErrorBar.draw(gc, h, v, xAxis, indexes[i]);
            this.yErrorBar.draw(gc, h, v, yAxis, indexes[i]);
            ++i;
        }
    }

    public void drawSeriesSymbol(GC gc, int h, int v, Color color) {
        int oldAntialias = gc.getAntialias();
        gc.setAntialias(1);
        Color oldForeground = gc.getForeground();
        gc.setForeground(color);
        Color oldBackground = gc.getBackground();
        gc.setBackground(color);
        switch (this.symbolType) {
            case CIRCLE: {
                gc.fillOval(h - this.symbolSize, v - this.symbolSize, this.symbolSize * 2, this.symbolSize * 2);
                break;
            }
            case SQUARE: {
                gc.fillRectangle(h - this.symbolSize, v - this.symbolSize, this.symbolSize * 2, this.symbolSize * 2);
                break;
            }
            case DIAMOND: {
                int[] diamondArray = new int[]{h, v - this.symbolSize, h + this.symbolSize, v, h, v + this.symbolSize, h - this.symbolSize, v};
                gc.fillPolygon(diamondArray);
                break;
            }
            case TRIANGLE: {
                int[] triangleArray = new int[]{h, v - this.symbolSize, h + this.symbolSize, v + this.symbolSize, h - this.symbolSize, v + this.symbolSize};
                gc.fillPolygon(triangleArray);
                break;
            }
            case INVERTED_TRIANGLE: {
                int[] invertedTriangleArray = new int[]{h, v + this.symbolSize, h + this.symbolSize, v - this.symbolSize, h - this.symbolSize, v - this.symbolSize};
                gc.fillPolygon(invertedTriangleArray);
                break;
            }
            case CROSS: {
                gc.setLineStyle(1);
                gc.drawLine(h - this.symbolSize, v - this.symbolSize, h + this.symbolSize, v + this.symbolSize);
                gc.drawLine(h - this.symbolSize, v + this.symbolSize, h + this.symbolSize, v - this.symbolSize);
                break;
            }
            case PLUS: {
                gc.setLineStyle(1);
                gc.drawLine(h, v - this.symbolSize, h, v + this.symbolSize);
                gc.drawLine(h - this.symbolSize, v, h + this.symbolSize, v);
                break;
            }
            case EMOJI: {
                String extendedSymbol = this.getExtendedPlotSymbolType();
                Point extendedSymbolSize = gc.textExtent(extendedSymbol);
                gc.drawText(extendedSymbol, h - extendedSymbolSize.x / 2, v - extendedSymbolSize.y / 2, true);
                break;
            }
        }
        gc.setAntialias(oldAntialias);
        gc.setBackground(oldBackground);
        gc.setForeground(oldForeground);
    }
}

