/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.color;

import java.util.List;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorCategoryManager;
import org.eclipse.sirius.diagram.ui.tools.internal.colors.AbstractColorCategoryManager;
import org.eclipse.sirius.diagram.ui.tools.internal.colors.FillColorCategoryManager;
import org.eclipse.sirius.diagram.ui.tools.internal.colors.FontColorCategoryManager;
import org.eclipse.sirius.diagram.ui.tools.internal.colors.LineColorCategoryManager;

public class ColorCategoryManagerProvider {
    private static final String FILL_COLOR_PROPERTY_ID = PackageUtil.getID((ENamedElement)NotationPackage.eINSTANCE.getFillStyle_FillColor());
    private static final String LINE_COLOR_PROPERTY_ID = PackageUtil.getID((ENamedElement)NotationPackage.eINSTANCE.getLineStyle_LineColor());
    private static final String FONT_COLOR_PROPERTY_ID = PackageUtil.getID((ENamedElement)NotationPackage.eINSTANCE.getFontStyle_FontColor());

    public ColorCategoryManager getColorCategoryManager(Session session, List<IGraphicalEditPart> editParts, String propertyId) {
        AbstractColorCategoryManager colorCategoryManager = null;
        if (session != null) {
            if (FILL_COLOR_PROPERTY_ID.equals(propertyId)) {
                colorCategoryManager = new FillColorCategoryManager(session, editParts);
            } else if (LINE_COLOR_PROPERTY_ID.equals(propertyId)) {
                colorCategoryManager = new LineColorCategoryManager(session, editParts);
            } else if (FONT_COLOR_PROPERTY_ID.equals(propertyId)) {
                colorCategoryManager = new FontColorCategoryManager(session, editParts);
            }
        }
        return colorCategoryManager;
    }
}

