/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xml.utilities;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.xml.Attribute;
import org.eclipse.qvtd.xml.CDATA;
import org.eclipse.qvtd.xml.Characters;
import org.eclipse.qvtd.xml.ClassAttribute;
import org.eclipse.qvtd.xml.ClassElement;
import org.eclipse.qvtd.xml.Comment;
import org.eclipse.qvtd.xml.DTD;
import org.eclipse.qvtd.xml.DataTypeAttribute;
import org.eclipse.qvtd.xml.DataTypeElement;
import org.eclipse.qvtd.xml.Document;
import org.eclipse.qvtd.xml.Element;
import org.eclipse.qvtd.xml.Entity;
import org.eclipse.qvtd.xml.Node;
import org.eclipse.qvtd.xml.PrefixMapping;
import org.eclipse.qvtd.xml.ProcessingInstruction;
import org.eclipse.qvtd.xml.XMLmodelFactory;
import org.eclipse.qvtd.xml.XMLmodelPackage;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLmodelResourceImpl
extends XMIResourceImpl {
    public static final @NonNull String IGNORE_ECORE = "ignore-ecore";

    public XMLmodelResourceImpl(URI uri) {
        super(uri);
    }

    protected XMLLoad createXMLLoad() {
        return new XMLmodelLoadImpl(this.createXMLHelper());
    }

    protected XMLLoad createXMLLoad(Map<?, ?> options) {
        return this.createXMLLoad();
    }

    protected XMLSave createXMLSave() {
        return new XMLmodelSave(this.createXMLHelper());
    }

    protected XMLSave createXMLSave(Map<?, ?> options) {
        return this.createXMLSave();
    }

    protected static class XMLStringBuilder {
        private StringBuilder s = new StringBuilder();
        private int currentColumn = 0;
        private Stack<@NonNull String> elementNameStack = new Stack();
        private StringBuilder attributeBuilder = new StringBuilder(256);
        private @NonNull String lineSeparator;
        private int lineWidth;
        private XMLstate xmlState = XMLstate.OUTSIDE;

        public XMLStringBuilder(@NonNull String lineSeparator, int lineWidth) {
            this.lineSeparator = lineSeparator;
            this.lineWidth = lineWidth;
        }

        public void add(@NonNull String string) {
            this.append(string);
        }

        public void addAttributeContent(@NonNull String content) {
            assert (this.attributeBuilder.length() > 0);
            this.attributeBuilder.append(content);
        }

        public void addCDATA(@NonNull String characters) {
            this.appendOuterElementClose();
            this.s.append("<![CDATA[");
            this.s.append(characters);
            this.s.append("]]>");
            this.addLine();
        }

        public void addCharacters(@NonNull String characters) {
            this.appendOuterElementClose();
            this.append(characters);
        }

        public void addComment(@NonNull String string) {
            this.appendOuterElementClose();
            this.addLine();
            this.append("<!--" + string + "-->");
            this.addLine();
        }

        public void addLine() {
            if (this.currentColumn > 0) {
                this.s.append(this.lineSeparator);
                this.currentColumn = 0;
            }
        }

        public void addProcessingInstruction(@Nullable String target, @Nullable String data) {
            this.appendOuterElementClose();
            this.addLine();
            this.s.append("<?");
            this.s.append(target == null ? "_" : target);
            if (data != null) {
                this.s.append(" ");
                this.s.append(data);
            }
            this.s.append("?>");
            this.addLine();
        }

        protected void append(@NonNull String string) {
            int length = string.length();
            if (length > 0) {
                int indentColumn = (this.elementNameStack.size() + (this.attributeBuilder.length() > 0 ? 1 : 0)) * 2;
                while (this.currentColumn < indentColumn) {
                    this.s.append(' ');
                    ++this.currentColumn;
                }
                this.s.append(string);
                this.currentColumn += length;
            }
        }

        protected void appendOuterElementClose() {
            assert (this.attributeBuilder.length() <= 0);
            assert (this.xmlState != XMLstate.OUTSIDE);
            if (this.xmlState == XMLstate.HAS_ELEMENT_OPEN) {
                this.append(">");
                this.xmlState = XMLstate.HAS_ELEMENT_CLOSE;
            }
        }

        public void endAttribute() {
            assert (this.attributeBuilder.length() > 0);
            this.attributeBuilder.append("\"");
            int length = this.attributeBuilder.length();
            if (this.currentColumn + 1 + length > this.lineWidth) {
                this.addLine();
            } else {
                this.append(" ");
            }
            this.append(this.attributeBuilder.toString());
            this.attributeBuilder.replace(0, length, "");
        }

        public void endContentElement(@NonNull String contentElement) {
            this.append(">");
            this.addLine();
        }

        public void endElement() {
            assert (this.xmlState != XMLstate.OUTSIDE);
            assert (this.attributeBuilder.length() <= 0);
            String qName = this.elementNameStack.pop();
            this.append((String)(this.xmlState == XMLstate.HAS_ELEMENT_CLOSE ? "</" + qName + ">" : "/>"));
            this.addLine();
            this.xmlState = this.elementNameStack.isEmpty() ? XMLstate.OUTSIDE : XMLstate.HAS_ELEMENT_CLOSE;
        }

        public void startAttribute(@NonNull String name) {
            assert (this.xmlState == XMLstate.HAS_ELEMENT_OPEN);
            assert (this.attributeBuilder.length() <= 0);
            this.attributeBuilder.append(name);
            this.attributeBuilder.append("=\"");
        }

        public void startElement(@NonNull String qName) {
            if (this.xmlState != XMLstate.OUTSIDE) {
                this.appendOuterElementClose();
            }
            this.addLine();
            this.append("<" + qName);
            this.elementNameStack.push(qName);
            this.xmlState = XMLstate.HAS_ELEMENT_OPEN;
        }

        public void write(@NonNull Writer os, int flushThreshold) throws IOException {
            String s2 = this.s.toString();
            assert (this.xmlState == XMLstate.OUTSIDE);
            os.write(s2);
        }

        public void writeAscii(@NonNull OutputStream os, int flushThreshold) throws IOException {
            String s2 = this.s.toString();
            assert (this.xmlState == XMLstate.OUTSIDE);
            os.write(s2.getBytes());
        }

        protected static enum XMLstate {
            OUTSIDE,
            HAS_ELEMENT_OPEN,
            HAS_ELEMENT_CLOSE;

        }
    }

    protected static class XMLmodelHandler
    extends DefaultHandler
    implements LexicalHandler {
        private ResourceSet resourceSet = new ResourceSetImpl();
        private XMLResource xmlResource;
        private Document document = null;
        private @NonNull Stack<@NonNull Node> nodeStack = new Stack();
        private boolean useEcore;
        protected final @NonNull Map<@NonNull String, @NonNull String> xmlns2uri = new HashMap<String, String>();
        protected final @NonNull Map<@NonNull String, @NonNull EPackage> xmlns2ePackage = new HashMap<String, EPackage>();
        protected final @NonNull Map<@NonNull String, @NonNull String> uri2schemaLocation = new HashMap<String, String>();
        protected final @NonNull Map<@NonNull String, @NonNull Element> xmiid2element = new HashMap<String, Element>();

        public XMLmodelHandler(XMLResource xmlResource, XMLHelper helper, Map<?, ?> options) {
            this.xmlResource = xmlResource;
            this.useEcore = options == null || options.get(XMLmodelResourceImpl.IGNORE_ECORE) != Boolean.TRUE;
        }

        protected void addError(@NonNull String string) {
            this.xmlResource.getErrors().add((Object)new XMIException(string));
        }

        protected void addNode(Node node) {
            if (this.nodeStack.isEmpty()) {
                this.document.getChildren().add((Object)node);
            } else {
                this.nodeStack.peek().getChildren().add((Object)node);
            }
        }

        protected void addWarning(@NonNull String string) {
            this.xmlResource.getWarnings().add((Object)new XMIException(string));
        }

        protected @Nullable Element basicGetChildElement(@NonNull Element parentElement, @NonNull String pathElement) {
            if (pathElement.length() <= 0) {
                return this.basicGetChildElementByIndex(parentElement, 0);
            }
            char firstChar = pathElement.charAt(0);
            if (firstChar == '@') {
                String childName;
                int childIndex = -1;
                int index = pathElement.indexOf(46);
                if (index >= 0) {
                    childName = pathElement.substring(1, index);
                    childIndex = Integer.valueOf(pathElement.substring(index + 1));
                } else {
                    childName = pathElement.substring(1);
                    childIndex = 0;
                }
                return this.basicGetChildElementByName(parentElement, childName, childIndex);
            }
            if (Character.isDigit(firstChar)) {
                int childIndex = Integer.valueOf(pathElement);
                return this.basicGetChildElementByIndex(parentElement, childIndex);
            }
            return this.basicGetChildElementByEClassName(parentElement, pathElement);
        }

        protected @Nullable Element basicGetChildElementByEClassName(@NonNull Element parentElement, @NonNull String childName) {
            for (Node childNode : parentElement.getChildren()) {
                if (!(childNode instanceof Element)) continue;
                Element childElement = (Element)childNode;
                for (Node grandchildNode : childElement.getChildren()) {
                    DataTypeAttribute grandchildElement;
                    if (!(grandchildNode instanceof DataTypeAttribute) || (grandchildElement = (DataTypeAttribute)grandchildNode).getEcoreAttribute() != EcorePackage.Literals.ENAMED_ELEMENT__NAME || !childName.equals(grandchildElement.getValue())) continue;
                    return childElement;
                }
            }
            return null;
        }

        protected @Nullable Element basicGetChildElementByIndex(@NonNull Element parentElement, int childElementIndex) {
            int matchIndex = 0;
            for (Node childNode : parentElement.getChildren()) {
                if (!(childNode instanceof Element)) continue;
                Element childElement = (Element)childNode;
                if (matchIndex == childElementIndex) {
                    return childElement;
                }
                ++matchIndex;
            }
            return null;
        }

        protected @Nullable Element basicGetChildElementByName(@NonNull Element parentElement, @NonNull String childName, int childIndex) {
            int matchIndex = 0;
            for (Node childNode : parentElement.getChildren()) {
                Element childElement;
                if (!(childNode instanceof Element) || !childName.equals((childElement = (Element)childNode).getQName())) continue;
                if (matchIndex == childIndex) {
                    return childElement;
                }
                ++matchIndex;
            }
            return null;
        }

        protected @Nullable Element basicGetElementForPath(List<String> uriFragmentPath) {
            int size = uriFragmentPath.size();
            Element element = this.getRootElement(size == 0 ? "" : uriFragmentPath.get(0));
            int i = 1;
            while (i < size && element != null) {
                String uriFragmentSegment = uriFragmentPath.get(i);
                element = this.basicGetChildElement(element, uriFragmentSegment);
                ++i;
            }
            return element;
        }

        private @Nullable EPackage basicGetEPackage(@NonNull String prefix) {
            return this.xmlns2ePackage.get(prefix);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            boolean isWhite = true;
            int i = 0;
            while (i < length) {
                char c = ch[start + i];
                if (!Character.isWhitespace(c)) {
                    isWhite = false;
                    break;
                }
                ++i;
            }
            if (!isWhite) {
                String characterText = new String(ch, start, length);
                Characters characters = XMLmodelFactory.eINSTANCE.createCharacters();
                characters.setData(characterText);
                this.addNode(characters);
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) {
            Comment comment = XMLmodelFactory.eINSTANCE.createComment();
            comment.setData(new String(ch, start, length));
            this.addNode(comment);
        }

        @Override
        public void endCDATA() {
            this.nodeStack.pop();
        }

        @Override
        public void endDTD() {
            this.nodeStack.pop();
        }

        @Override
        public void endDocument() {
            this.xmlResource.getContents().add((Object)this.document);
            this.resolveReferences(this.document);
            this.document = null;
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            Element oldElement;
            Object id;
            EAttribute idAttribute;
            ClassElement element;
            EClass ecoreClass;
            Node node = this.nodeStack.pop();
            if (node instanceof ClassElement && (ecoreClass = (element = (ClassElement)node).getEcoreClass()) != null && (idAttribute = ecoreClass.getEIDAttribute()) != null && (id = element.eGet((EStructuralFeature)idAttribute)) != null && (oldElement = this.xmiid2element.put(String.valueOf(id), element)) != null) {
                this.addError("Ambiguous xmi:id '" + String.valueOf(id) + "'");
            }
        }

        @Override
        public void endEntity(String name) {
            this.nodeStack.pop();
        }

        @Override
        public void endPrefixMapping(String prefix) {
            this.nodeStack.pop();
        }

        protected @Nullable EClassifier getEClassifier(@NonNull String qName) {
            EClassifier eClassifier;
            EPackage ePackage;
            String prefix = "";
            int colonIndex = qName.indexOf(":");
            String suffix = qName;
            if (colonIndex >= 0) {
                prefix = qName.substring(0, colonIndex);
                suffix = qName.substring(colonIndex + 1);
            }
            if ((ePackage = this.getEPackage(prefix)) != null && (eClassifier = ePackage.getEClassifier(suffix)) != null) {
                return eClassifier;
            }
            this.addError("Failed to locate an EClassifier for '" + qName + "'");
            return null;
        }

        protected @Nullable EPackage getEPackage(@NonNull String prefix) {
            String uri;
            EPackage ePackage = this.xmlns2ePackage.get(prefix);
            if (ePackage == null && (uri = this.getURIofXMLNS(prefix)) != null && !"http://www.omg.org/XMI".equals(uri)) {
                ePackage = this.resourceSet.getPackageRegistry().getEPackage(uri);
                if (ePackage instanceof EPackage.Descriptor) {
                    ePackage = ((EPackage.Descriptor)ePackage).getEPackage();
                }
                if (ePackage != null) {
                    this.xmlns2ePackage.put(prefix, ePackage);
                } else if (!this.xmlns2ePackage.containsKey(prefix)) {
                    this.xmlns2ePackage.put(prefix, null);
                    if (this.useEcore) {
                        this.addError("Failed to locate EPackage for '" + uri + "'");
                    }
                }
            }
            return ePackage;
        }

        protected @Nullable Element getElementAtChildIndex(@NonNull Node node, int index) {
            int elementIndex = 0;
            for (Node child : node.getChildren()) {
                if (!(child instanceof Element)) continue;
                if (elementIndex == index) {
                    return (Element)child;
                }
                ++elementIndex;
            }
            return null;
        }

        protected @Nullable Element getElement(@NonNull String uriFragment) {
            Element element;
            int length = uriFragment.length();
            if (length > 0) {
                int index;
                if (uriFragment.charAt(0) == '/') {
                    List path = SegmentSequence.create((String)"/", (String)uriFragment).subSegmentsList(1);
                    Element element2 = this.basicGetElementForPath(path);
                    if (element2 == null) {
                        this.addError("Failed to resolve '" + uriFragment + "'");
                    }
                    return element2;
                }
                if (uriFragment.charAt(length - 1) == '?' && (index = uriFragment.lastIndexOf(63, length - 2)) > 0) {
                    uriFragment = uriFragment.substring(0, index);
                }
            }
            if ((element = this.xmiid2element.get(uriFragment)) == null) {
                this.addError("Failed to resolve xmi:id '" + uriFragment + "'");
            }
            return element;
        }

        protected @Nullable Element getRootElement(String uriFragmentRootSegment) {
            Node onlyChild;
            Node rootElement;
            EList<Node> rootChildren;
            int position = 0;
            if (uriFragmentRootSegment.length() > 0) {
                if (uriFragmentRootSegment.charAt(0) == '?') {
                    return this.xmiid2element.get(uriFragmentRootSegment.substring(1));
                }
                try {
                    position = Integer.parseInt(uriFragmentRootSegment);
                }
                catch (NumberFormatException exception) {
                    throw new WrappedException((Exception)exception);
                }
            }
            if ((rootChildren = (rootElement = this.document).getChildren()).size() == 1 && (onlyChild = (Node)rootChildren.get(0)).eClass() == XMLmodelPackage.Literals.ELEMENT) {
                rootElement = onlyChild;
            }
            return this.getElementAtChildIndex(rootElement, position);
        }

        protected @Nullable String getURIofXMLNS(@NonNull String xmlnsPrefix) {
            String value = this.xmlns2uri.get(xmlnsPrefix);
            if (value == null) {
                this.addError("Unresolved XMLNS prefix '" + xmlnsPrefix + "'");
            }
            return value;
        }

        protected @Nullable EClassifier getXsiType(@NonNull Attributes attributes) {
            int length = attributes.getLength();
            int index = 0;
            while (index < length) {
                String qName = attributes.getQName(index);
                if (this.qNameEquals(qName, "http://www.omg.org/XMI", "type") || this.qNameEquals(qName, "http://www.w3.org/2001/XMLSchema-instance", "type")) {
                    String value = attributes.getValue(index);
                    return this.getEClassifier(value);
                }
                ++index;
            }
            return null;
        }

        protected void processAttribute(@NonNull Element element, @NonNull String attributeQName, @NonNull String value) {
            Attribute attribute = null;
            Element childElement = null;
            int colonIndex = attributeQName.indexOf(58);
            if (colonIndex >= 0) {
                Element oldElement;
                attribute = XMLmodelFactory.eINSTANCE.createAttribute();
                if (this.qNameEquals(attributeQName, "http://www.omg.org/XMI", "id") && (oldElement = this.xmiid2element.put(value, element)) != null) {
                    this.addError("Ambiguous xmi:id '" + value + "'");
                }
            } else if ("xmlns".equals(attributeQName)) {
                attribute = XMLmodelFactory.eINSTANCE.createAttribute();
            } else {
                EClassifier ecoreClassifier = element.getEcoreClassifier();
                if (ecoreClassifier == null) {
                    attribute = XMLmodelFactory.eINSTANCE.createAttribute();
                } else if (ecoreClassifier instanceof EClass) {
                    EStructuralFeature eFeature = ((EClass)ecoreClassifier).getEStructuralFeature(attributeQName);
                    if (eFeature instanceof EAttribute) {
                        DataTypeAttribute dataTypeAttribute = XMLmodelFactory.eINSTANCE.createDataTypeAttribute();
                        dataTypeAttribute.setEcoreAttribute((EAttribute)eFeature);
                        attribute = dataTypeAttribute;
                    } else {
                        ClassAttribute classAttribute = XMLmodelFactory.eINSTANCE.createClassAttribute();
                        classAttribute.setEcoreReference((EReference)eFeature);
                        attribute = classAttribute;
                    }
                } else if (ecoreClassifier instanceof EDataType) {
                    DataTypeElement dataTypeElement = XMLmodelFactory.eINSTANCE.createDataTypeElement();
                    dataTypeElement.setEcoreDataType((EDataType)ecoreClassifier);
                    childElement = dataTypeElement;
                } else {
                    childElement = XMLmodelFactory.eINSTANCE.createElement();
                }
            }
            if (attribute != null) {
                attribute.setName(attributeQName);
                attribute.setValue(value);
                element.getChildren().add((Object)attribute);
            } else if (childElement != null) {
                element.getChildren().add(childElement);
            }
        }

        protected void processRootAttributes(@NonNull Attributes attributes) {
            int length = attributes.getLength();
            int index = 0;
            while (index < length) {
                String newValue;
                String oldValue;
                String xmlns = null;
                String qName = attributes.getQName(index);
                int colonIndex = qName.indexOf(58);
                if (colonIndex >= 0) {
                    String prefix = qName.substring(0, colonIndex);
                    if ("xmlns".equals(prefix)) {
                        xmlns = qName.substring(colonIndex + 1);
                    }
                } else if ("xmlns".equals(qName)) {
                    xmlns = "";
                }
                if (xmlns != null && (oldValue = this.xmlns2uri.put(xmlns, newValue = attributes.getValue(index))) != null) {
                    this.addError("Conflicting '" + xmlns + "' XMLNS values '" + oldValue + "' and '" + newValue + "'");
                }
                ++index;
            }
            index = 0;
            while (index < length) {
                String prefix;
                String qName = attributes.getQName(index);
                int colonIndex = qName.indexOf(58);
                if (colonIndex >= 0 && !"xmlns".equals(prefix = qName.substring(0, colonIndex))) {
                    String suffix = qName.substring(colonIndex + 1);
                    String uri = this.getURIofXMLNS(prefix);
                    if ("http://www.w3.org/2001/XMLSchema-instance".equals(uri) && "schemaLocation".equals(suffix)) {
                        String oldValue;
                        String value = attributes.getValue(index);
                        int spaceIndex = value.indexOf(32);
                        String schemaLocation = value;
                        String schemaURI = "";
                        if (spaceIndex >= 0) {
                            schemaLocation = value.substring(spaceIndex + 1).trim();
                            schemaURI = value.substring(spaceIndex);
                        }
                        if ((oldValue = this.uri2schemaLocation.put(schemaURI, schemaLocation)) != null) {
                            this.addError("Conflicting '" + schemaURI + "' schemaLocation values '" + oldValue + "' and '" + schemaLocation + "'");
                        }
                    }
                }
                ++index;
            }
        }

        @Override
        public void processingInstruction(String target, String data) {
            ProcessingInstruction processingInstruction = XMLmodelFactory.eINSTANCE.createProcessingInstruction();
            processingInstruction.setTarget(target);
            processingInstruction.setData(data);
            this.addNode(processingInstruction);
        }

        protected boolean qNameEquals(@NonNull String qName, @NonNull String uri, @NonNull String name) {
            int colonIndex = qName.indexOf(58);
            if (colonIndex < 0) {
                if (!uri.equals(this.xmlns2uri.get(""))) {
                    return false;
                }
                return name.equals(qName);
            }
            String prefix = qName.substring(0, colonIndex);
            if (!uri.equals(this.xmlns2uri.get(prefix))) {
                return false;
            }
            String suffix = qName.substring(colonIndex + 1);
            return name.equals(suffix);
        }

        protected void resolveReferences(@NonNull Node node) {
            if (node instanceof ClassAttribute) {
                ClassAttribute classAttribute = (ClassAttribute)node;
                String[] values = classAttribute.getValue().split(" ");
                int i = 0;
                while (i < values.length) {
                    String nextValue;
                    int nextHashIndex;
                    EClassifier eClassifier = classAttribute.getEcoreReference().getEType();
                    String value = values[i].trim();
                    int hashIndex = value.indexOf(35);
                    if (hashIndex < 0 && i + 1 < values.length && (nextHashIndex = (nextValue = values[i + 1].trim()).indexOf(35)) > 0) {
                        eClassifier = this.getEClassifier(value);
                        ++i;
                        value = nextValue;
                        hashIndex = nextHashIndex;
                    }
                    if (value.length() > 0) {
                        Element resolvedElement = null;
                        if (hashIndex <= 0) {
                            resolvedElement = this.getElement(hashIndex < 0 ? value : value.substring(1));
                        }
                        if (resolvedElement == null) {
                            resolvedElement = eClassifier.getEPackage().getEFactoryInstance().create((EClass)eClassifier);
                            ((BasicEObjectImpl)resolvedElement).eSetProxyURI(URI.createURI((String)value));
                        }
                        classAttribute.getEObjects().add(resolvedElement);
                    }
                    ++i;
                }
            }
            for (Node child : node.getChildren()) {
                this.resolveReferences(child);
            }
        }

        @Override
        public void startCDATA() {
            CDATA cdata = XMLmodelFactory.eINSTANCE.createCDATA();
            this.addNode(cdata);
            this.nodeStack.push(cdata);
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) {
            DTD dtd = XMLmodelFactory.eINSTANCE.createDTD();
            dtd.setName(name);
            dtd.setPublicId(publicId);
            dtd.setSystemId(systemId);
            this.addNode(dtd);
            this.nodeStack.push(dtd);
        }

        @Override
        public void startDocument() {
            this.document = XMLmodelFactory.eINSTANCE.createDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Element element;
            if (this.nodeStack.isEmpty()) {
                this.processRootAttributes(attributes);
            }
            EPackage ecorePackage = null;
            EClassifier ecoreClassifier = null;
            String name = qName;
            int colonIndex = qName.indexOf(58);
            if (colonIndex >= 0) {
                String prefix = qName.substring(0, colonIndex);
                name = qName.substring(colonIndex + 1);
                ecorePackage = this.getEPackage(prefix);
                if (ecorePackage != null && (ecoreClassifier = ecorePackage.getEClassifier(name)) == null) {
                    this.addError("Failed to locate EClassifier '" + name + "' in '" + ecorePackage.getNsURI() + "'");
                }
            } else {
                ecoreClassifier = this.getXsiType(attributes);
                if (ecoreClassifier == null) {
                    ecorePackage = this.basicGetEPackage("");
                    if (ecorePackage != null) {
                        ecoreClassifier = ecorePackage.getEClassifier(name);
                        if (ecoreClassifier == null) {
                            this.addError("Failed to locate EClassifier '" + name + "' in '" + ecorePackage.getNsURI() + "'");
                        }
                    } else {
                        Element container = (Element)this.nodeStack.peek();
                        EClassifier ecoreContainerClassifier = container.getEcoreClassifier();
                        if (ecoreContainerClassifier instanceof EClass) {
                            EStructuralFeature eStructuralFeature = ((EClass)ecoreContainerClassifier).getEStructuralFeature(name);
                            if (eStructuralFeature != null) {
                                ecoreClassifier = eStructuralFeature.getEType();
                            } else {
                                this.addError("Failed to locate EStructuralFeature '" + name + "' in '" + ecoreContainerClassifier.getName() + "'");
                            }
                        } else {
                            boolean cfr_ignored_0 = ecoreContainerClassifier instanceof EDataType;
                        }
                    }
                }
            }
            if (ecoreClassifier instanceof EClass) {
                ClassElement classElement = XMLmodelFactory.eINSTANCE.createClassElement();
                classElement.setEcoreClass((EClass)ecoreClassifier);
                element = classElement;
            } else if (ecoreClassifier instanceof EDataType) {
                DataTypeElement dataTypeElement = XMLmodelFactory.eINSTANCE.createDataTypeElement();
                dataTypeElement.setEcoreDataType((EDataType)ecoreClassifier);
                element = dataTypeElement;
            } else {
                element = XMLmodelFactory.eINSTANCE.createElement();
            }
            element.setUri(uri);
            element.setLocalName(localName);
            element.setQName(qName);
            int length = attributes.getLength();
            int index = 0;
            while (index < length) {
                String attributeQName = attributes.getQName(index);
                String value = attributes.getValue(index);
                this.processAttribute(element, attributeQName, value);
                ++index;
            }
            this.addNode(element);
            this.nodeStack.push(element);
        }

        @Override
        public void startEntity(String name) {
            Entity entity = XMLmodelFactory.eINSTANCE.createEntity();
            entity.setName(name);
            this.addNode(entity);
            this.nodeStack.push(entity);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            PrefixMapping prefixMapping = XMLmodelFactory.eINSTANCE.createPrefixMapping();
            prefixMapping.setPrefix(prefix);
            prefixMapping.setUri(uri);
            this.addNode(prefixMapping);
            this.nodeStack.push(prefixMapping);
        }
    }

    protected static class XMLmodelLoadImpl
    extends XMILoadImpl {
        private SAXParser makeParser = null;

        public XMLmodelLoadImpl(XMLHelper helper) {
            super(helper);
        }

        protected DefaultHandler makeDefaultHandler() {
            XMLmodelHandler handler = new XMLmodelHandler(this.resource, this.helper, this.options);
            try {
                this.makeParser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return handler;
        }

        protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
            this.makeParser = super.makeParser();
            return this.makeParser;
        }
    }

    protected static class XMLmodelSave
    extends XMISaveImpl {
        private XMLStringBuilder doc2;

        public XMLmodelSave(XMLHelper helper) {
            super(helper);
        }

        private @NonNull String getCharacters(@NonNull Node node) {
            StringBuilder s = new StringBuilder();
            for (Node child : node.getChildren()) {
                if (!(child instanceof Characters)) continue;
                s.append(((Characters)child).getData());
            }
            return s.toString();
        }

        protected void init(XMLResource resource, Map<?, ?> options) {
            String lineSeparator;
            Integer lineWidth = (Integer)options.get("LINE_WIDTH");
            if (lineWidth == null) {
                lineWidth = Integer.MAX_VALUE;
            }
            if ((lineSeparator = (String)options.get("LINE_DELIMITER")) == null || lineSeparator.equals("")) {
                lineSeparator = System.getProperty("line.separator");
            }
            super.init(resource, options);
            this.doc2 = new XMLStringBuilder(lineSeparator, lineWidth);
        }

        public void traverse(List<? extends EObject> contents) {
            this.doc2.add("<?xml version=\"" + this.xmlVersion + "\" encoding=\"" + this.encoding + "\"?>");
            this.traverseElements(contents);
        }

        protected void traverseElements(List<? extends EObject> contents) {
            for (EObject eObject : contents) {
                Node cdata;
                if (eObject instanceof Document) {
                    this.traverseElements((List<? extends EObject>)((Document)eObject).getChildren());
                    continue;
                }
                if (eObject instanceof Element) {
                    Element element = (Element)eObject;
                    this.doc2.startElement(element.getQName());
                    this.traverseElements((List<? extends EObject>)element.getChildren());
                    this.doc2.endElement();
                    continue;
                }
                if (eObject instanceof Attribute) {
                    Attribute attribute = (Attribute)eObject;
                    this.doc2.startAttribute(attribute.getName());
                    this.doc2.addAttributeContent(this.escape.convert(attribute.getValue()));
                    this.doc2.endAttribute();
                    continue;
                }
                if (eObject instanceof Comment) {
                    Comment comment = (Comment)eObject;
                    this.doc2.addComment(comment.getData());
                    continue;
                }
                if (eObject instanceof Characters) {
                    Characters characters = (Characters)eObject;
                    String data = characters.getData();
                    this.doc2.addCharacters(data);
                    continue;
                }
                if (eObject instanceof CDATA) {
                    cdata = (CDATA)eObject;
                    this.doc2.addCDATA(this.getCharacters(cdata));
                    continue;
                }
                if (eObject instanceof DTD) {
                    cdata = (DTD)eObject;
                    continue;
                }
                if (eObject instanceof Entity) {
                    cdata = (Entity)eObject;
                    continue;
                }
                if (!(eObject instanceof ProcessingInstruction)) continue;
                ProcessingInstruction processingInstruction = (ProcessingInstruction)eObject;
                this.doc2.addProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
            }
        }

        public void write(Writer os) throws IOException {
            this.doc2.write(os, this.flushThreshold);
            os.flush();
        }

        public void writeAscii(OutputStream os) throws IOException {
            this.doc2.writeAscii(os, this.flushThreshold);
            os.flush();
        }
    }
}

